flashcardData = {"Title":"Switch Statement Utilizing Character Input","Description":"The learner will review code and answer questions about a switch statement.","IsRandomAllowed":false,"Questions":[{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>All the flashcards in this set deal with the code below:</p><p><span style=\"color: rgb(255, 0, 0);\">int currentPin;</span></p><p><span style=\"color: rgb(255, 0, 0);\">void setup()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;Serial.begin(9600);</span><br></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;for (currentPin = 0; currentPin &lt; 8; currentPin++)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; pinMode(currentPin, OUTPUT);</span></p><p><span style=\"color: rgb(255, 0, 0);\">}</span></p><p><span style=\"color: rgb(255, 0, 0);\">void main()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;char inByte;</span></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;if (Serial.available() &gt; 0)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; inByte = Serial.read();</span></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; switch (inByte)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; {</span></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;case 'a':</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; digitalWrite(1, HIGH);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;case 'b':</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; digitalWrite(2, HIGH);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;case 'c':</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; digitalWrite(4, HIGH);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;case 'd':</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; digitalWrite(5, HIGH);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;case 'e':</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; digitalWrite(7, HIGH);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;default:</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; for (currentPin = 0; currentPin &lt; 8; currentPin++)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;digitalWrite(currentPin, LOW);</span></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; }</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;}</span><br><span style=\"color: rgb(255, 0, 0);\">}</span></p><p>This code is displayed in the image below, which will be on each card, but you may want to make note of it before going on.</p>\r\n</body>\r\n</html>","Id":5210,"Feedback":null,"HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Got it!</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19772}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: All lights will be turned off if the character 'A' is received.</p>\r\n</body>\r\n</html>","Id":5211,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since <span style=\"color: rgb(255, 0, 0);\">Serial.read</span> returns the first byte of information and 'A' is not represented by the same byte as 'a', the switch statement will go to its default case and set all the pins to LOW.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19773},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19774}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Which output is set to high if the character 'b' is received?</p>\r\n</body>\r\n</html>","Id":5212,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>This is <span style=\"color: rgb(255, 0, 0);\">case 'b'</span>, so the code under it will be executed, first <span style=\"color: rgb(255, 0, 0);\">digitalWrite(2, HIGH);</span> setting output 2 to high, then <span style=\"color: rgb(255, 0, 0);\">break;</span> ending the switch statement.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19775},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>2</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19776},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>3</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19779},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>4</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19780}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Will the switch statement be executed if there is no serial input?</p>\r\n</body>\r\n</html>","Id":5213,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The switch statement will only execute if there is actual input, which is what&nbsp;<span style=\"color: rgb(255, 0, 0);\">Serial.available() &gt; 0</span>&nbsp;is checking for.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Yes</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19777},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>No</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19778}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If the input received is 'E', will digital output 7 be turned on?</p>\r\n</body>\r\n</html>","Id":5214,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since <span style=\"color: rgb(255, 0, 0);\">Serial.read</span> returns the first byte of information and 'E' is not represented by the same byte as 'e', the switch statement will go to its default case and set all the pins to LOW.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Yes</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19781},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>No</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19782}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The variable inByte could be of type integer and the program would function the same.</p>\r\n</body>\r\n</html>","Id":5215,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since <span style=\"color: rgb(255, 0, 0);\">Serial.read</span> returns the first byte of information, it will read the inputs and compare them to the cases (as written) the same if inByte is a char variable type or an int variable type.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19783},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19784}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>What is the scope of the <span style=\"color: rgb(255, 0, 0);\">currentPin</span> variable?</p>\r\n</body>\r\n</html>","Id":5216,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The <span style=\"color: rgb(255, 0, 0);\">currentPin</span> variable is declared outside of any of the functions, so it has global scope.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Local</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19785},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Global</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19786},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Not scoped</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19787},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Unknown</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19788}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The decision that determines which output is turned on is based on what?</p>\r\n</body>\r\n</html>","Id":5217,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The switch command has <span style=\"color: rgb(255, 0, 0);\">inByte</span> as its argument, so the value of <span style=\"color: rgb(255, 0, 0);\">inByte</span> is what the cases are checked against.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>inByte</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19789},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>currentPin</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19790},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Serial.begin function</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19791},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>digitalWrite function</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19792}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The switch statement is used to handle what?</p>\r\n</body>\r\n</html>","Id":5218,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The argument of the switch function needs to be easily comparable using an equality comparison, which limits our options (basically) to those in the correct answer: char, Boolean, and int.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch with Comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>only known values</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19793},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>data that is Float type</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19794},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>data that is char, Boolean, or integer type</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19795},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>none of the above</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19796}]}]};