flashcardData = {"Title":"Switch Statement on Map Command","Description":"The learner will review code and answer questions about the results of using a switch statement on a variable created using the map command.","IsRandomAllowed":false,"Questions":[{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>All the flashcards in this set deal with the code below:</p><p><span style=\"color: rgb(255, 0, 0);\">const int sensorMin = 0;</span><br><span style=\"color: rgb(255, 0, 0);\">const int sensorMax = 100;</span></p><p><span style=\"color: rgb(255, 0, 0);\">int range;</span></p><p></p><p><span style=\"color: rgb(255, 0, 0);\">void setup()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span></p><p></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;Serial.begin(9600);</span></p><p></p><p><span style=\"color: rgb(255, 0, 0);\">}</span></p><p></p><p><span style=\"color: rgb(255, 0, 0);\">void main()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span></p><p></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;int sensorReading = analogRead(0);</span></p><p></p><p><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;range = map(sensorReading, sensorMin, sensorMax, 0, 3);</span><br> <br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;switch (range)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;case 0:</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; Serial.println(\"dark\");</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;case 1:</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; Serial.println(\"dim\");</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;case 2:</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; Serial.println(\"medium\");</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;case 3:</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; Serial.println(\"bright\");</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; break;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;default:</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; Serial.println(\"invalid input\");</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;}</span><br><span style=\"color: rgb(255, 0, 0);\">}</span></p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\"></span></p><p>This code is displayed in the image below, which will be on each card, but you may want to make note of it before going on.<br></p>\r\n</body>\r\n</html>","Id":5219,"Feedback":null,"HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Got it!</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19797}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>How many unique cases does the switch statement in this program have? &nbsp;(Do not count the default case.)</p>\r\n</body>\r\n</html>","Id":5220,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>There are four cases, case 0, case 1, case 2, and case 3.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19798},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>3</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19799},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>4</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19800},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>5</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19801}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Suppose our sensor reading maps to 2. &nbsp;What would be printed?</p>\r\n</body>\r\n</html>","Id":5221,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If the reading is mapped to 2, we will be in case 2 which has lines <span style=\"color: rgb(255, 0, 0);\">Serial.println(\"medium\");</span> and <span style=\"color: rgb(255, 0, 0);\">break;</span> so the case 2 will print medium.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dark</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19802},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dim</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19803},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>medium</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19804},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>bright</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19805}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The default case is executed if the range variable is not 0, 1, 2, or 3. &nbsp;</p>\r\n</body>\r\n</html>","Id":5228,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>When a switch is done checking its cases, if it has not executed one of them, it will execute the code after default instead.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19821},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19822}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: In this example, more than one case can be true at the same time.</p>\r\n</body>\r\n</html>","Id":5229,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Once the sensor is read and the result is mapped to range, range will have exactly one value, either 0, 1, 2, or 3. &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19823},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19824}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: Range could be of type float.</p>\r\n</body>\r\n</html>","Id":5230,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>We should never use float variables for values we are going to test for equality or as arguments in functions that take integer arguments. &nbsp;The switch here is testing equality in each case, so it should not be used with a float variable.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19825},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19826}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If there were no <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">break;</span> command at the end of case 0, what would the output of that case be?</p>\r\n</body>\r\n</html>","Id":5231,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>So our program would look like:</p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">case 0:</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;Serial.println(\"dark\");</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">case 1:</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;Serial.println(\"dim\");</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;break;</span></p><p>So, if we look at the code in case 0, the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">Serial.println(\"dark\");</span> will print dark. &nbsp;Since the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">break;</span>&nbsp;is missing, the switch will continue to execute the code it finds until it reaches a <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">break;</span> (or the end of the switch statement). &nbsp;Therefore, the code under case 1 will be executed as well; <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">Serial.println(\"dim\")</span> will print dim, and then <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">break;</span> will end the switch. &nbsp;Thus, the program modified as above will print dark and then dim.<br></p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dark</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19827},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dim</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19828},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dark &amp; dim</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19829},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dark, dim, medium, &amp; bright</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19830}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The case statement is somewhat like nested if - else statements.</p>\r\n</body>\r\n</html>","Id":5232,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Case statements function very much like if - else statements, first checking one condition, then checking another condition (else if) etc. &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19831},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19832},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Depends</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19833}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>What would the output be if there were no default statement and range was equal to 4?</p>\r\n</body>\r\n</html>","Id":5233,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Without the default statement, a switch will not execute any of its code if it reaches the end of the case list without matching its input. &nbsp;So if the default statement was not here and range was 4, it would look through all the cases (0, 1, 2, and 3) and, not matching the value 4, would simply end.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dark</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19834},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>dim</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19835},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>medium</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19836},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>bright</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19837},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>There would be no output</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19838}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: If range were of type Boolean, the case statements could be based on conditions such as TRUE, FALSE, HIGH, &amp; LOW.</p>\r\n</body>\r\n</html>","Id":5234,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Boolean variables would match conditions like TRUE, FALSE, HIGH, LOW, 0, or 1.&nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19839},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19840}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If the sensor input was 77, which case would this be mapped to?</p>\r\n</body>\r\n</html>","Id":5235,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>When the <span style=\"color: rgb(255, 0, 0);\">map(sensorReading, sensorMin, sensorMax, 0, 3);</span> function runs, it takes </p><p>(sensorReading - sensorMin) * (3 - 0) / (sensorMax - sensorMin) + 0</p><p>which for our values is</p><p>(77 - 0) * (3 - 0) / (100 - 0) + 0 = 2.31</p><p>Actually, it will give 2 since all the values being evaluated are int types, it will truncate the division to 2 (and then add 0).</p><p>Therefore the code <span style=\"color: rgb(255, 0, 0);\">range = map(sensorReading, sensorMin, sensorMax, 0, 3);</span> in this case will make range = 2 and the switch will start executing the code under case 2.</p><p><br data-mce-bogus=\"1\"></p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Switch on map with comments.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19841},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19842},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>2</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19843},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>3</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19844}]}]};