flashcardData = {"Title":"While Command","Description":"The learner will review code and answer questions about the while command.","IsRandomAllowed":false,"Questions":[{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>All the flashcards in this set deal with the code below:</p><p><span style=\"color: rgb(255, 0, 0);\">const int Pressuresensor = 0;</span><br><span style=\"color: rgb(255, 0, 0);\">const int PressureLed = 9;</span><br><span style=\"color: rgb(255, 0, 0);\">const int CalibrateLedPin = 13;</span><br><span style=\"color: rgb(255, 0, 0);\">const int pushbuttonPin = 2;</span></p><p><span style=\"color: rgb(255, 0, 0);\">int sensorMin = 1023;</span><br><span style=\"color: rgb(255, 0, 0);\">int sensorMax = 0;</span><br><span style=\"color: rgb(255, 0, 0);\">int sensorValue = 0;</span></p><p><span style=\"color: rgb(255, 0, 0);\">void setup()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;pinMode(CalibrateLedPin, OUTPUT);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;pinMode(PressureLed, OUTPUT);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;pinMode(pushbuttonPin, INPUT);</span><br><span style=\"color: rgb(255, 0, 0);\">}</span></p><p><span style=\"color: rgb(255, 0, 0);\">void calibrate()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;digitalWrite(CalibrateLedPin, HIGH);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;sensorValue = analogRead(Pressuresensor);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;if (sensorValue &gt; sensorMax)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; sensorMax = sensorValue;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;if (sensorValue &lt; sensorMin)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; sensorMin = sensorValue;</span><br><span style=\"color: rgb(255, 0, 0);\">}</span></p><p><span style=\"color: rgb(255, 0, 0);\">void main()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;while (digitalRead(pushbuttonPin) == HIGH)&nbsp;</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; calibrate();</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;}</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;digitalWrite(CalibrateLedPin, LOW);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;sensorValue = analogRead(Pressuresensor);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;sensorValue = map(sensorValue, sensorMin, sensorMax, 0, 255);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;analogWrite(PressureLed, sensorValue);</span><br><span style=\"color: rgb(255, 0, 0);\">}</span></p><p>This code is displayed in the image below, which will be on each card, but you may want to make note of it before going on.</p>\r\n</body>\r\n</html>","Id":5237,"Feedback":null,"HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Got it!</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19845}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The calibrate function is called when <span style=\"color: rgb(255, 0, 0);\">digitalRead(pushbuttonPin)</span> is HIGH.</p>\r\n</body>\r\n</html>","Id":5238,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>In the main section of code, the calibrate function is called exactly when <span style=\"color: rgb(255, 0, 0);\">digitalRead(pushbuttonPin)</span> is HIGH.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19846},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19847}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: If the while statement were changed to read <br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">while !(digitalRead(pushbuttonPin) == HIGH)</span>, a HIGH pushbuttonPin would cause the calibrate function to be called.</p>\r\n</body>\r\n</html>","Id":5239,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">!</span> in front of <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">(digitalRead(pushbuttonPin) == HIGH)</span> actually takes the negation of the value, so if <br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">(digitalRead(pushbuttonPin) == HIGH)</span> is true, <br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">!(digitalRead(pushbuttonPin) == HIGH)</span> will be false and the while command will not execute its code.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19850},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19851}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>As the program is written, how many times will calibrate be called?</p>\r\n</body>\r\n</html>","Id":5240,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">calibrate()</span> will run if <span style=\"color: rgb(255, 0, 0);\">digitalRead(pushbuttonPin)</span> is HIGH, but when it is done running and the program returns to the while statement, if <span style=\"color: rgb(255, 0, 0);\">digitalRead(pushbuttonPin)</span> is still HIGH, it will run <span style=\"color: rgb(255, 0, 0);\">calibrate()</span> again.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>depends how long the push button is pressed</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19852},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>every time pushbuttonPin is LOW</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19853},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19848},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19849}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The following line of code is executed while the push button is pressed <span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">analogWrite(PressureLed, sensorValue);</span>.</p>\r\n</body>\r\n</html>","Id":5241,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>That code is not written until after the while loop has ended, meaning that it will not be executed until the button is no longer being pressed.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19854},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19855}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: Since only one line of code is executed by the while loop in this example, the while loop body curly brackets could be removed with no change to the program functionality. &nbsp;</p>\r\n</body>\r\n</html>","Id":5242,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If the while command is used without any curly brackets, it will execute (exactly) the next line of code if its condition is met, so removing them in this instance would produce the same program behavior. &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19856},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19857}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If we changed the while condition to be <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">while (pushbuttonPin = HIGH)</span>, how many times will the while loop execute?</p>\r\n</body>\r\n</html>","Id":5243,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Because there is only one =, the place in our while command that should have a comparison has an assignment instead. &nbsp;This will&nbsp;cause the while loop to run forever because the value of <span style=\"color: rgb(255, 0, 0);\">pushbuttonPin</span> will be set to HIGH which is TRUE, so the comparison will always be true.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19858},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>5</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19859},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>depends how long the button is pressed</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19860},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>forever</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19861}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Which line(s) of code are executed in this example if the button is pressed?</p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">while (digitalRead(pushbuttonPin) == HIGH)</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">calibrate();</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">digitalWrite(CalibrateLedPin, LOW);</span></p>\r\n</body>\r\n</html>","Id":5244,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since there are no curly brackets after the while command, only the next line of code will execute as long as the condition is true.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p></p><p><span style=\"color: rgb(255, 0, 0);\">calibrate();</span><br><span style=\"color: rgb(255, 0, 0);\">digitalWrite(CalibrateLedPin, LOW);</span></p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19862},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Neither line will execute</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19863},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">calibrate();</span></p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19864},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">digitalWrite(CalibrateLedPin, LOW);</span></p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19865}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Is the while command a pre or post entry conditional test?</p>\r\n</body>\r\n</html>","Id":5245,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The while command is preconditional.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Post</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19866},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Pre</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19867},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>both</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19868},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>neither</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19869}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Which line(s) of code are executed in this example if the button is pressed?</p><p><span style=\"color: rgb(255, 0, 0);\">while(digitalRead(pushbuttonPin) == HIGH)</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;calibrate();</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;digitalWrite(CalibrateLedPin, LOW);</span><br><span style=\"color: rgb(255, 0, 0);\">}</span></p>\r\n</body>\r\n</html>","Id":5246,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since the statements after the while command are in curly brackets, both lines will be executed when the comparison is true.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">calibrate();</span><br><span style=\"color: rgb(255, 0, 0);\">digitalWrite(CalibrateLedPin, LOW);</span></p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19870},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Neither line of code will execute</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19871},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">calibrate();</span><span style=\"color: rgb(255, 0, 0);\"><br></span></p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19872},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\"></span><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">digitalWrite(CalibrateLedPin, LOW);</span></p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19873}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: While commands may run indefinately if the conditional never becomes false.</p>\r\n</body>\r\n</html>","Id":5247,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>A while command can run indefinitely if its conditional is true.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"While.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19874},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19875}]}]};