flashcardData = {"Title":"Analog Input Reading","Description":"The learner will review code and answer questions about an analog read.","IsRandomAllowed":false,"Questions":[{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>All the flashcards in this set deal with the following code:</p><p><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">/*Assume a 10 bit analog to digital converter. Assume maximum analog input&nbsp;</span><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">is 5 VDC. Thus a 5 volt input would be read as 1023, a 2.5 volt input would&nbsp;</span><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">be read as 512, and a 0 volt input would be read as 0. */</span></p><p><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">int analogPin = 1;</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">int value = 0;</span></p><p><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">void setup()</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">{</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;Serial.begin(9600);</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">}</span></p><p><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">void main()</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">{</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;value = analogRead(analogPin);</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;Serial.println(value);</span><br><span style=\"color: #ff0000;\" data-mce-style=\"color: #ff0000;\">}</span></p><p>The code is displayed in the image below, which will be on each card, but you may want to make note of it before going on.</p>\r\n</body>\r\n</html>","Id":5270,"Feedback":null,"HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Got it!</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19934}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Which analog input channel is read?</p>\r\n</body>\r\n</html>","Id":5271,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The line <span style=\"color: rgb(255, 0, 0);\">value = analogRead(analogPin);</span> calls the <span style=\"color: rgb(255, 0, 0);\">analogRead</span> function on the value stored in <span style=\"color: rgb(255, 0, 0);\">analogPin</span>. &nbsp;That value was set to 1.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19935},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19936},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>No input is read</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19937}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The <span style=\"color: rgb(255, 0, 0);\">analogRead</span> function accepts which type of argument?</p>\r\n</body>\r\n</html>","Id":5272,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The <span style=\"color: rgb(255, 0, 0);\">analogRead</span> function takes an integer argument.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Boolean</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19938},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Float</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19939},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Integer</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19940}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Assume 2.5 VDC is applied to analog input 2 and we run the program. &nbsp;What number will <span style=\"color: rgb(255, 0, 0);\">value</span> have?</p>\r\n</body>\r\n</html>","Id":5273,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since our program is not reading from analog input 2, we would need to know the input, if any, on input 1 to know what value the variable <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">value</span> will have.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>512</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19941},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1023</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19942},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19943},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>unknown</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19944}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Which input would <span style=\"color: rgb(255, 0, 0);\">analogRead</span> attempt to read in this code: <span style=\"color: rgb(255, 0, 0);\">analogRead(analogPin + 3);</span></p>\r\n</body>\r\n</html>","Id":5274,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>It would try to read input 4 since <span style=\"color: rgb(255, 0, 0);\">analogPin</span> = 1, <span style=\"color: rgb(255, 0, 0);\">digitalRead(analogPin + 3)</span> is the same as <span style=\"color: rgb(255, 0, 0);\">digitalRead(1 + 3)</span> which is <span style=\"color: rgb(255, 0, 0);\">digitalRead(4)</span>.<span style=\"color: rgb(255, 0, 0);\"></span></p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19945},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>3</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19946},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>4</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19947},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>unknown</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19948}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The <span style=\"color: rgb(255, 0, 0);\">Serial.println</span> command prints the numerical content of the variable <span style=\"color: rgb(255, 0, 0);\">value</span> in this program. &nbsp;If 1.25 VDC is applied to analog input 1, what value would be printed?</p>\r\n</body>\r\n</html>","Id":5275,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since the maximum analog input is 5 VDC which gives a reading of 1023, we can use a proportion to find the reading of 1.25 VDC. &nbsp;<img title=\"\\frac{\\text{5 VDC}}{\\text{1023 Reading}} = \\frac{\\text{1.25 VDC}}{x\\text{ Reading}}\" src=\"https://latex.codecogs.com/gif.latex?\\frac{\\text{5&amp;space;VDC}}{\\text{1023&amp;space;Reading}}&amp;space;=&amp;space;\\frac{\\text{1.25&amp;space;VDC}}{x\\text{&amp;space;Reading}}\" alt=\"\" data-mce-src=\"https://latex.codecogs.com/gif.latex?\\frac{\\text{5&amp;space;VDC}}{\\text{1023&amp;space;Reading}}&amp;space;=&amp;space;\\frac{\\text{1.25&amp;space;VDC}}{x\\text{&amp;space;Reading}}\">. &nbsp;Solving this proportion gives x is 255.75, which rounds to 256.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19949},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>256</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19950},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>512</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19951},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1023</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19952}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Which input would be read if we used the code <span style=\"color: rgb(255, 0, 0);\">analogRead(analogpin);</span>?</p>\r\n</body>\r\n</html>","Id":5276,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The variable name analogpin is not defined. &nbsp;Recall that variables are case sensitive. &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19953},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>3</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19954},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>4</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19955},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Compile error</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19956}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>What is the range of values <span style=\"color: rgb(255, 0, 0);\">analogPin</span> can have in this example?</p>\r\n</body>\r\n</html>","Id":5277,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The <span style=\"color: rgb(255, 0, 0);\">analogPin</span> variable could be any of the numbers from 0 to 1023. &nbsp;Note that 1024 is outside the range of what can be read (since we only have a 10 bit converter). &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>LOW to HIGH</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19957},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0 to 1023</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19958},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0 to 1024</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19959},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0 to 5</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19960}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: We could simplify the main function to the following single line: <span style=\"color: rgb(255, 0, 0);\">Serial.println(analogRead(analogPin));</span>.</p>\r\n</body>\r\n</html>","Id":5278,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>This would work (assuming we always wanted to print the value of <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogPin</span> instead of being able to easily comment that line out for when we are not debugging). &nbsp;The line <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">Serial.println(analogRead(analogPin));</span> would first read the value of pin number <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogPin</span>. &nbsp;Then it would print that value.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19961},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19962}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: In this example, value could have been of type Char (an 8-bit data type).</p>\r\n</body>\r\n</html>","Id":5279,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>A Char type would not be large enough to hold the 10-bit date created by the converter.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19963},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19964}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If we changed the code in the main function as written below, what would be printed if the analog input had 2.5 VDC applied to it?</p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">Serial.println(value);</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">value = analogRead(analogPin);</span></p>\r\n</body>\r\n</html>","Id":5280,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since we set variable <span style=\"color: rgb(255, 0, 0);\">value</span> = 0 when we initialized it and we are printing it before it is assigned the value from the <span style=\"color: rgb(255, 0, 0);\">analogRead</span> function, it will still be 0 and that is what will be printed.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Input Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19965},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>512</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19966},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1023</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19967},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>unknown</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19968}]}]};