flashcardData = {"Title":"Analog Output Writing","Description":"The learner will review code and answer questions about the analogRead and analogWrite functions.  ","IsRandomAllowed":false,"Questions":[{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>All the flashcards in this set deal with the following code:</p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">/*Assume an 8-bit analog output. Assume a 10-bit analog input. Assume maximum </span><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analog output is 5 VDC, therefore a 5 volt &nbsp;output would be generated by writing </span><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">255 to the analog output. A 2.5 volt output would be generated by writing 128, </span><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">and a 0 volt output would be generated by writing 0.*/</span></p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">int OutputPin = 3;</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">int analogPin = 1;</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">int value = 0;</span></p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">void setup()</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">{</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;pinMode(OutputPin, OUTPUT);</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">}</span></p><p><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">void main()</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">{</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;value = analogRead(analogPin);</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;value = value / 4;</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">&nbsp; &nbsp;analogWrite(OutputPin, value);</span><br><span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">}</span></p><p><br></p><p>This code is displayed in the image below, which will be on each card, but you may want to make note of it before going on.</p>\r\n</body>\r\n</html>","Id":5281,"Feedback":null,"HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Got it!</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19969}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Which analog output is being used?</p>\r\n</body>\r\n</html>","Id":5282,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The code <span style=\"color: rgb(255, 0, 0);\">analogWrite(OutputPin, value)</span> is where we actually send our output to the pin <span style=\"color: rgb(255, 0, 0);\">OutputPin</span>. &nbsp;Since <span style=\"color: rgb(255, 0, 0);\">OutputPin</span> has value 3, 3 is the analog output being used.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19970},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19971},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>3</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19972},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>unknown</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19973}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: OutputPin could have been declared as a Float type variable.</p>\r\n</body>\r\n</html>","Id":5283,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>We should never use float variables for values we are going to test for equality or as arguments in functions that take integer arguments. &nbsp;Both the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">pinMode</span> and the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogWrite</span> functions take integer arguments. &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19974},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19975}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: Essentially, this program reads the analog input 1, scales it by a factor of 4, and then writes the scaled value to analog output 3.</p>\r\n</body>\r\n</html>","Id":5284,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>That is a valid explanation of what this program does.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19976},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19977}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: We could rewrite the lines <span style=\"color: rgb(255, 0, 0);\">value = analogRead(analogPin);</span> and <span style=\"color: rgb(255, 0, 0);\">value = value / 4;</span>&nbsp;by replacing them with <span style=\"color: rgb(255, 0, 0);\">value = analogRead(analogPin) / 4;</span> and the program would work produce the same results.</p>\r\n</body>\r\n</html>","Id":5285,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">value = analogRead(analogPin) / 4; </span>would read from the pin <span style=\"color: rgb(255, 0, 0);\">analogPin</span>, divide the value by 4, and store that as <span style=\"color: rgb(255, 0, 0);\">value</span>, just like the separate lines of code <span style=\"color: rgb(255, 0, 0);\">value = analogRead(analogPin);</span> and <span style=\"color: rgb(255, 0, 0);\">value = value / 4;</span>.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19978},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19979}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If we replaced all three lines of code in the main function with <span style=\"color: rgb(255, 0, 0);\">analogWrite(OutputPin, analogRead(analogPin)/4);</span> would this program function the same?</p>\r\n</body>\r\n</html>","Id":5286,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The program would function the same (with the exception that <span style=\"color: rgb(255, 0, 0);\">value</span> would not store anything other than 0); <span style=\"color: rgb(255, 0, 0);\">analogWrite(OutputPin, analogRead(analogPin)/4);</span>&nbsp;will read the value on pin <span style=\"color: rgb(255, 0, 0);\">analogPin</span>, scale it by a factor of 4, and then analog write that scaled value to pin <span style=\"color: rgb(255, 0, 0);\">OutputPin</span>. &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Yes</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19980},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>No</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19981}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: In the line <span style=\"color: rgb(255, 0, 0);\">analogWrite(OutputPin, value);</span>&nbsp;the <span style=\"color: rgb(255, 0, 0);\">value</span> parameter is an optional parameter.</p>\r\n</body>\r\n</html>","Id":5287,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The <span style=\"color: rgb(255, 0, 0);\">analogWrite </span>function requires two inputs, where to write (here <span style=\"color: rgb(255, 0, 0);\">OutputPin</span>) and what to write (here <span style=\"color: rgb(255, 0, 0);\">value</span>).</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19982},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19983}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If value had not been scaled by a factor of 4 in this program, what would the analog output be if the analog input was 180 hex?</p>\r\n</body>\r\n</html>","Id":5288,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since we only have an 8-bit analog output, we can only write two hex digits of output; thus 80 hex will be output when 180 hex is input.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19984},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>80 hex</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19985},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>180 hex</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19986},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Unknown</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19987}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>What is the numerical content of <span style=\"color: rgb(255, 0, 0);\">value</span> in the <span style=\"color: rgb(255, 0, 0);\">analogWrite</span> function if 2.5 VDC is being output?</p>\r\n</body>\r\n</html>","Id":5289,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since there is an 8-bit output and the maximum output is 5 VDC, then an output of 2.5 VDC must be generated by half of the maximum output, or 128. &nbsp;Note that the <span style=\"color: rgb(255, 0, 0);\">value</span> being referenced here has already been scaled by a factor of 4.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19988},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>128</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19989},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>256</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19990},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>512</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19991}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If the analog read results in a value of 3 being read into <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">value</span>, what would be sent to the analog output?</p>\r\n</body>\r\n</html>","Id":5290,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since <span style=\"color: rgb(255, 0, 0);\">value</span> is an <span style=\"color: rgb(255, 0, 0);\">int</span> type, when <span style=\"color: rgb(255, 0, 0);\">value = value / 4;</span> is executed, the division <span style=\"color: rgb(255, 0, 0);\">3 / 4</span> will result in 0, so 0 will be assigned to <span style=\"color: rgb(255, 0, 0);\">value</span>. &nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19992},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>0.75</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19993},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>1</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19994},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Unknown</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19995}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: <span style=\"color: rgb(255, 0, 0);\">value</span> could have effectively been divided by 4 by arithmetically shifting it right twice.</p>\r\n</body>\r\n</html>","Id":5291,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Division by 4 and an arithmetic shift right by two places has the same result.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"Analog Output Commented.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19996},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19997}]}]};