flashcardData = {"Title":"Conditional If Else Statements","Description":"The learner will review code and answer questions about an if else statement.","IsRandomAllowed":false,"Questions":[{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>All the flashcards in this set deal with the following code:</p><p><span style=\"color: rgb(255, 0, 0);\">/*Assume a temperature sensor is connected to the analog pin and an alarm&nbsp;</span><span style=\"color: rgb(255, 0, 0);\">is connected to the digital output*/</span></p><p><span style=\"color: rgb(255, 0, 0);\">const int tempPin = 1;</span><br><span style=\"color: rgb(255, 0, 0);\">const int alarmPin = 0;</span><br><span style=\"color: rgb(255, 0, 0);\">const int tempthreshold = 200;</span><br><span style=\"color: rgb(255, 0, 0);\">int analogValue;</span></p><p><span style=\"color: rgb(255, 0, 0);\">void setup()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;pinmode(alarmPin, OUTPUT);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;Serial.begin(9600);</span><br><span style=\"color: rgb(255, 0, 0);\">}</span></p><p><span style=\"color: rgb(255, 0, 0);\">void main()</span><br><span style=\"color: rgb(255, 0, 0);\">{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;analogValue = analogRead(tempPin);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;if (analogValue &gt; tempthreshold)</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; digitalWrite(alarmPin, HIGH);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;}</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;else</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;{</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp; &nbsp; digitalWrite(alarmPin, LOW);</span><br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;}</span><br> <br><span style=\"color: rgb(255, 0, 0);\">&nbsp; &nbsp;Serial.println(analogValue);</span><br><span style=\"color: rgb(255, 0, 0);\">}</span><br></p><p>This code is displayed in the image below, which will be on each card, but you may want to make note of it before going on.</p>\r\n</body>\r\n</html>","Id":5292,"Feedback":null,"HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Got it!</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":19998}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The alarm will come on if the analog input value is 150.</p>\r\n</body>\r\n</html>","Id":5293,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The alarm will only be turned on if <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogValue &gt; tempthreshold</span>. &nbsp;If the value read is 150, then <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogValue &gt; tempthreshold</span> is <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">150 &gt; 300</span>, which is false. &nbsp;Therefore, the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">else</span> code will run.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":19999},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20000}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The <span style=\"color: rgb(255, 0, 0);\">analogValue &gt; tempthreshold</span> condition of the if statement must be true in order for the alarm to be activated. &nbsp;</p>\r\n</body>\r\n</html>","Id":5294,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The only place we turn on the alarm, <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">digitalWrite(alarmPin, HIGH)</span>, is within the code of the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">if</span> statement. &nbsp;The <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">if</span> statement will only execute its code when <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogValue &gt; tempthreshold</span>.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20001},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20002}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>In order for the alarm to be turned off, the analog input value would have to be less than...</p>\r\n</body>\r\n</html>","Id":5295,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The alarm is turned off in the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">else</span> case's code. That code will execute when the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">if</span> case does not, so it will execute when <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogValue &gt; tempthreshold</span> is false. &nbsp;Since <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">tempthreshold</span> is 200, <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogValue</span> needs to be less than 201 to make the statement false.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>101</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20003},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>201</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20004},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>301</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20005},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Unknown</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20006}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: In this example, the curly brackets after the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">if</span> and the <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">else</span> could have been eliminated.</p>\r\n</body>\r\n</html>","Id":5296,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Since there is only one line of code after both the <span style=\"color: rgb(255, 0, 0);\">if</span> and the <span style=\"color: rgb(255, 0, 0);\">else</span> cases, we could have eliminated the curly braces and the program would have run the same.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20007},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20008}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: In this program, <span style=\"color: rgb(255, 0, 0);\">analogValue</span> is a constant.</p>\r\n</body>\r\n</html>","Id":5297,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">analogValue</span> is declared as an <span style=\"color: rgb(255, 0, 0);\">int</span> type, but not a <span style=\"color: rgb(255, 0, 0);\">const</span>.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20009},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20010}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: If more than one line of code is to be executed when the <span style=\"color: rgb(255, 0, 0);\">if</span> condition is true, curly brackets must be put around them.</p>\r\n</body>\r\n</html>","Id":5298,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>If there are not curly brackets after the <span style=\"color: rgb(255, 0, 0);\">if</span>&nbsp;statement, it will only execute (exactly) the next line of code when the condition is true. &nbsp;The program will then execute the line of code after that regardless of the condition's truth value.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20011},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20012}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: Once the program is running, the value of <span style=\"color: rgb(255, 0, 0);\">tempthreshold</span> can be changed.</p>\r\n</body>\r\n</html>","Id":5299,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p><span style=\"color: rgb(255, 0, 0);\">tempthreshold</span>&nbsp;is a constant in this program, so its value cannot be changed.&nbsp;</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20013},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20014}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: If more than one line of code is to be executed when the <span style=\"color: rgb(255, 0, 0);\">else</span> condition is true, curly brackets must be put around them.</p>\r\n</body>\r\n</html>","Id":5300,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Just like the <span style=\"color: rgb(255, 0, 0);\">if</span> case, the <span style=\"color: rgb(255, 0, 0);\">else</span> case also only executes (exactly) the next line of code by default. &nbsp;If you want it to execute more lines then that, you must use curly brackets.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20015},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20016}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True or False: The code in both the <span style=\"color: rgb(255, 0, 0);\">if</span> and the <span style=\"color: rgb(255, 0, 0);\">else</span> portions can be executed in the same pass of the program run.</p>\r\n</body>\r\n</html>","Id":5301,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Only one of the <span style=\"color: rgb(255, 0, 0);\">if</span> or <span style=\"color: rgb(255, 0, 0);\">else</span> cases can be executed in one pass. &nbsp;If the <span style=\"color: rgb(255, 0, 0);\">if</span> condition is true, the <span style=\"color: rgb(255, 0, 0);\">if</span> code will be executed. &nbsp;Otherwise, the <span style=\"color: rgb(255, 0, 0);\">else</span> code will be executed.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>True</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20017},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>False</p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20018}]},{"Prompt":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>What do the following lines of code do?</p><p><span style=\"color: rgb(255, 0, 0);\">if (analogValue == tempthreshold)<br>&nbsp; &nbsp;digitalWrite(alarmPin, HIGH);</span></p>\r\n</body>\r\n</html>","Id":5302,"Feedback":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>The two equal signs check equality, so this statement sees if <span style=\"color: rgb(255, 0, 0);\">analogValue</span> is equal to <span style=\"color: rgb(255, 0, 0);\">tempthreshold</span> and, if so, turns the alarm on, <span style=\"color: rgb(255, 0, 0);\">digitalWrite(alarmPin, HIGH);</span>.</p>\r\n</body>\r\n</html>","HasImage":true,"ImageAltText":null,"ImageFileName":"If Else Comment.JPG","Answers":[{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Assign the value of <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">tempthreshold</span> to <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogValue</span> and turn the alarm on.</p><p><br></p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20019},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Assign the value of <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">tempthreshold</span> to <span style=\"color: rgb(255, 0, 0);\" data-mce-style=\"color: #ff0000;\">analogValue</span> and leave the alarm in its current state.</p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20020},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Check if the value of <span style=\"color: rgb(255, 0, 0);\">analogValue</span> is equal to <span style=\"color: rgb(255, 0, 0);\">tempthreshold</span> and, if they are equal, turn the alarm on.</p><p><span style=\"color: rgb(255, 0, 0);\"></span></p>\r\n</body>\r\n</html>","IsCorrect":true,"Id":20021},{"Text":"<!DOCTYPE html>\r\n<html>\r\n<head>\r\n</head>\r\n<body>\r\n<p>Check if the value of <span style=\"color: rgb(255, 0, 0);\">analogValue</span> is equal to <span style=\"color: rgb(255, 0, 0);\">tempthreshold</span> and, if they are equal, turn the alarm off.</p><p><span style=\"color: rgb(255, 0, 0);\"></span></p>\r\n</body>\r\n</html>","IsCorrect":false,"Id":20022}]}]};