﻿/// <reference path="http://code.createjs.com/createjs-2013.12.12.min.js" />
/// <reference path="../../../Content/GamesDownloadTemplate/lib/ScormHelper.js" />
var Game = Game || (function (createjs) {
    var standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);
    var buttonShadow = new createjs.Shadow("black", 3, 3, 5);


    function Game(canvas, gameData) {

        var self = this;
        self.stage = new createjs.Stage(canvas);
        createjs.Touch.enable(self.stage, false, false);
        self.stage.enableMouseOver();
        self.stage.mouseMoveOutside = true; // keep tracking the mouse even when it leaves the canvas
        self.imageKeys = {
            title_background: "title_background",
            background: "background",
            start_button: "start_button",
            game_board: "game_board"
        }

        var originalWidth = self.stage.canvas.width;
        var originalHeight = self.stage.canvas.height;


        //createjs.Ticker.setFPS(60);
        createjs.Ticker.addEventListener("tick", tickHandler);




        function tickHandler(event) {

            self.stage.update();
        }

        var resourceLoader = new createjs.LoadQueue(false);

        resourceLoader.addEventListener("complete", function (event) {
            showTitleView();
        });

        // setup the resources to be loaded.
        (function () {
            var assetsPath = gameData.assetsPath || "";

            var assets =
                [
                    { id: "instructions_background", src: assetsPath + "instructions_background.png" },
                    { id: "instructions_question", src: assetsPath + "instructions_question.png" },
                    { id: "start_button", src: assetsPath + "start_button.png" },
                    { id: "title_background", src: assetsPath + "title_background.jpg" },
                    { id: "plain_background", src: assetsPath + "plain_background.jpg" },
                    { id: "banner", src: assetsPath + "topPuzzleBanner.jpg" },
                    { id: "instructions", src: assetsPath + "matchingInstructions.jpg" }
                ];

            resourceLoader.loadManifest(assets);
        })();


        var isLmsConnected = false;
        var currentLmsInteraction = null;

        if (typeof ScormHelper !== 'undefined') {
            isLmsConnected = ScormHelper.initialize();
        }

        var gameState = {
            score: 0,
            originalDefinitionX: 0,
            originalDefinitionY: 0,
            numberOfMatchingPages: 1,
            currentMatchingPage: 1,
            numberofTermsPage1: 0,
            numberofTermsPage2: 0,
            numberMatchedOnCurrentPage: 0,
            reviewDefinitionText: "Click on a term to show the definition."
        }
        var view
        var p1 = [];
        var p2 = [];
        var totalNumberOfTerms = gameData.Terms.length;
        gameData.Terms = shuffle(gameData.Terms);
        function shuffle(array) {
            var currentIndex = array.length
                , temporaryValue
                , randomIndex
                ;

            // While there remain elements to shuffle...
            while (0 !== currentIndex) {

                // Pick a remaining element...
                randomIndex = Math.floor(Math.random() * currentIndex);
                currentIndex -= 1;

                // And swap it with the current element.
                temporaryValue = array[currentIndex];
                array[currentIndex] = array[randomIndex];
                array[randomIndex] = temporaryValue;
            }

            return array;
        }
        if (totalNumberOfTerms >= 9) {
            var half_length = Math.ceil(gameData.Terms.length / 2);

            p1 = gameData.Terms.slice(0, half_length);
            gameState.numberofTermsPage1 = p1.length;
            p2 = gameData.Terms.slice(half_length);
            gameState.numberOfMatchingPages = 2;
            gameState.numberofTermsPage2 = p2.length;
        } else {
            p1 = gameData.Terms.slice(0, half_length);
        }
        function showTitleView() {
            view = new createjs.Container();

            var titleText = new createjs.Text(gameData.Title, "36px Arial Black", "#CD3933");
            titleText.shadow = new createjs.Shadow("gray", 1, 1, 3);
            titleText.lineWidth = 780;
            titleText.x = 10;
            titleText.y = 10;

            var descriptionText = new createjs.Text(gameData.Description, "20px Bold Arial", "dark gray");
            descriptionText.lineWidth = 780;
            descriptionText.x = 10;
            descriptionText.y = 100;

            var startButton = new createjs.Bitmap(resourceLoader.getResult(self.imageKeys.start_button));
            startButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
            startButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
            startButton.cursor = 'pointer';
            startButton.regX = 50;
            startButton.regY = 50;
            startButton.x = 725;
            startButton.y = 525;

            view.addChild(new createjs.Bitmap(resourceLoader.getResult(self.imageKeys.title_background)))
            view.addChild(startButton);
            view.addChild(descriptionText);
            view.addChild(titleText);

            startButton.addEventListener("click", function (event) {
                //createWinnerView();
                showReview();
                //showGame();
            });

            startButton.addEventListener("mouseover", function (event) {
                createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100).to({ scaleX: 1.0, scaleY: 1.0 }, 100).to({ scaleX: 1.0625, scaleY: 1.0625 }, 200);
            });

            startButton.addEventListener("mouseout", function (event) {
                createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0, scaleY: 1.0 }, 100);
            });

            self.stage.addChild(view);

            showView(view);
        }




        var definitionsContainer = new createjs.Container();
        var definitionBox;
        var questionMark;
        function showReview() {


            var instructionsContainer = new createjs.Container();
            instructionsContainer.x = 0;
            instructionsContainer.y = 550;
            instructionsContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 50, 50));
            instructionsContainer.cursor = 'pointer';

            instructionsContainer.addChild(new createjs.Bitmap(resourceLoader.getResult("instructions_background")));

            questionMark = new createjs.Bitmap(resourceLoader.getResult("instructions_question"));

            instructionsContainer.addChild(questionMark);



            instructionsContainer.addEventListener("click", function () {
                showView(getInstructionsView());
            });

            instructionsContainer.on("mouseover", handleInstructionsMouseOver);
            instructionsContainer.on("mouseout", handleInstructionsMouseOver);
            view = new createjs.Container();
            view.name = "review";

            view.addChild(instructionsContainer);

            var banner = new createjs.Bitmap(resourceLoader.getResult("banner"));
            view.addChild(banner);
            var titleText = new createjs.Text("Review the Terms", "bold 36px Arial", "#c1272D");
            var width = self.stage.canvas.width;
            var height = banner.getBounds().height;
            b = titleText.getBounds();
            titleText.x = (width - b.width) / 2;
            titleText.y = 30;
            view.addChild(titleText);
            //var gameBoard = new createjs.Bitmap(resourceLoader.getResult(self.imageKeys.game_board));

            var positionOfLastbox = 0;
            var positionOfLastTermbox = 50;


            var definitionContainer = new createjs.Container();
            var definitionText = new createjs.Text(gameState.reviewDefinitionText, "24px Arial normal", "#000");
            definitionText.shadow = standardTextShadow;
            definitionText.lineWidth = 300;
            var bg = new createjs.Shape();
            bg.graphics.beginFill("#ccc");
            bg.graphics.setStrokeStyle(1);
            bg.graphics.drawRoundRect(0, 0, 306, 300, 3);
            bg.shadow = standardTextShadow;

            definitionContainer.addChild(bg);

            definitionContainer.addChild(definitionText);
            definitionContainer.x = 470;
            definitionContainer.y = 150;
            definitionContainer.name = "theDefinition";
            view.addChild(definitionContainer);
            for (var i = 0; i < gameData.Terms.length; ++i) {
                var name = new createjs.Text(gameData.Terms[i].Name, "14pt arial bold", "white");
                name.cursor = "pointer";
                name.shadow = standardTextShadow;
                name.lineWidth = 200;
                name.id = gameData.Terms[i].Name;
                var w = (name.getMeasuredWidth()) //* name.scaleX;
                var h = (name.getMeasuredHeight()) //* name.scaleY;
                name.x = 3;
                //var duration = 1000 + (Math.random() * 400 - 200); // 1 second +/- ~200ms

                var hitArea = new createjs.Shape();
                hitArea.graphics.beginFill("#c1272D");
                hitArea.graphics.setStrokeStyle(1);
                hitArea.graphics.drawRoundRect(0, 0, 205, h + 10, 3);

                var singleTermContainer = new createjs.Container();
                singleTermContainer.Definition = gameData.Terms[i].Definition;
                name.hitArea = hitArea;

                var bg = new createjs.Shape();
                bg.graphics.beginFill("#c1272D");
                bg.graphics.setStrokeStyle(1);
                bg.graphics.drawRoundRect(0, 0, 205, h + 10, 3);
                bg.shadow = standardTextShadow;

                singleTermContainer.addChild(bg);

                singleTermContainer.addEventListener("click", function (evt) {
                    evt.currentTarget.parent.getChildByName("theDefinition").children[1].text = evt.currentTarget.Definition;
                    self.stage.update();
                });

                singleTermContainer.addChild(name);
                var totalNumberOfTerms = gameData.Terms.length;
                var half_length = gameData.Terms.length;
                if (totalNumberOfTerms >= 9) {
                    var half_length = Math.ceil(gameData.Terms.length / 2);

                }

                if (i < half_length) {
                    singleTermContainer.x = 5;
                    singleTermContainer.y = i == 0 ? 140 : positionOfLastbox + 20;
                } else {
                    singleTermContainer.x = 250;
                    singleTermContainer.y = i == half_length ? 140 : positionOfLastbox + 20;

                }


                singleTermContainer.name = gameData.Terms[i].Name;

                positionOfLastbox = singleTermContainer.y + h;
                view.addChild(singleTermContainer);

            }





            ////////NextButton///////////////
            var nextContainer = new createjs.Container();
            var nextText = new createjs.Text("next >", "24px Arial bold", "#fff");
            var hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#000000").drawRect(0, 0, 100, 30));
            nextText.hitArea = hitArea;
            nextText.x = 50;

            nextText.textAlign = "center";
            var bg = new createjs.Shape();
            bg.graphics.beginFill("#c1272D");
            bg.graphics.setStrokeStyle(1);
            bg.graphics.drawRoundRect(0, 0, 100, 30, 3);
            nextContainer.addChild(bg);
            nextContainer.addChild(nextText);

            nextContainer.shadow = standardTextShadow;
            nextContainer.x = 675;
            nextContainer.y = 560;
            nextContainer.visible = true;
            nextContainer.cursor = "pointer";
            view.addChild(nextContainer);

            nextContainer.addEventListener("click", function (evt) {
                showNextMatchingScreen(evt);
            });
            showView(view);

        }
        function showGame() {
            gameState.submitedScore = false;
            var instructionsContainer = new createjs.Container();
            instructionsContainer.x = 0;
            instructionsContainer.y = 550;
            instructionsContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 50, 50));
            instructionsContainer.cursor = 'pointer';

            instructionsContainer.addChild(new createjs.Bitmap(resourceLoader.getResult("instructions_background")));

            questionMark = new createjs.Bitmap(resourceLoader.getResult("instructions_question"));

            instructionsContainer.addChild(questionMark);



            instructionsContainer.addEventListener("click", function () {
                showView(getInstructionsView());
            });

            instructionsContainer.on("mouseover", handleInstructionsMouseOver);
            instructionsContainer.on("mouseout", handleInstructionsMouseOver);
            view = new createjs.Container();


            view.addChild(instructionsContainer);

            var banner = new createjs.Bitmap(resourceLoader.getResult("banner"));
            view.addChild(banner);
            var titleText = new createjs.Text("Match the Terms", "bold 36px Arial", "#c1272D");
            var width = self.stage.canvas.width;
            var height = banner.getBounds().height;
            b = titleText.getBounds();
            titleText.x = (width - b.width) / 2;
            titleText.y = 30;
            view.addChild(titleText);
            //var gameBoard = new createjs.Bitmap(resourceLoader.getResult(self.imageKeys.game_board));


            var positionOfLastbox = 0;
            var positionOfLastTermbox = 50;
            if (gameState.currentMatchingPage == 1) {
                currentArray = p1;
            } else {
                currentArray = p2;
            }
            //////////////Create Definitions////////////////////////
            for (var i = 0; i < currentArray.length; ++i) {


                //    //var duration = 1000 + (Math.random() * 400 - 200); // 1 second +/- ~200ms


                var definitionName = new createjs.Text(currentArray[i].Definition, "24px Arial white", "white");
                definitionName.textAlign = "left";
                //definitionName.textBaseline = "middle";
                definitionName.cursor = "pointer";
                definitionName.lineWidth = 300;
                definitionName.maxWidth = 300;
                definitionName.id = currentArray[i].Name;

                var curpx = 24;
                while (definitionName.getMeasuredHeight() > 40) {
                    definitionName.font = curpx + "px Arial white";
                    curpx = curpx - 1
                    if (curpx == 10) break;
                }

                var w = (definitionName.getMeasuredWidth()) //* definitionName.scaleX;
                var h = (definitionName.getMeasuredHeight()) //* definitionName.scaleY;
                definitionName.x = 3;



                var bg = new createjs.Shape();
                bg.graphics.beginFill("#666");
                bg.graphics.setStrokeStyle(1);
                bg.graphics.drawRoundRect(0, 0, 320, h + 10, 3);
                //bg.shadow = standardTextShadow;
                definitionName.hitArea = bg;

                var hitArea = new createjs.Shape();
                hitArea.graphics.beginFill("#CCC");
                hitArea.graphics.setStrokeStyle(1);
                hitArea.graphics.drawRoundRect(0, 0, 320, h + 10, 3);

                definitionName.hitArea = hitArea;

                var singleDefinitionContainer = new createjs.Container();
                singleDefinitionContainer.addChild(bg);

                singleDefinitionContainer.addChild(definitionName);

                singleDefinitionContainer.x = 450;
                singleDefinitionContainer.y = (i == 0) ? 110 : positionOfLastTermbox + 20;

                singleDefinitionContainer.originalX = singleDefinitionContainer.x;
                singleDefinitionContainer.originalY = singleDefinitionContainer.y;

                positionOfLastTermbox = singleDefinitionContainer.y + h;
                view.addChild(singleDefinitionContainer);

            }
            /////////End Create Definitions////////////////////////
            function shuffle(o) { //v1.0
                for (var j, x, i = o.length; i; j = Math.floor(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
                return o;
            };

            newArray = shuffle(currentArray);
            //////////////Create Terms////////////////////////////
            for (var i = 0; i < newArray.length; ++i) {
                var name = new createjs.Text(newArray[i].Name, "14pt arial bold", "white");
                name.cursor = "pointer";
                //name.shadow = standardTextShadow;
                name.lineWidth = 200;
                name.id = newArray[i].Name;
                var w = (name.getMeasuredWidth())// * name.scaleX;
                var h = (name.getMeasuredHeight()) //* name.scaleY;
                name.x = 3;
                //var duration = 1000 + (Math.random() * 400 - 200); // 1 second +/- ~200ms

                var hitArea = new createjs.Shape();
                hitArea.graphics.beginFill("#CCC");
                hitArea.graphics.setStrokeStyle(1);
                hitArea.graphics.drawRoundRect(0, 0, 205, h + 10, 3);

                var singleTermContainer = new createjs.Container();

                singleTermContainer.isMatched = false;

                name.hitArea = hitArea;

                var bg = new createjs.Shape();
                bg.graphics.beginFill("#c1272D");
                bg.graphics.setStrokeStyle(1);
                bg.graphics.drawRoundRect(0, 0, 205, h + 10, 3);
                //bg.shadow = standardTextShadow;

                singleTermContainer.addChild(bg);
                singleTermContainer.on('mousedown', function (evt) {
                    if (!evt.currentTarget.isMatched) {

                        var ct = evt.currentTarget,
                            local = ct.globalToLocal(evt.stageX, evt.stageY),
                            nx = ct.regX - local.x,
                            ny = ct.regY - local.y

                        //set the new regX/Y
                        ct.regX = local.x;
                        ct.regY = local.y;
                        //adjust the real-position, otherwise the new regX/Y would cause a jump
                        ct.x -= nx;
                        ct.y -= ny;
                    }
                });
                singleTermContainer.addEventListener("mousedown", function (evt) {
                    if (!evt.currentTarget.isMatched) {
                        var h = evt.currentTarget.getBounds().height;

                        evt.currentTarget.children[0].color = "black";

                        self.stage.update();
                    }
                });

                singleTermContainer.addEventListener("pressmove", function (evt) {
                    if (!evt.currentTarget.isMatched) {
                        evt.currentTarget.x = evt.stageX;
                        evt.currentTarget.y = evt.stageY;
                        var target = self.stage.getObjectsUnderPoint(evt.stageX, evt.stageY);

                        self.stage.update();
                    }
                });
                singleTermContainer.addEventListener("pressup", function (evt) {
                    if (!evt.currentTarget.isMatched) {
                        var h = evt.currentTarget.getBounds().height;
                        evt.currentTarget.color = "white";
                        var target = self.stage.getObjectsUnderPoint(evt.currentTarget.x, evt.currentTarget.y);
                        //if it found a hit zone.

                        var isMatched = false;

                        if (target.length > 1) {
                            for (var i = 1; i < target.length; ++i) {
                                if (target[0].id == target[i].id) {
                                    isMatched = true;
                                    evt.currentTarget.isMatched = true;
                                    target[0].color = "#fff";
                                    evt.currentTarget.regX = 0;
                                    evt.currentTarget.regY = 0;
                                    createjs.Tween.get(evt.currentTarget).to({ x: (target[i].parent.originalX - 205), y: (target[i].parent.originalY) }, 400);
                                    evt._l
                                    gameState.score = gameState.score + 50;
                                    displayScore(gameState.score);
                                    gameState.numberMatchedOnCurrentPage = ++gameState.numberMatchedOnCurrentPage;

                                    var termsCount = gameState.currentMatchingPage == 1 ? gameState.numberofTermsPage1 : gameState.numberofTermsPage2;
                                    if (gameState.numberMatchedOnCurrentPage >= termsCount) {
                                        nextContainer.visible = true;
                                    }
                                }
                            }

                            if (!isMatched) {
                                gameState.score = gameState.score - 10;
                                displayScore(gameState.score);
                            }
                        }

                        if (!isMatched) {
                            createjs.Tween.get(evt.currentTarget).to({ x: evt.currentTarget.originalX + evt.currentTarget.regX, y: evt.currentTarget.originalY + evt.currentTarget.regY }, 400);
                        }

                        self.stage.update();
                    }
                });
                singleTermContainer.addChild(name);

                singleTermContainer.x = 5;
                singleTermContainer.y = (i == 0) ? 110 : positionOfLastbox + 20;


                singleTermContainer.name = gameData.Terms[i].Name;
                singleTermContainer.originalX = singleTermContainer.x;
                singleTermContainer.originalY = singleTermContainer.y;

                positionOfLastbox = singleTermContainer.y + h;
                view.addChild(singleTermContainer);

            }
            ///////////End Create Terms////////////////////////////

            //////ScoreBox////////////////////
            scoreText = new createjs.Text("", "16pt Arial Black", "purple");
            displayScore(gameState.score);
            scoreText.textAlign = "right";
            scoreText.textBaseline = "middle";
            scoreText.shadow = standardTextShadow;
            scoreText.x = 180;
            scoreText.y = 580;

            view.addChild(scoreText);


            ////////NextButton///////////////
            var nextContainer = new createjs.Container();
            var nextText = new createjs.Text("next >", "24px Arial bold", "#fff");
            var hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#000000").drawRect(0, 0, 100, 30));
            nextText.hitArea = hitArea;
            nextText.x = 50;

            nextText.textAlign = "center";
            var bg = new createjs.Shape();
            bg.graphics.beginFill("#c1272D");
            bg.graphics.setStrokeStyle(1);
            bg.graphics.drawRoundRect(0, 0, 100, 30, 3);
            nextContainer.addChild(bg);
            nextContainer.addChild(nextText);

            nextContainer.shadow = standardTextShadow;
            nextContainer.x = 675;
            nextContainer.y = 560;
            nextContainer.visible = false;

            view.addChild(nextContainer);
            nextContainer.cursor = "pointer";
            nextContainer.addEventListener("click", function (evt) {
                if (gameState.currentMatchingPage == 1 && p2.length != 0) {
                    showNextMatchingScreen(evt);
                } else {
                    createWinnerView();

                }

            });
            showView(view);
        }



        var scoreText = new createjs.Text("SCORE: 0", "16pt Arial Black", "White");

        function displayScore(score) {
            scoreText.text = "SCORE: " + score.toString();

        }

        function showNextMatchingScreen(evt) {
            if (evt.currentTarget.parent.name == "review") {
                gameState.currentMatchingPage = 1;
            } else {
                gameState.currentMatchingPage = 2;
            }
            gameState.numberMatchedOnCurrentPage = 0;
            self.stage.removeChild(self.currentView);
            showGame();
        }

        self.previousView = null;
        self.currentView = null;

        $(window).bind('beforeunload', function () {
            submitScore(gameState.score)
        })

        function submitScore(score) {
            if (gameState.submitedScore || score == 0)
                return false;
            gameState.submitedScore = true;
            var url = gameData.leaderboardUrl;

            if (url) {

                var data = {
                    gameId: gameData.id,
                    score: score
                };

                $.ajax(url, {
                    type: "POST",
                    data: data,
                    success: function (x) {

                    },
                    error: function (x, y, z) {


                    }
                });

            }
        }

        function createInstructionsView() {
            var view = new createjs.Container();
            var image = new createjs.Bitmap(resourceLoader.getResult("instructions"));

            var hit = new createjs.Shape();
            var exitContainer = new createjs.Container();
            var exitBox = new createjs.Shape();

            exitContainer.x = 720;
            exitContainer.y = 570;
            var exitText = new createjs.Text("BACK", 'bold 18px Arial', "#fff");
            exitText.x = 8;
            exitText.y = 8;
            exitContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#c1272D").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke());
            hit.graphics.beginFill("#000").drawRect(0, 0, exitText.getMeasuredWidth(), exitText.getMeasuredHeight());
            exitBox.graphics.beginFill("#c1272D").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke();
            exitText.hitArea = hit;
            exitContainer.addChild(exitBox, exitText);

            view.addChild(image, exitContainer);//, 

            exitContainer.addEventListener("click", function (event) {
                showView(self.previousView);
            });

            return view;
        }
        function startOver() {
            gameState.score = 0
            showTitleView();
        }


        var quit;

        if (isLmsConnected) {
            quit = function () {
                ScormHelper.cmi.exit("");
                ScormHelper.adl.nav.request("exitAll");
                ScormHelper.terminate();
            }
        }
        else {
            quit = function () {
                window.location = "http://www.wisc-online.com";
            }
        }


        function createWinnerView() {
            var view = new createjs.Container();
            var width = self.stage.canvas.width;
            var height = window.innerHeight;
            var image = new createjs.Bitmap(resourceLoader.getResult("banner"));
            view.addChild(image);
            image.y = 200;



            if (gameState.score == 0) {
                var headText = new createjs.Text("Try Again", "bold 36px Arial", "#000");

                var titleText = new createjs.Text("You didn't win any points.", "bold 36px Arial", "#c1272D");
            } else {
                var headText = new createjs.Text("HOORAY!!!!!!", "bold 36px Arial", "#000");

                var titleText = new createjs.Text("Your Score:", "bold 30px Arial", "#c1272D");
                submitScore(gameState.score);
            }
            h = headText.getBounds();
            headText.x = (width - h.width) / 2;
            headText.y = 100;

            b = titleText.getBounds();
            titleText.x = (width - b.width) / 2;
            titleText.y = 210;



            view.addChild(image, titleText, headText);//, 


            var startOverContainer = new createjs.Container();

            var startOverBG = new createjs.Shape();

            startOverBG.graphics.beginLinearGradientFill(["#CD3933", "#990000"], [.45, .7], 200, 0, 200, 30)
            startOverBG.graphics.drawRoundRect(0, 0, 200, 38, 5);
            startOverBG.graphics.endFill();
            startOverContainer.addChild(startOverBG);


            startOverContainer.x = 300;
            startOverContainer.y = 400;
            startOverContainer.addEventListener("click", startOver);
            var startOverText = new createjs.Text("Start Over", "bold 30px Arial", "#FFF");
            //var hit = new createjs.Shape();
            //hit.graphics.beginFill("#000").drawRect(0, 0, startOverText.getMeasuredWidth(), startOverText.getMeasuredHeight());
            //startOverText.hitArea = hit;
            s = startOverText.getBounds();
            startOverText.x = (200 - s.width) / 2;

            startOverContainer.addChild(startOverText);
            startOverContainer.cursor = "pointer";
            if (!isLmsConnected) {
                view.addChild(startOverContainer);//, 
            }



            // only show the quit text if we're on a mobile device!
            if (isLmsConnected || navigator.userAgent.match(/Android/i)
                || navigator.userAgent.match(/webOS/i)
                || navigator.userAgent.match(/iPhone/i)
                || navigator.userAgent.match(/iPad/i)
                || navigator.userAgent.match(/iPod/i)
                || navigator.userAgent.match(/BlackBerry/i)
                || navigator.userAgent.match(/Windows Phone/i)
            ) {
                var quitContainer = new createjs.Container();

                var quitBG = new createjs.Shape();

                quitBG.graphics.beginLinearGradientFill(["#CD3933", "#990000"], [.45, .7], 200, 0, 200, 30)
                quitBG.graphics.drawRoundRect(0, 0, 200, 38, 5);
                quitBG.graphics.endFill();
                quitContainer.addChild(quitBG);


                quitContainer.x = 300;
                quitContainer.y = 450;
                quitContainer.addEventListener("click", quit);
                var quitText = new createjs.Text("Quit", "bold 30px Arial", "#FFF");
                //var hit = new createjs.Shape();
                //hit.graphics.beginFill("#000").drawRect(0, 0, startOverText.getMeasuredWidth(), startOverText.getMeasuredHeight());
                //startOverText.hitArea = hit;
                var s = quitText.getBounds();
                quitText.x = (200 - s.width) / 2;

                quitContainer.addChild(quitText);
                quitContainer.cursor = "pointer";
                view.addChild(quitContainer);
            }

            if (isLmsConnected) {
                ScormHelper.cmi.completionStatus(ScormHelper.completionStatus.completed);
                ScormHelper.cmi.successStatus(ScormHelper.successStatus.passed);

                isLmsConnected = false;
            }


            if (gameState.score > 0) {
                var score = new createjs.Text(gameState.score, "bold 30px Arial", "#c1272D");
                s = score.getBounds();
                score.x = (width - s.width) / 2;
                score.y = 250;

                view.addChild(score);
            }
            showView(view);
        }


        var instructionsView = null;

        function getInstructionsView() {
            if (instructionsView == null) {
                instructionsView = createInstructionsView();
            }

            return instructionsView;
        }

        self.previousView = null;
        self.currentView = null;

        function showView(view) {
            //asdfasdf
            // TODO: add transition animation (fade)

            if (self.currentView) {
                self.stage.removeChild(self.currentView);
                self.previousView = self.currentView;
            }
            else {
                self.previousView = null;
            }

            if (view) {
                self.stage.addChild(view);
                self.currentView = view;
            }
            else {
                self.currentView = null;
            }

            self.stage.update();
        };

        function handleInstructionsMouseOver(event) {
            if (event.type == "mouseover") {
                createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0625, scaleY: 1.0625 }, 50);
            }
            else {
                createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0, scaleY: 1.0 }, 50);
            }
        }

        showView(showTitleView());
        createjs.Ticker.addEventListener("tick", self.stage);

    }


    return Game;
})(createjs);