﻿/// <reference path="http://code.createjs.com/createjs-2013.12.12.min.js" />
///<reference path="../../../Content/GamesDownloadTemplate/lib/ScormHelper.js" />
var Game = Game || (function (createjs) {

    function Game(canvas, gameData) {
        var self = this;
        var tweenMultiplier = 1.0;
        self.stage = new createjs.Stage(canvas);
        createjs.Touch.enable(self.stage, false, true);
        self.stage.enableMouseOver(10);

        var standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);
        var buttonShadow = new createjs.Shadow("black", 3, 3, 5);
        var highlightShadow = new createjs.Shadow("yellow", 0, 0, 5);
        var noShadow = new createjs.Shadow();
        var highlightGreen = new createjs.Shadow("#00FF00", 3, 3, 5);
        var highlightRed = new createjs.Shadow("#FF0000", 3, 3, 5);

        // COLOR FILTERS ([redMultiplier=1][greenMultiplier=1][blueMultiplier=1][alphaMultiplier=1][redOffset=0][greenOffset=0][blueOffset=0])
        var colorFilters = [
            filterRed = new createjs.ColorFilter(1, 0, 0, 1),
            filterGreen = new createjs.ColorFilter(0, 1, 0, 1),
            filterBlue = new createjs.ColorFilter(0, 0, 1, 1),
            filterWhite = new createjs.ColorFilter(1, 1, 1, 1),
        ];

        var helpers = {
            addMember: function () {
                try {
                    var button = new createjs.Container();
                    button.cursor = "pointer";
                    button.regX = 175;
                    button.regY = 25;

                    var background = new createjs.Shape();
                    background.name = "BG";
                    background.graphics.setStrokeStyle(3).beginFill("#000000").beginStroke("#29ABE2").drawRoundRect(0, 0, 350, 50, 25).endStroke().endFill;

                    var image = new createjs.Bitmap(resourceLoader.getResult("add"));
                    image.x = 25;
                    image.y = 25;
                    image.regX = 35;
                    image.regY = 35;
                    image.scaleX = 0.8;
                    image.scaleY = 0.8;

                    var text = new createjs.Text("Add Member", "20pt Arial white", "#29ABE2");
                    text.name = "txtAddMember";
                    text.x = 250;
                    text.y = 35;
                    text.regX = 75;
                    text.regY = 12.5;
                    text.textBaseline = "middle"
                    text.textAlign = "center";
                    text.lineWidth = 200;

                    button.hitArea = background;
                    //button.addEventListener("click", function () { addMember() }); // TEST ENVIROMENT
                    button.addEventListener("click", function () {
                        try {
                            if (gameState.isEndingReady == true) { showTime(); return; }
                            //getGameProgress();

                            if ((gameState.isRunning) || (gameState.selectionNumber < 0)) { return; }
                            gameState.isRunning = true;
                            var conBandStage = view.getChildByName("conBandStage");
                            var conControls = view.getChildByName("conControls");

                            if (!soundEffect.getMute()) {
                                soundEffect = createjs.Sound.play("roundBegin", { loop: 0, volume: 0.75 });
                                arrSoundEffects.push(soundEffect);
                            }

                            // BACKGROUND TWEEN
                            var tweenBandStage = new createjs.Tween.get(conBandStage)
                                .call(animateBackground, [true])
                                .to({ y: 0 }, 2500 * tweenMultiplier)
                                .call(bgHandleComplete);

                            function bgHandleComplete() {
                                try {
                                    //console.log("HELLO FROM bgHandleComplete() :: Trigger UFO Movement");
                                    //var imageUFO = new createjs.Bitmap(resourceLoader.getResult("hefferShip"));
                                    var imageUFO = getUFO();
                                    imageUFO.name = "imageUFO";
                                    imageUFO.x = -250;
                                    imageUFO.y = 75;
                                    imageUFO.scaleX = 0.5;
                                    imageUFO.scaleY = 0.5;

                                    conBandStage.addChild(imageUFO);

                                    if (!soundEffect.getMute()) {
                                        soundEffect = createjs.Sound.play("ufoMoving", { loop: 0, volume: 0.75 });
                                        arrSoundEffects.push(soundEffect);
                                    }

                                    var tweenUFO = new createjs.Tween(imageUFO)
                                        .to({ x: 1000 }, 2000 * tweenMultiplier)
                                        .to({ x: 600 }, 2000 * tweenMultiplier)
                                        .to({ x: (originalWidth / 2), scaleX: 1, scaleY: 1 }, 1000 * tweenMultiplier)
                                        .call(ufoHandleComplete);

                                    function ufoHandleComplete() {
                                        try {
                                            //console.log("HELLO FROM ufoHandleComplete() :: Trigger Creature Select");
                                            gameState.arrSelection = [];

                                            for (var i = 0; i <= gameState.selectionNumber; ++i) {
                                                var selectCreature = creatureContainer(getCreature());

                                                // Check Selection Array
                                                var isInArray = false;
                                                for (var j = 0; j <= gameState.arrSelection.length; ++j) {
                                                    var tempCreature = gameState.arrSelection[j];
                                                    if (tempCreature != null) {
                                                        if (selectCreature.name == tempCreature.name) {
                                                            isInArray = true;
                                                        }
                                                    }
                                                }

                                                // Check myBand Array
                                                var isInBand = false;
                                                for (var k = 0; k <= gameState.myBand.length; ++k) {
                                                    var tempMember = gameState.myBand[k];
                                                    if (tempMember != null) {
                                                        if (selectCreature.name == tempMember.name) {
                                                            isInBand = true;
                                                        }
                                                    }
                                                }

                                                // Check lostCreatures Array
                                                var isLost = false;
                                                for (var l = 0; l <= gameState.lostCreatures.length; ++l) {
                                                    var tempLostCreature = gameState.lostCreatures[l];
                                                    if (tempLostCreature != null) {
                                                        if (selectCreature.name == tempLostCreature.name) {
                                                            isLost = true;
                                                        }
                                                    }
                                                }

                                                if ((isInArray == false) && (isInBand == false) && (isLost == false)) {
                                                    selectCreature.on("mouseover", handleCreatureMouseOver);
                                                    selectCreature.on("mouseout", handleCreatureMouseOver);
                                                    selectCreature.on("click", handleCreatureClick);

                                                    function handleCreatureClick(event) {
                                                        try {
                                                            gameState.currentSelection = event.currentTarget;

                                                            if (soundCheck != null) {
                                                                soundCheck.stop();
                                                            }

                                                            var i = 0;
                                                            do {
                                                                var tempObject = gameState.creatures[i];
                                                                i++;
                                                            } while (gameState.currentSelection.name != tempObject.id)

                                                            soundCheck = createjs.Sound.createInstance(tempObject.soundid[gameState.selectedTracks], { volume: 1.0 });
                                                            soundCheck.play();

                                                            btnConfirm.visible = true;
                                                            highlightCreature();
                                                            highlightButton(btnConfirm);
                                                        }
                                                        catch (ex) {
                                                            console.log("ERROR FROM addMember.ufoHandleComplete.handleCreatureClick() :: " + ex);
                                                        }
                                                    }
                                                    function handleCreatureMouseOver(event) {
                                                        try {
                                                            var tube = event.currentTarget;

                                                            if (event.type == "mouseover") {
                                                                createjs.Tween.get(tube, { loop: false }).to({ scaleX: 0.6, scaleY: 0.6 }, 250);
                                                            }
                                                            else {
                                                                createjs.Tween.get(tube, { loop: false }).to({ scaleX: 0.5, scaleY: 0.5 }, 250);
                                                            }
                                                        }
                                                        catch (ex) {
                                                            console.log("ERROR FROM addMember.ufoHandleComplete.handleCreatureMouseOver() :: " + ex);
                                                        }
                                                    }

                                                    gameState.arrSelection.push(selectCreature);
                                                    //conBandStage.addChild(selectCreature);

                                                    if (i == gameState.selectionNumber) {
                                                        animateSelection(conBandStage);
                                                    }
                                                }
                                                else {
                                                    --i;
                                                }
                                                // SHOW AFTER TWEEN HAS FIRED
                                                createjs.Tween.get(txtSelectCreature).to({ alpha: 1.0 }, 3000 * tweenMultiplier);
                                            }
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM addMember.ufoHandleComplete() :: " + ex);
                                        }
                                    }
                                }
                                catch (ex) {
                                    console.log("ERROR FROM addMember.bgHandleComplete() :: " + ex);
                                }
                            }

                            // CONTROL PANEL FADE
                            var tweenControl = new createjs.Tween.get(conControls)
                                .to({ alpha: 0, y: 800 }, 2000 * tweenMultiplier);

                            var txtSelectCreature = helpers.textField("SELECT A CREATURE");
                            txtSelectCreature.name = "txtSelectCreature";
                            txtSelectCreature.x = 100;
                            txtSelectCreature.y = 25;
                            txtSelectCreature.alpha = 0.0;
                            view.addChild(txtSelectCreature);

                            var btnConfirm = helpers.confirm("CONFIRM");
                            btnConfirm.name = "btnConfirm";
                            btnConfirm.x = originalWidth / 2;
                            btnConfirm.y = 550;
                            btnConfirm.visible = false;
                            conBandStage.addChild(btnConfirm);
                        }
                        catch (ex) {
                            console.log("ERROR FROM addMember.btnAddMember() :: " + ex);
                        }
                    });
                    button.addEventListener("mouseover", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 1.1, scaleY: 1.1 }, 100)
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.mouseover :: " + ex);
                        }

                    });
                    button.addEventListener("mouseout", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 1.0, scaleY: 1.0 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.mouseout :: " + ex);
                        }
                    });

                    button.addChild(background, image, text);
                    return button;
                } catch (ex) {
                    console.log("ERROR FROM helpers.addMember :: " + ex);
                }
            },
            answer: function (answerData) {
                try {
                    var answer = new createjs.Container();
                    answer.cursor = 'pointer';
                    var x = 0;
                    var y = 0;
                    var width = 600;
                    var height = 75;
                    answer.setBounds(x, y, width, height);

                    var background = new createjs.Shape();
                    background.name = "answerBG";
                    background.graphics.setStrokeStyle(3).beginStroke("#0099FF")//.beginFill("#003D66")
                        .beginLinearGradientFill(
                        ["#003152", "#003D66", "#003D66", "#003152"],
                        [0.1, 0.35, 0.65, 0.9],
                        0, 0, 0, 75)
                        .drawRoundRect(x, y, width, height, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text(answerData.Text, "20pt Arial Black", "#0099FF");
                    text.name = "txtAnswer";
                    text.shadow = standardTextShadow;
                    text.x = width / 2;
                    text.y = (height / 2) + 10;
                    text.textAlign = "center";
                    text.textBaseline = "bottom";
                    text.lineWidth = width - 50;

                    var hit = new createjs.Shape();
                    hit.graphics.beginFill("#000000").drawRect(0, 0, width, height).endFill();
                    answer.hitArea = hit;

                    if (answerData.Text.length < 80) {
                        text.font = "20pt Arial Black";
                    } else if (answerData.Text.length < 120) {
                        text.font = "18pt Arial Black";
                    } else if (answerData.Text.length < 150) {
                        text.font = "15pt Arial Black";
                    } else if (answerData.Text.length < 200) {
                        text.font = "12pt Arial Black";
                    } else {
                        text.font = "10pt Arial Black";
                    }

                    answer.addChild(background, text);

                    answer.on("mouseover", handleAnswerMouseOver);
                    answer.on("mouseout", handleAnswerMouseOver);
                    answer.on("click", handleAnswerClick);

                    // NEED TO ADD ISSELECTED TO ACTIVATE A TWEEN ANIMATION, OR HIGHLIGHTED EFFECT...
                    // THEN NEXT.CLICK WILL TAKE CARE CHECKING THE ANSWER
                    function handleAnswerClick(event) {
                        try {
                            //console.log("handleAnswerClick :: ");
                            gameState.currentAnswer = answerData;
                            gameState.questionTime = gameState.currentTime;
                            highlightAnswer();
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.answer.handleAnswerClick() :: " + ex);
                        }
                    }
                    function handleAnswerMouseOver(event) {
                        try {
                            var answer = event.currentTarget.getChildAt(0);

                            if (event.type == "mouseover") {
                                createjs.Tween.get(answer, { loop: false }).to({ alpha: 0.5 });
                            }
                            else {
                                createjs.Tween.get(answer, { loop: false }).to({ alpha: 1.0 });
                            }
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.answer.handleAnswerMouseOver() :: " + ex);
                        }
                    }

                    return answer;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.answer :: " + ex);
                }
            },
            confirm: function (buttonText) {
                try {
                    var button = new createjs.Container();
                    button.regX = 100;
                    button.regY = 25;
                    button.cursor = "pointer";

                    var background = new createjs.Shape();
                    background.name = "BG";
                    background.graphics.setStrokeStyle(2).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 200, 50, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text(buttonText, "20pt Arial Black", "#0099FF");
                    text.shadow = standardTextShadow;
                    text.x = 100;
                    text.y = 25;
                    text.textAlign = "center";
                    text.textBaseline = "middle";

                    button.addEventListener("click", function (event) {
                        try {
                            //console.log("btnConfirm click :: show Question");
                            soundCheck.stop();

                            var conBandStage = view.getChildByName("conBandStage");
                            var btnConfirm = conBandStage.getChildByName("btnConfirm");
                            btnConfirm.visible = false;
                            conBandStage.removeChild(btnConfirm);
                            btnConfirm = null;

                            var txtSelectCreature = view.getChildByName("txtSelectCreature");
                            txtSelectCreature.visible = false;
                            view.removeChild(txtSelectCreature);
                            txtSelectCreature = null;

                            for (var i = 0; i <= gameState.arrSelection.length - 1; ++i) {
                                var tempCreature = gameState.arrSelection[i];

                                if (gameState.currentSelection.name == tempCreature.name) {
                                    var imageUFO = conBandStage.getChildByName("imageUFO");
                                    var tweenUFO = new createjs.Tween.get(imageUFO)
                                        .to({ y: -60 }, 1000 * tweenMultiplier);

                                    // SELECTED CREATURE RISE
                                    var tweenCreature = new createjs.Tween.get(gameState.currentSelection)
                                        .to({ x: 400, y: 75, scaleX: 0.25, scaleY: 0.25 }, 1000 * tweenMultiplier)
                                        .call(handleComplete);

                                    function handleComplete() {
                                        //console.log("HELLO FROM handleComplete() :: SHOW QUESTIONS WINDOW");
                                        gameState.currentSelection.shadow = null;
                                        gameState.currentSelection.removeAllEventListeners();

                                        var conQuestionWindow = createQuestionWindow();
                                        conQuestionWindow.x = 150;
                                        conQuestionWindow.y = 150;
                                        conQuestionWindow.scaleX = 0.75;
                                        conQuestionWindow.scaleY = 0.75;

                                        //Global Variable used for controlling the next button
                                        windowQuestion = conQuestionWindow;

                                        conBandStage.addChild(conQuestionWindow);
                                    }
                                }
                                else {
                                    conBandStage.removeChild(tempCreature);
                                }
                            }
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.confirm.click :: " + ex);
                        }
                    });
                    button.addEventListener("mouseover", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 1.1, scaleY: 1.1 }, 100)
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.confirm.mouseover :: " + ex);
                        }
                    });
                    button.addEventListener("mouseout", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 1.0, scaleY: 1.0 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.confirm.mouseout :: " + ex);
                        }
                    });

                    button.addChild(background, text);
                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.confirm :: " + ex);
                }

            },
            createButton: function (buttonText) {
                try {
                    var button = new createjs.Container();
                    button.cursor = 'pointer';

                    var background = new createjs.Shape();
                    background.name = "BG";
                    background.graphics.setStrokeStyle(1).beginStroke("dark gray").beginFill("purple").drawRoundRect(0, 0, 150, 25, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text(buttonText, "8pt Arial Black", "White");
                    text.shadow = standardTextShadow;
                    text.x = 75;
                    text.y = 12.5;
                    text.textAlign = "center";
                    text.textBaseline = "middle";

                    var hit = new createjs.Shape();
                    hit.graphics.beginFill("#000000").drawRect(0, 0, text.getMeasuredWidth(), text.getMeasuredHeight());
                    text.hitArea = hit;

                    button.addChild(background, text);

                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.createButton :: " + ex);
                }
            },
            endGame: function () {
                try {
                    var button = new createjs.Container();
                    button.regX = 75;
                    button.regY = 12.5;
                    button.cursor = 'pointer';

                    var background = new createjs.Shape();
                    background.name = "BG";
                    background.graphics.setStrokeStyle(1).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 150, 25, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text("Conclude Game", "12pt Arial Black", "#FFFFFF");
                    text.shadow = standardTextShadow;
                    text.x = 75;
                    text.y = 12.5;
                    text.textAlign = "center";
                    text.textBaseline = "middle";

                    var hit = new createjs.Shape();
                    hit.graphics.beginFill("#000000").drawRect(0, 0, text.getMeasuredWidth(), text.getMeasuredHeight());
                    text.hitArea = hit;

                    button.addChild(background, text);

                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.createButton :: " + ex);
                }
            },
            feedback: function (answerText) {
                try {
                    var feedback = new createjs.Container();
                    var x = 0;
                    var y = 0;
                    var width = 500;
                    var height = 75;
                    feedback.setBounds(x, y, width, height);

                    var background = new createjs.Shape();
                    background.name = "bgFeedback";
                    background.graphics.setStrokeStyle(3).beginStroke("#29ABE2")//.beginFill("#999999")
                        .beginLinearGradientFill(
                        ["#333333", "#666666", "#333333"],
                        [0.1, 0.5, 0.9],
                        0, 0, 0, 75)
                        .drawRoundRect(x, y, width, height, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text(answerText, "16pt Arial Black", "#29ABE2");
                    text.name = "txtFeedback";
                    text.shadow = standardTextShadow;
                    text.x = width / 2;
                    text.y = height / 2;
                    text.textAlign = "center";
                    text.textBaseline = "bottom";
                    text.lineWidth = width - 50;

                    feedback.addChild(background, text);

                    return feedback;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.feedback :: " + ex);
                }
            },
            instructions: function () {
                try {
                    var instructionsContainer = new createjs.Container();
                    instructionsContainer.x = 0;
                    instructionsContainer.y = 0;
                    instructionsContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 0, 50));
                    instructionsContainer.cursor = 'pointer';

                    var instructionsBG = new createjs.Bitmap(resourceLoader.getResult("instructions_background"));
                    instructionsBG.x = 50;
                    instructionsBG.y = 0;
                    instructionsBG.rotation = 90;
                    //instructionsBG.skewY = -90;

                    instructionsContainer.addChild(instructionsBG);

                    var questionMark = new createjs.Bitmap(resourceLoader.getResult("instructions_question"));
                    questionMark.x = 0;
                    questionMark.y = -5;

                    questionMark.filters = [new createjs.ColorFilter(0, 0, 0, 1, 0, 0, 0, 0)];
                    questionMark.cache(0, 0, 50, 50);

                    instructionsContainer.addChild(questionMark);

                    instructionsContainer.addEventListener("click", function () {
                        try {
                            if (gameState.isRunning) { return; }

                            //clearScreen();
                            bandView = view;
                            showView(getInstructionsView());
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.instructions :: " + ex);
                        }
                    });
                    instructionsContainer.on("mouseover", handleInstructionsMouseOver);
                    instructionsContainer.on("mouseout", handleInstructionsMouseOver);

                    function handleInstructionsMouseOver(event) {
                        try {
                            if (event.type == "mouseover") {
                                createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0625, scaleY: 1.0625 }, 50);
                            }
                            else {
                                createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0, scaleY: 1.0 }, 50);
                            }
                        }
                        catch (ex) {
                            console.log("ERROR FROM handleInstructionsMouseOver() :: " + ex);
                        }
                    }

                    return instructionsContainer;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.instructions :: " + ex);
                }
            },
            masterControlsBandView: function () {
                try {
                    var conControls = new createjs.Container();
                    conControls.name = "conControls";
                    conControls.x = 0;
                    conControls.y = 500;

                    var conControlsBG = new createjs.Bitmap(resourceLoader.getResult("microphoneBG"));
                    conControlsBG.x = 0;
                    conControlsBG.y = -225;
                    conControlsBG.scaleY = 1.02;

                    // Display Instruction Text Area
                    var conText = new createjs.Container();
                    conText.name = "conText";
                    conText.x = 10;
                    conText.y = 35;

                    var conTextBG = new createjs.Shape();
                    conTextBG.graphics.setStrokeStyle(3).beginFill("#000000").beginStroke("#29ABE2").drawRoundRect(0, 0, 780, 60, 25).endStroke().endFill;

                    var txtInstructions = new createjs.Text("", "14pt Arial", "#29ABE2");
                    txtInstructions.name = "txtInstructions";
                    txtInstructions.x = 750;
                    txtInstructions.y = 55;
                    txtInstructions.regX = 350;
                    txtInstructions.regY = 25;
                    txtInstructions.textBaseline = "middle"
                    txtInstructions.textAlign = "center";
                    txtInstructions.lineWidth = 700;
                    conText.addChild(conTextBG, txtInstructions);

                    txtInstructions.text = "TO START BUILDING YOUR BAND... CLICK THE ADD MEMBER BUTTON.";

                    // Display Band Count Text Area
                    var conBandCount = new createjs.Container();
                    conBandCount.name = "conBandCount";
                    conBandCount.x = 615;
                    conBandCount.y = -20;

                    var conBandCountBG = new createjs.Shape();
                    conBandCountBG.graphics.setStrokeStyle(3).beginFill("#000000").beginStroke("#29ABE2").drawRoundRect(0, 0, 175, 50, 25).endStroke().endFill;

                    var txtBandCount = new createjs.Text("Band Count : 0", "16pt Arial white", "#29ABE2");
                    txtBandCount.name = "txtBandCount";
                    txtBandCount.x = 175;
                    txtBandCount.y = 50;
                    txtBandCount.regX = 87.5;
                    txtBandCount.regY = 25;
                    txtBandCount.textBaseline = "middle"
                    txtBandCount.textAlign = "center";
                    txtBandCount.lineWidth = 150;

                    conBandCount.addChild(conBandCountBG, txtBandCount);

                    // Display Band Count Text Area
                    var conScore = new createjs.Container();
                    conScore.name = "conScore";
                    conScore.x = 10;
                    conScore.y = -20;

                    var conScoreBG = new createjs.Shape();
                    conScoreBG.graphics.setStrokeStyle(3).beginFill("#000000").beginStroke("#29ABE2").drawRoundRect(0, 0, 175, 50, 25).endStroke().endFill;

                    var txtScore = new createjs.Text("Score : 0", "16pt Arial white", "#29ABE2");
                    txtScore.name = "txtScore";
                    txtScore.x = 175;
                    txtScore.y = 50;
                    txtScore.regX = 87.5;
                    txtScore.regY = 25;
                    txtScore.textBaseline = "middle"
                    txtScore.textAlign = "center";
                    txtScore.lineWidth = 150;

                    conScore.addChild(conScoreBG, txtScore);

                    // Display Add Button
                    var btnAddMember = helpers.addMember();
                    btnAddMember.name = "btnAddMember";
                    btnAddMember.x = 400
                    btnAddMember.y = 5

                    // *************************************************************************
                    // DEFAULT BUTTONS USED WHEN TESTING AND ADDING CREATURES/SOUNDS
                    //var btnTest1 = helpers.createButton("Add Creature");
                    //btnTest1.x = 20;
                    //btnTest1.y = -100;

                    //btnTest1.addEventListener("click", function (event) {
                    //    try {
                    //        //console.log("btnTest1 click ::  ");
                    //        // ************************************************************
                    //        //newSpriteTesting();
                    //        var _conBandStage = view.getChildByName("conBandStage");

                    //        var myTempCreature = getCreature();
                    //        myTempCreature.x = originalWidth / 2;
                    //        myTempCreature.y = 500;
                    //        myTempCreature.scaleX = 0.5;
                    //        myTempCreature.scaleY = 0.5;

                    //        myTempCreature.soundInstance.play({ loop: -1, volume: 1.0 });
                    //        creatureControls(myTempCreature);
                    //        animateCreature(myTempCreature);

                    //        gameState.myBand.push(myTempCreature);

                    //        _conBandStage.addChild(myTempCreature);
                    //        // ************************************************************
                    //    }
                    //    catch (ex) {
                    //        console.log("ERROR FROM helpers.masterControls.btnTest1.click :: " + ex);
                    //    }
                    //});

                    //// Display Play/Pause Button
                    //var btnTest2 = helpers.createButton("getGameProgress");
                    //btnTest2.x = 200;
                    //btnTest2.y = -100;

                    //btnTest2.addEventListener("click", function (event) {
                    //    try {
                    //        //console.log("btnTest2 click :: ");
                    //        getGameProgress();
                    //    }
                    //    catch (ex) {
                    //        console.log("ERROR FROM helpers.masterControls.btnTest2.click :: " + ex);
                    //    }
                    //});
                    // *************************************************************************

                    conControls.addChild(conControlsBG, conText, btnAddMember, conBandCount, conScore); //, btnTest1, btnTest2, volumeKnob, volumeGauge
                    return conControls;
                } catch (ex) {
                    console.log("ERROR FROM helpers.masterControlsBandView :: " + ex);
                }
            },
            masterControlsSoundBoard: function () {
                try {
                    var conMasterControls = new createjs.Container();
                    conMasterControls.name = "masterControl"
                    conMasterControls.x = 50;
                    conMasterControls.y = 500;

                    var conMasterControlsBG = new createjs.Shape();
                    conMasterControlsBG.graphics.setStrokeStyle(5).beginFill("#232A4C").beginStroke("3A4B9C").drawRoundRect(0, 0, 700, 50, -25).endStroke().endFill;

                    var txtMasterControl = new createjs.Text("Master Controls", "10pt Arial Black", "#435CCE");
                    txtMasterControl.x = 50;
                    txtMasterControl.y = 10;

                    // CREATE PLAY BUTTON
                    var btnTestPlay = new createjs.Bitmap(resourceLoader.getResult("start_button"));
                    btnTestPlay.shadow = new createjs.Shadow("gray", 3, 3, 3);
                    btnTestPlay.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                    btnTestPlay.cursor = 'pointer';
                    btnTestPlay.regX = 0;
                    btnTestPlay.regY = 0;
                    btnTestPlay.x = 200;
                    btnTestPlay.y = 5;
                    btnTestPlay.scaleX = 0.4;
                    btnTestPlay.scaleY = 0.4;
                    var isPlaying = false;

                    btnTestPlay.addEventListener("click", function (event) {
                        try {
                            console.log("btnPlay click :: Play All Clips");

                            if (!isPlaying) {
                                btnTestPlay.image = resourceLoader.getResult("stop_button");
                                isPlaying = true;
                            } else {
                                btnTestPlay.image = resourceLoader.getResult("start_button");
                                isPlaying = false;
                            }
                            playAllTracks(gameState.audioClips);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.masterControls.btnTestPlay.click :: " + ex);
                        }
                    });
                    btnTestPlay.addEventListener("mouseover", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 0.5, scaleY: 0.5 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.masterControls.btnTestPlay.mouseover :: " + ex);
                        }
                    });
                    btnTestPlay.addEventListener("mouseout", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 0.4, scaleY: 0.4 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.masterControls.btnTestPlay.mouseout :: " + ex);
                        }
                    });

                    // CREATE THE MUTE BUTTON
                    var btnTestMute = new createjs.Bitmap(resourceLoader.getResult("musicOn"));
                    btnTestMute.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                    btnTestMute.cursor = 'pointer';
                    btnTestMute.regX = 0;
                    btnTestMute.regY = 0;
                    btnTestMute.x = 300;
                    btnTestMute.y = 15;
                    btnTestMute.scaleX = 0.5;
                    btnTestMute.scaleY = 0.5;

                    btnTestMute.addEventListener("click", function (event) {
                        try {
                            //console.log("btnTestMute click :: isMuted " + resourceLoader.getResult("musicOn"));   
                            if (createjs.Sound.getMute()) {
                                btnTestMute.image = resourceLoader.getResult("musicOn");
                                createjs.Sound.setMute(false);
                            } else {
                                btnTestMute.image = resourceLoader.getResult("musicOff");
                                createjs.Sound.setMute(true);
                            }
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.masterControls.btnTestMute.click :: " + ex);
                        }
                    });
                    btnTestMute.addEventListener("mouseover", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 0.6, scaleY: 0.6 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.masterControls.btnTestMute.mouseover :: " + ex);
                        }
                    });
                    btnTestMute.addEventListener("mouseout", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 0.5, scaleY: 0.5 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.masterControls.btnTestMute.mouseout :: " + ex);
                        }
                    });

                    var sldVolume = document.createElement("input");
                    sldVolume.name = "masterVolumeSlider";
                    sldVolume.setAttribute("type", "range");
                    sldVolume.value = 50;
                    sldVolume.min = 1;
                    sldVolume.max = 100;
                    sldVolume.step = 1;
                    sldVolume.style.width = "50";
                    //sldVolume.style.font = "16pt Georgia";
                    self.stage.canvas.parentElement.insertBefore(sldVolume, canvas);

                    var sldVolumeInputControl = new createjs.DOMElement(sldVolume);
                    sldVolumeInputControl.name = "masterVolumeSliderControl";
                    sldVolumeInputControl.x = 400;
                    sldVolumeInputControl.y = 15;
                    sldVolumeInputControl.width = 150;
                    sldVolumeInputControl.height = 16;
                    sldVolumeInputControl.setBounds(sldVolumeInputControl.x, sldVolumeInputControl.y, sldVolumeInputControl.width, sldVolumeInputControl.height);

                    sldVolume.addEventListener("change", function () {
                        try {
                            createjs.Sound.setVolume(sldVolume.value / 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.masterControls.sldVolume.change :: " + ex);
                        }
                    });

                    conMasterControls.addChild(conMasterControlsBG, txtMasterControl, sldVolumeInputControl, btnTestPlay, btnTestMute);
                    return conMasterControls;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.masterControls :: " + ex);
                }
            },
            muteButton: function () {
                try {
                    // CREATE MUTE BUTTON
                    var button = new createjs.Container();
                    button.cursor = 'pointer';
                    button.scaleX = 0.6;
                    button.scaleY = 0.6;

                    var background = new createjs.Bitmap(resourceLoader.getResult("musicOn"));
                    background.shadow = new createjs.Shadow("gray", 3, 3, 3);

                    button.addEventListener("click", function (event) {
                        try {
                            console.log("btnMute click :: MUTE All Clips");
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.muteButton.click :: " + ex);
                        }
                    });
                    button.addEventListener("mouseover", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 0.8, scaleY: 0.8 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.muteButton.mouseover :: " + ex);
                        }

                    });
                    button.addEventListener("mouseout", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 0.6, scaleY: 0.6 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.muteButton.mouseout :: " + ex);
                        }
                    });

                    button.addChild(background);

                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.muteButton :: " + ex);
                }
            },
            nextButton: function (buttonText) {
                try {
                    var button = new createjs.Container();
                    button.cursor = "pointer";

                    var background = new createjs.Shape();
                    background.name = "BG";
                    background.graphics.setStrokeStyle(2).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 150, 50, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text(buttonText, "18pt Arial Black", "#0099FF");
                    text.shadow = standardTextShadow;
                    text.x = 75;
                    text.y = 25;
                    text.textAlign = "center";
                    text.textBaseline = "middle";

                    button.addChild(background, text);

                    button.addEventListener("click", function (event) {
                        try {
                            //console.log("Hello :: QuestionWindow Next Button")
                            var _string = windowQuestion.name;

                            switch (_string) {
                                case "windowQuestions":
                                    //console.log("Hello :: windowQuestions")
                                    if (!(gameState.currentAnswer == null)) {
                                        checkAnswer();
                                        showFeedbackWarning(true);
                                        gameState.isTimerRunning = false;
                                    }
                                    else {
                                        showFeedbackWarning(false);
                                    }
                                    break;
                                case "windowCorrect":
                                    if (gameState.isQuestionComplete) { return; }
                                    //console.log("Hello :: windowCorrect")
                                    tweenMultiplier = .25
                                    gameState.isQuestionComplete = true;
                                    gameState.score += gameState.questionPoints + getBonusPoints();

                                    var tweenQuestionWindow = new createjs.Tween.get(windowQuestion)
                                        .to({ alpha: 0 }, 500 * tweenMultiplier);

                                    var tweenCreatureCorrect = new createjs.Tween.get(gameState.currentSelection)
                                        .to({ x: 400, y: 350, scaleX: 0.5, scaleY: 0.5 }, 1500 * tweenMultiplier)
                                        .call(handleCorrectComplete);

                                    function handleCorrectComplete() {
                                        try {
                                            if (!soundEffect.getMute()) {
                                                soundEffect = createjs.Sound.play("tubeShimmer", { loop: 0, volume: 0.75 });
                                                arrSoundEffects.push(soundEffect);
                                            }

                                            //console.log("HELLO FROM handleCorrectComplete() :: Trigger Correct/Vicotry Animation");
                                            tweenCreatureCorrect = new createjs.Tween.get(gameState.currentSelection)
                                                .to({ shadow: highlightShadow }, 1000 * tweenMultiplier)
                                                .to({ shadow: null }, 1000 * tweenMultiplier)
                                                //.to({ shadow: highlightShadow }, 1000)
                                                //.to({ shadow: null }, 1000)
                                                .to({ shadow: highlightShadow }, 800 * tweenMultiplier)
                                                .to({ shadow: null }, 800 * tweenMultiplier)
                                                .to({ shadow: highlightShadow }, 600 * tweenMultiplier)
                                                .to({ shadow: null }, 600 * tweenMultiplier)
                                                //.to({ shadow: highlightShadow }, 600)
                                                //.to({ shadow: null }, 600)
                                                .to({ shadow: highlightShadow }, 0)
                                                .to({ shadow: null }, 0)
                                                .call(handleFlashComplete);
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM handleCorrectComplete() :: " + ex);
                                        }
                                    }

                                    function handleFlashComplete() {
                                        try {
                                            //console.log("HELLO FROM handleFlashComplete() :: Trigger Pan down with creature");
                                            var _conBandStage = view.getChildByName("conBandStage");

                                            for (var i = 0; i < arrSoundEffects.length; ++i) {
                                                var tempSound = arrSoundEffects[i];
                                                // Only turn Off ufoHover
                                                if (tempSound.name == "ufoHover") {
                                                    tempSound.stop();
                                                }
                                            }

                                            var _imageUFO = _conBandStage.getChildByName("imageUFO");
                                            _conBandStage.removeChild(_imageUFO);
                                            _imageUFO = null;

                                            var conTube = _conBandStage.getChildByName(gameState.currentSelection.name);

                                            //var tempCreature = conTube.getChildByName("conCreature");
                                            var tempCreature = conTube.getChildAt(2);
                                            tempCreature.x = conTube.x;
                                            tempCreature.y = conTube.y;
                                            tempCreature.mask = null;

                                            // May need to use switch case for each creature to even out the sizes
                                            tempCreature.scaleX = 0.5;
                                            tempCreature.scaleY = 0.5;

                                            var i = 0;
                                            do {
                                                var tempObject = gameState.creatures[i];
                                                i++;
                                            } while (gameState.currentSelection.name != tempObject.id)

                                            _conBandStage.addChild(tempCreature);
                                            _conBandStage.removeChild(gameState.currentSelection);

                                            if (!soundEffect.getMute()) {
                                                soundEffect = createjs.Sound.play("tubeShatter", { loop: 0, volume: 0.75 });
                                                arrSoundEffects.push(soundEffect);
                                            }

                                            var whiteOut = new createjs.Shape();
                                            whiteOut.graphics.setStrokeStyle(1).beginStroke("#FFFFFF").beginFill("#FFFFFF").drawRect(0, 0, originalWidth, originalHeight).endStroke().endFill();
                                            whiteOut.alpha = 1.0;
                                            view.addChild(whiteOut);

                                            tweenWhiteOut = new createjs.Tween.get(whiteOut)
                                                .wait(1000)
                                                .to({ alpha: 0.0 }, 3000 * tweenMultiplier)
                                                .call(handleWhiteOutComplete, [tempCreature]);
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM helpers.confirm.handleFlashComplete :: " + ex);
                                        }
                                    }

                                    function handleWhiteOutComplete(tempCreature) {
                                        try {
                                            var tweenBandStage = new createjs.Tween.get(bandView.getChildByName("conBandStage"))
                                                .call(animateBackground, [false])
                                                .to({ y: -300 }, 2000 * tweenMultiplier)
                                                .call(bgHandleComplete, [tempCreature]);

                                            var tweenCreature = new createjs.Tween.get(tempCreature)
                                                .to({ y: 600 }, 1500 * tweenMultiplier)
                                                .call(creatureComplete, [tempCreature]);

                                            var tweenControls = new createjs.Tween.get(view.getChildByName("conControls"))
                                                .to({ alpha: 1.0, y: 500 }, 2000 * tweenMultiplier);//y: 600 
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM helpers.confirm.mouseover :: " + ex);
                                        }
                                    }

                                    function creatureComplete(tempCreature) {
                                        var _conBandStage = view.getChildByName("conBandStage");
                                        tempCreature.name = gameState.currentSelection.name;
                                        gameState.myBand.push(tempCreature);

                                        // Add controls for the new creature
                                        creatureControls(tempCreature);
                                    }

                                    function bgHandleComplete() {
                                        try {
                                            roundCleanUp()
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM bgHandleComplete() :: " + ex);
                                        }
                                    }

                                    break;
                                case "windowWrong":
                                    if (gameState.isQuestionComplete) { return; }
                                    //console.log("Hello :: windowWrong")
                                    gameState.isQuestionComplete = true;
                                    gameState.score -= gameState.questionPoints;

                                    var tweenQuestionWindow = new createjs.Tween.get(windowQuestion)
                                        .to({ alpha: 0 }, 1000 * tweenMultiplier);

                                    var tweenCreatureWrong = new createjs.Tween.get(gameState.currentSelection)
                                        .to({ x: 400, y: 250, scaleX: 0.5, scaleY: 0.5 }, 1500 * tweenMultiplier)
                                        .call(handleWrongComplete);

                                    function handleWrongComplete() {
                                        try {
                                            //console.log("HELLO FROM handleComplete() :: Trigger Wrong/Lose Animation");
                                            var _conBandStage = view.getChildByName("conBandStage");

                                            var conTube = _conBandStage.getChildByName(gameState.currentSelection.name);
                                            var tempCreature = conTube.getChildAt(2);
                                            gameState.lostCreatures.push(tempCreature);

                                            tweenCreatureWrong = new createjs.Tween.get(gameState.currentSelection)
                                                .to({ x: 400, y: 120, scaleX: 0.0, scaleY: 0.0, rotation: 360 }, 1000 * tweenMultiplier)
                                                .call(handleCreatureVanish);
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM handleWrongComplete() :: " + ex);
                                        }
                                    }

                                    function handleCreatureVanish() {
                                        try {
                                            //console.log("HELLO FROM handleCreatureVanish() :: Remove creature and run UFO leaving");
                                            if (!soundEffect.getMute()) {
                                                soundEffect = createjs.Sound.play("tubeSlurp", { loop: 0, volume: 0.75 });
                                                arrSoundEffects.push(soundEffect);
                                            }

                                            var _conBandStage = view.getChildByName("conBandStage");
                                            var _imageUFO = _conBandStage.getChildByName("imageUFO");

                                            _conBandStage.removeChild(gameState.currentSelection);

                                            if (!soundEffect.getMute()) {
                                                soundEffect = createjs.Sound.play("ufoMoving", { loop: 0, volume: 0.75 });
                                                arrSoundEffects.push(soundEffect);
                                            }

                                            var tweenUFO;
                                            createjs.MotionGuidePlugin.install(tweenUFO);

                                            tweenUFO = new createjs.Tween.get(_imageUFO, true)
                                                .to({ y: +110 }, 1000 * tweenMultiplier) // This will put UFO in starting position of ( guide: { path: [] } )
                                                .wait(500)
                                                .to({ guide: { path: [400, 50, 400, 0, 300, 0, 200, 0, 200, 150, 200, 250, 300, 250], orient: false }, scaleX: 0.5, scaleY: 0.5 }, 2000 * tweenMultiplier)
                                                .call(function () { if (!soundEffect.getMute()) { soundEffect = createjs.Sound.play("ufoLeaving", { loop: 0, volume: 0.75 }); arrSoundEffects.push(soundEffect); } })
                                                .to({ guide: { path: [300, 250, 700, 250, 700, 150], orient: false }, scaleX: 0.0, scaleY: 0.0 }, 1000 * tweenMultiplier)
                                                .call(handleUFOVanish);
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM handleCreatureVanish() :: " + ex);
                                        }
                                    }

                                    function handleUFOVanish() {
                                        try {
                                            //console.log("HELLO FROM handleCreatureVanish() :: Remove UFO and pan down");
                                            //console.log("UFO Coords :: (" + imageUFO.x + ", " + imageUFO.y + ")");
                                            var _conBandStage = view.getChildByName("conBandStage");

                                            var _imageUFO = _conBandStage.getChildByName("imageUFO");
                                            _conBandStage.removeChild(_imageUFO);
                                            _imageUFO = null;

                                            if (!soundEffect.getMute()) {
                                                soundEffect = createjs.Sound.play("ufoGone", { loop: 0, volume: 0.75 });
                                                arrSoundEffects.push(soundEffect);
                                            }

                                            var starFlash = new createjs.Shape();
                                            starFlash.graphics.beginFill("#FFFFFF").drawPolyStar(700, 150, 50, 4, 0.9, 0);
                                            _conBandStage.addChild(starFlash);
                                            var tweenStar = new createjs.Tween.get(starFlash).to({ alpha: 0.0 }, 1000 * tweenMultiplier)
                                                .call(handleStarFade);
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM handleUFOVanish() :: " + ex);
                                        }
                                    }

                                    function handleStarFade() {
                                        try {
                                            var tweenBandStage = new createjs.Tween.get(bandView.getChildByName("conBandStage"))
                                                .call(animateBackground, [false])
                                                .to({ y: -300 }, 2000 * tweenMultiplier)
                                                .call(bgHandleComplete);

                                            var _conControl = view.getChildByName("conControls");
                                            var tweenControls = new createjs.Tween.get(_conControl)
                                                .to({ alpha: 1.0, y: 500 }, 2000 * tweenMultiplier);

                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM handleStarFade() :: " + ex);
                                        }
                                    }

                                    function bgHandleComplete() {
                                        try {
                                            roundCleanUp()
                                        }
                                        catch (ex) {
                                            console.log("ERROR FROM bgHandleComplete() :: " + ex);
                                        }
                                    }

                                    break;
                            }
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.nextButton.click :: " + ex);
                        }
                    });

                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.nextButton :: " + ex);
                }
            },
            pageHeading: function (headingText) {
                try {
                    var heading = new createjs.Container();
                    var x = 0;
                    var y = 0;
                    var width = 590;
                    var height = 125;
                    heading.setBounds(x, y, width, height);

                    var background = new createjs.Shape();
                    background.graphics.setStrokeStyle(3).beginStroke("#29ABE2")//.beginFill("#4F5570")
                        .beginLinearGradientFill(
                        ["#333333", "#666666", "#333333"],
                        [0.1, 0.5, 0.9],
                        0, 0, 0, 125)
                        .drawRoundRect(x, y, width, height, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text(headingText, "20pt Arial Black", "#29ABE2");
                    text.shadow = standardTextShadow;
                    text.x = width / 2;
                    text.y = (height / 2) - 10;
                    text.textAlign = "center";
                    text.textBaseline = "bottom";
                    text.lineWidth = width - 40;

                    if (headingText.length < 80) {
                        text.font = "20pt Arial Black";
                    } else if (headingText.length < 120) {
                        text.font = "18pt Arial Black";
                    } else if (headingText.length < 150) {
                        text.font = "15pt Arial Black";
                    } else if (headingText.length < 200) {
                        text.font = "12pt Arial Black";
                    } else {
                        text.font = "10pt Arial Black";
                    }

                    heading.addChild(background, text);

                    return heading;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.pageHeading :: " + ex);
                }
            },
            pageFooter: function (footerText) {
                try {
                    // Display current selection towards bottom
                    var conFooter = new createjs.Container();
                    var x = 0;
                    var y = 0;
                    var width = 400;
                    var height = 75;
                    conFooter.setBounds(x, y, width, height);

                    var background = new createjs.Shape();
                    background.graphics.setStrokeStyle(1).beginStroke("#0000FF").beginFill("#70B8FF").drawRoundRect(x, y, width, height, 5).endStroke().endFill();

                    var text = new createjs.Text(footerText, "12pt Arial Black", "#000000");
                    text.x = width / 2;
                    text.y = height / 2;
                    //text.x = 0;
                    //text.y = 0;
                    text.textAlign = "center";
                    text.textBaseline = "bottom";
                    text.lineWidth = width - 50;

                    conFooter.addChild(background, text);

                    return conFooter;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.pageFooter :: " + ex);
                }
            },
            pauseButton: function () {
                try {
                    // MIMIC STOP BUTTON TO GET THIS WORKING...
                    // NOT IMPLEMENTED YET.

                    var spriteData = {
                        images: [resourceLoader.getResult("pause_button")],
                        frames: [
                            [0, 0, 100, 40, 0],
                            [0, 40, 100, 40, 0],
                        ]
                    }

                    var spriteSheet = new createjs.SpriteSheet(spriteData);
                    var pauseSprite = new createjs.Sprite(spriteSheet);
                    var pauseHit = new createjs.Shape();
                    pauseHit.graphics.beginFill("#000").drawRect(0, 0, 80, 40);
                    var pauseBtn = new createjs.Container();
                    pauseBtn.name = "controlsLogoutButtonContainer";
                    pauseBtn.x = 150;
                    pauseBtn.y = 12;
                    pauseBtn.addChild(pauseSprite);

                    var pauseHelper = new createjs.ButtonHelper(pauseSprite, "3", "2", "2", false, pauseHit);
                    pauseBtn.addEventListener("click", function (event) {
                        try {

                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.pauseButton.click :: " + ex);
                        }
                    });
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.pauseButton :: " + ex);
                }
            },
            playButton: function () {
                try {
                    // CREATE PLAY BUTTON
                    var button = new createjs.Container();
                    button.cursor = 'pointer';

                    var background = new createjs.Bitmap(resourceLoader.getResult("play"));
                    background.regX = 35;
                    background.regY = 35;
                    background.scaleX = 1.0;
                    background.scaleY = 1.0;
                    //background.shadow = new createjs.Shadow("gray", 3, 3, 3);
                    //background.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(25, 25, 25));


                    button.addEventListener("click", function (event) {
                        try {
                            console.log("btnPlay click :: Play All Clips");

                            //if (!isPlaying) {
                            //    btnTestPlay.image = resourceLoader.getResult("pause_button");
                            //    isPlaying = true;
                            //} else {
                            //    btnTestPlay.image = resourceLoader.getResult("start_button");
                            //    isPlaying = false;
                            //}
                            //playAllTracks();
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.click :: " + ex);
                        }
                    });
                    button.addEventListener("mouseover", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 1.1, scaleY: 1.1 }, 100)
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.mouseover :: " + ex);
                        }

                    });
                    button.addEventListener("mouseout", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ scaleX: 1.0, scaleY: 1.0 }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.mouseout :: " + ex);
                        }
                    });

                    button.addChild(background);
                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.playButton :: " + ex);
                }

            },
            stopButton: function () {
                try {
                    // CREATE STOP BUTTON
                    var button = new createjs.Container();

                    var spriteData = {
                        images: [resourceLoader.getResult("new_stop_button")],
                        frames: [
                            [0, 0, 30, 30, 0],
                            [0, 32, 30, 30, 0],
                        ]
                    }

                    var spriteSheet = new createjs.SpriteSheet(spriteData);
                    var stopSprite = new createjs.Sprite(spriteSheet);

                    var stopHit = new createjs.Shape();
                    stopHit.graphics.beginFill("#000").drawRect(0, 0, 30, 30);

                    button.addChild(stopSprite);

                    var stopHelper = new createjs.ButtonHelper(stopSprite, "1", "0", "0", false, stopHit);

                    button.addEventListener("click", function (event) {
                        try {
                            console.log("btnStop click :: Stop All Clips");

                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.stopButton :: " + ex);
                        }
                    });

                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.stopButton :: " + ex);
                }

            },
            sliderControl: function () {
                try {
                    var sldVolume = document.createElement("input");
                    sldVolume.name = "masterVolumeSlider";
                    sldVolume.id = "masterVolumeSlider";
                    sldVolume.setAttribute("type", "range");
                    sldVolume.value = 50;
                    sldVolume.min = 1;
                    sldVolume.max = 100;
                    sldVolume.step = 1;
                    sldVolume.style.width = "50";
                    //sldVolume.style.font = "16pt Georgia";
                    self.stage.canvas.parentElement.insertBefore(sldVolume, canvas);

                    var sldVolumeInputControl = new createjs.DOMElement(sldVolume);
                    sldVolumeInputControl.name = "masterVolumeSliderControl";
                    sldVolumeInputControl.x = 400;
                    sldVolumeInputControl.y = 15;
                    sldVolumeInputControl.width = 150;
                    sldVolumeInputControl.height = 16;
                    sldVolumeInputControl.setBounds(sldVolumeInputControl.x, sldVolumeInputControl.y, sldVolumeInputControl.width, sldVolumeInputControl.height);

                    // Set starting Volume
                    masterSound.setVolume(sldVolume.value / 100);

                    sldVolume.addEventListener("change", function () {
                        try {
                            //console.log("sldrVolume change :: Adjust Volume");
                            //createjs.Sound.setVolume(sldVolume.value / 100);
                            masterSound.setVolume(sldVolume.value / 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM sldVolume.addEventListener :: " + ex);
                        }
                    });

                    return sldVolumeInputControl;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.sliderControl :: " + ex);
                }
            },
            soundEffects: function () {
                try {
                    var soundEffectsContainer = new createjs.Container();
                    soundEffectsContainer.x = originalWidth;
                    soundEffectsContainer.y = 50;
                    soundEffectsContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, -50, 50));
                    soundEffectsContainer.cursor = 'pointer';

                    var soundEffectsBG = new createjs.Bitmap(resourceLoader.getResult("instructions_background"));
                    soundEffectsBG.x = 0;
                    soundEffectsBG.y = 0;
                    soundEffectsBG.rotation = 180;

                    muteIcon = new createjs.Bitmap(resourceLoader.getResult("musicOn"));
                    muteIcon.x = 2;
                    muteIcon.y = -50;
                    muteIcon.scaleX = 0.8;
                    muteIcon.scaleY = 0.8;
                    muteIcon.rotation = 90;

                    soundEffectsContainer.addChild(soundEffectsBG, muteIcon);

                    soundEffectsContainer.addEventListener("click", function () {
                        try {
                            //console.log("SOUND EFFECTS ENABLED OR DISABLED");
                            var tempMute = masterSound.getMute();
                            if (tempMute) {
                                // unMute
                                muteIcon.image = resourceLoader.getResult("musicOn");
                                masterSound.setMute(false);

                                for (var i = 0; i < arrSoundEffects.length; i++) { //arrSoundEffects
                                    var tempSoundEffect = arrSoundEffects[i];
                                    tempSoundEffect.setMute(false);
                                }
                            }
                            else {
                                // reMute
                                muteIcon.image = resourceLoader.getResult("musicOff");
                                masterSound.setMute(true);

                                for (var i = 0; i < arrSoundEffects.length; i++) { //arrSoundEffects
                                    var tempSoundEffect = arrSoundEffects[i];
                                    tempSoundEffect.setMute(true);
                                }
                            }
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.instructions :: " + ex);
                        }
                    });
                    soundEffectsContainer.on("mouseover", handleInstructionsMouseOver);
                    soundEffectsContainer.on("mouseout", handleInstructionsMouseOver);

                    function handleInstructionsMouseOver(event) {
                        try {
                            if (event.type == "mouseover") {
                                createjs.Tween.get(muteIcon, { loop: false }).to({ scaleX: 1.0, scaleY: 1.0 }, 50);
                            }
                            else {
                                createjs.Tween.get(muteIcon, { loop: false }).to({ scaleX: 0.8, scaleY: 0.8 }, 50);
                            }
                        }
                        catch (ex) {
                            console.log("ERROR FROM handleInstructionsMouseOver() :: " + ex);
                        }
                    }

                    return soundEffectsContainer;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.soundEffects :: " + ex);
                }
            },
            textField: function (fieldText) {
                try {
                    var field = new createjs.Container();
                    //field.cursor = "pointer";

                    var background = new createjs.Shape();
                    background.graphics.setStrokeStyle(2).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 600, 80, 5).endStroke().endFill();
                    background.shadow = buttonShadow;

                    var text = new createjs.Text(fieldText, "30pt Arial Black", "White");
                    text.shadow = standardTextShadow;
                    text.x = 300;
                    text.y = 40;
                    text.textAlign = "center";
                    text.textBaseline = "middle";

                    field.addChild(background, text);
                    return field;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.confirm :: " + ex);
                }

            },
            volumeGauge: function () {
                try {
                    var gauge = new createjs.Container();
                    gauge.regX = 13.5;
                    gauge.regY = 50;

                    var background = new createjs.Shape(); // darker background
                    background.graphics.setStrokeStyle(1).beginStroke("#666666").beginFill("#333333").drawRect(0, 0, 25, 100).endStroke().endStroke();

                    var volumeLevel = new createjs.Shape(); // Level of Volume ----- (green bar, red when max volume is reached)
                    volumeLevel.name = "volumeLevel";
                    volumeLevel.graphics.setStrokeStyle(1).beginStroke("#666666").beginFill("#00FF00").drawRect(0, 100, 25, -50).endStroke().endStroke();

                    gauge.addChild(background, volumeLevel);
                    return gauge;
                } catch (ex) { console.log("ERROR FROM helpers.volumeGauge :: " + ex); }
            },
            volumeKnob: function () {
                try {
                    // CREATE PLAY BUTTON
                    var button = new createjs.Container();
                    button.cursor = 'pointer';
                    button.rotation = 0;

                    var background = new createjs.Bitmap(resourceLoader.getResult("volumeKnob"));
                    background.regX = 45;
                    background.regY = 45;
                    background.scaleX = 1.0;
                    background.scaleY = 1.0;

                    // Used in a couple of these events
                    var myStartX;
                    var myStartY;

                    button.addEventListener("click", function (event) {
                        try {
                            //console.log("volumeKnob click :: Volume Knob Control");
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.click :: " + ex);
                        }
                    });
                    button.addEventListener("pressmove", function (event) {
                        try {
                            //console.log("volumeKnob click :: Volume Knob Control");
                            var myEndX = event.stageX;
                            var myEndY = event.stageY;

                            var diffX = myEndX - myStartX;
                            var diffY = (myEndY - myStartY) * 2;
                            var tempRange = (diffX + 100) / 2;
                            var decVolume = (tempRange / 100);

                            // If state should check bounds
                            if (diffX < -100) {
                                diffX = -100;
                            } else if (diffX > 100) { diffX = 100; }

                            if (decVolume < 0) {
                                decVolume = 0;
                            } else if (decVolume > 1) { decVolume = 1; }

                            // Set the values
                            button.rotation = diffX;
                            masterSound.setVolume(decVolume);

                            displayMasterVolumeGauge(decVolume * 100)
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.click :: " + ex);
                        }
                    });
                    button.addEventListener("mousedown", function (event) {
                        try {
                            //console.log("volumeKnob mousedown :: ");
                            myStartX = event.stageX;
                            myStartY = event.stageY;
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.click :: " + ex);
                        }
                    });
                    button.addEventListener("mouseover", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ shadow: highlightShadow }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.mouseover :: " + ex);
                        }

                    });
                    button.addEventListener("mouseout", function (event) {
                        try {
                            createjs.Tween.get(event.currentTarget)
                                .to({ shadow: noShadow }, 100);
                        }
                        catch (ex) {
                            console.log("ERROR FROM helpers.playButton.mouseout :: " + ex);
                        }
                    });

                    button.addChild(background);
                    return button;
                }
                catch (ex) {
                    console.log("ERROR FROM helpers.playButton :: " + ex);
                }
            },
        };

        var originalWidth = self.stage.canvas.width;
        var originalHeight = self.stage.canvas.height;
        self.previousView = null;
        self.currentView = null;

        var cellOrigin = [25, 25];
        var cellMargin = [5, 5];
        var cellSize = [150, 150];

        var gameState = {
            arrSelection: [],
            audioClips: [], // Used to Control Music within Game
            creatures: null,
            currentAnswer: null,
            currentQuestion: null,
            currentSelection: null,
            currentTime: 0,
            endGame: false,
            gameTracks: ["original", "jazzyJay"], // Set which tracks you're using, used to control sounds and animations
            isEndingReady: false,
            isFinale: false,
            isRunning: false,
            isQuestionComplete: false, // Used as bool to control triggering multiple EndRound Animations
            isTimerRunning: false,
            lostCreatures: [],
            maxMembers: 10,
            //maxMembers: 3,
            myBand: [],
            questionPoints: 100,
            questions: gameData.Questions,
            questionTime: 0, // Used to hold the current time tick, bonus points awarded for quicker answering.
            score: 0,
            selectedTracks: 1, // Used for having different music tracks for the creatures
            selectionNumber: 2,
            //sounds: null, // Original sound Object
            soundsJazzyJay: null, // Unique sound Object
            soundEffects: null,
            startTime: 0,
            stageLights: [],
            totalSetsOfTracks: 2, // Total Number of Track Groups, used to Randomize the tracks during gameplay
            usedQuestions: [],
        };

        // if GameData does NOT specify whether or not the questions should be randomized, randomize them
        // otherwise do what gamaData.RandomizeQuestions says
        if (gameData.RandomizeQuestions) {
            gameData.questions = shuffle(gameData.Questions);
        }

        // Randomize Answers?
        for (var i = 0; i < gameData.Questions.length; i++) {
            if (gameData.Questions[i].RandomizeAnswers) {
                gameData.Questions[i].Answers = shuffle(gameData.Questions[i].Answers);
            }
        }

        var lastHint = "";
        var gameHints = [
            "WHEN CREATURES ARE ON THE STAGE, CLICK AND DRAG TO CONTROL THEIR VOLUME LEVEL...\nDOUBLE CLICK ANY CREATURE TO MUTE IT",
            "THE SPEAKER ICON IN THE UPPER RIGHT-HAND CORNER IS FOR MUTING THE SOUND. SHOULD YOU WANT TO CONTROL THE VOLUME OF THE BAND, USE THE CREATURES ON THE STAGE.",
            "THE '?' IN THE UPPER LEFT-HAND CORNER IS THE HELP/INSTRUCTIONS PANEL. GO THERE IF YOU NEED HELP.",
            "IF YOU GET A QUESTION WRONG, THE ALIENS WILL TAKE THE CREATURE FOR THEMSELVES",
            "THE MAX NUMBER OF CREATURES ON YOUR STAGE IS 10.",
        ];

        var view;

        var bandView = null;
        var instructionsView = null;
        var soundBoardView = null;
        var titleView = null;
        var windowQuestion = null;
        var loadingText = new createjs.Text("Loading...", "24px Arial", "#0000FF");

        var masterSound = createjs.Sound;
        var soundEffect = createjs.Sound;
        var arrSoundEffects = [];
        var soundCheck;
        var lastLightFormation;
        var lastLightColor;

        var isLmsConnected = false;
        if (typeof ScormHelper !== 'undefined') {
            isLmsConnected = ScormHelper.initialize();
        }
        if (isLmsConnected) {
            quit = function () {
                ScormHelper.cmi.successStatus(ScormHelper.successStatus.passed);
                ScormHelper.cmi.completionStatus(ScormHelper.completionStatus.completed);
                ScormHelper.cmi.exit("");
                ScormHelper.adl.nav.request("exitAll");
                ScormHelper.terminate();
                console.log("yo scorm exit here")
            };
        } else {
            quit = function () {
                window.location = "http://www.wisc-online.com";
            };
        }

        // Circular pattern
        showView((function () {
            try {
                var container = new createjs.Container();

                loadingText.x = self.stage.canvas.width / 2;
                loadingText.y = (self.stage.canvas.height / 2);
                loadingText.textAlign = "center";
                loadingText.textBaseline = "middle";

                var loadingShape = new createjs.Shape().set({ x: 120, y: 120 });
                loadingShape.x = self.stage.canvas.width / 2;
                loadingShape.y = loadingText.y;

                loadingShape.graphics.setStrokeStyle(5).beginLinearGradientStroke(["#0000FF", "#CCCCCC"], [1, 0], 60, 0, 0, 90); //"#6666FF",0.5,30, 30,
                loadingShape.graphics.arc(0, 0, 125, 0, Math.PI).command;

                createjs.Tween.get(loadingShape, { loop: true }).to({ rotation: 360 }, 1000 * tweenMultiplier);

                container.addChild(loadingText, loadingShape);
                return container;
            }
            catch (ex) {
                console.log("ERROR FROM showView(loading...) :: " + ex);
            }
        })());

        var resourceLoader = new createjs.LoadQueue(false);

        // setup the resources to be loaded.
        (function () {
            try {
                var assetsPath = gameData.assetsPath || "";
                createjs.Sound.alternateExtensions = ["mp3"];
                resourceLoader.installPlugin(createjs.Sound);

                // THESE ARE GENERAL IMAGE ASSETS
                var assets =
                    [
                        { id: "HaveUHerd", src: assetsPath + "Assets/HaveUHerd.png" },
                        { id: "instructions_background", src: assetsPath + "Assets/instructions_background.png" },
                        { id: "instructions_question", src: assetsPath + "Assets/instructions_question.png" },
                        { id: "musicOn", src: assetsPath + "Assets/musicOn.png" },
                        { id: "musicOff", src: assetsPath + "Assets/musicOff.png" },
                        { id: "pause_button", src: assetsPath + "Assets/pauseSprite.png" },
                        { id: "plain_background", src: assetsPath + "Assets/plain_background.jpg" },
                        { id: "play_button", src: assetsPath + "Assets/play.png" },
                        //{ id: "play_button", src: assetsPath + "Assets/playSprite.png" }, // CHANGE PLAY BUTTON TO THIS
                        { id: "right_answer", src: assetsPath + "Assets/rightAnswer.png" },
                        { id: "start_button", src: assetsPath + "Assets/start_button.png" },
                        { id: "stop_button", src: assetsPath + "Assets/stop_button.png" },
                        { id: "new_stop_button", src: assetsPath + "Assets/stopSprite.png" }, // CHANGE STOP BUTTON TO THIS
                        { id: "title_background", src: assetsPath + "Assets/title_background.jpg" },
                        { id: "wrong_answer", src: assetsPath + "Assets/wrongAnswer.png" },
                    ];
                resourceLoader.loadManifest(assets);

                // HERE ARE THE ORIGINAL SOUND ASSETS
                //var sounds = [
                //    { id: "africanCowbell", src: assetsPath + "20Sounds/africanCowbell.mp3", data: 1 },
                //    { id: "awwww", src: assetsPath + "20Sounds/awwww.mp3", data: 1 },
                //    { id: "bagpipe", src: assetsPath + "20Sounds/bagpipe.mp3", data: 1 },
                //    { id: "bass", src: assetsPath + "20Sounds/bass.mp3", data: 1 },
                //    { id: "bendingTone", src: assetsPath + "20Sounds/bendingTone.mp3", data: 1 },
                //    { id: "bluesHarp", src: assetsPath + "20Sounds/bluesHarp.mp3", data: 1 },
                //    { id: "booBaa", src: assetsPath + "20Sounds/booBaa.mp3", data: 1 },
                //    { id: "bossaShakers", src: assetsPath + "20Sounds/bossaShakers.mp3", data: 1 },
                //    { id: "breath", src: assetsPath + "20Sounds/breath.mp3", data: 1 },
                //    { id: "cardFoot", src: assetsPath + "20Sounds/cardFoot.mp3", data: 1 },
                //    { id: "digeridoo", src: assetsPath + "20Sounds/digeridoo.mp3", data: 1 },
                //    { id: "lead", src: assetsPath + "20Sounds/lead.mp3", data: 1 },
                //    { id: "mandolinMutedDelay", src: assetsPath + "20Sounds/mandolinMutedDelay.mp3", data: 1 },
                //    { id: "mandolinMutedDelay2", src: assetsPath + "20Sounds/mandolinMutedDelay2.mp3", data: 1 },
                //    { id: "maracas", src: assetsPath + "20Sounds/maracas.mp3", data: 1 },
                //    { id: "oy", src: assetsPath + "20Sounds/oy.mp3", data: 1 },
                //    { id: "rhythmFX", src: assetsPath + "20Sounds/rhythmFX.mp3", data: 1 },
                //    { id: "scratch", src: assetsPath + "20Sounds/scratch.mp3", data: 1 },
                //    { id: "tamborineShaker", src: assetsPath + "20Sounds/tamborineShaker.mp3", data: 1 },
                //    { id: "tremoloClav", src: assetsPath + "20Sounds/tremoloClav.mp3", data: 1 },
                //];
                //resourceLoader.loadManifest(sounds);
                //gameState.sounds = sounds;

                // HERE ARE THE JAZZYJAY SOUND ASSETS
                var soundsJazzyJay = [
                    { id: "bassOmatic", src: assetsPath + "JazzyJaySounds/BassOmatic.mp3", data: 1 },
                    { id: "cowString", src: assetsPath + "JazzyJaySounds/CowString.mp3", data: 1 },
                    { id: "drumHead", src: assetsPath + "JazzyJaySounds/Drumhead.mp3", data: 1 },
                    { id: "hammerHead", src: assetsPath + "JazzyJaySounds/HammerHead.mp3", data: 1 },
                    { id: "hatHair", src: assetsPath + "JazzyJaySounds/HatHair.mp3", data: 1 },
                    { id: "hellBass", src: assetsPath + "JazzyJaySounds/HellBass.mp3", data: 1 },
                    { id: "itchy", src: assetsPath + "JazzyJaySounds/Itchy.mp3", data: 1 },
                    { id: "moo", src: assetsPath + "JazzyJaySounds/Moo.mp3", data: 1 },
                    { id: "oxyClean", src: assetsPath + "JazzyJaySounds/OxyClean.mp3", data: 1 }, // UnUsed / Open
                    { id: "pigsInSpace", src: assetsPath + "JazzyJaySounds/PigsInSpace.mp3", data: 1 },
                    { id: "purpleOne", src: assetsPath + "JazzyJaySounds/PurpleOne.mp3", data: 1 },
                    { id: "sadPuppy", src: assetsPath + "JazzyJaySounds/SadPuppy.mp3", data: 1 },
                    { id: "simonSays", src: assetsPath + "JazzyJaySounds/SimonSaysWTF.mp3", data: 1 },
                    { id: "spaceAccordian", src: assetsPath + "JazzyJaySounds/SpaceAccordian.mp3", data: 1 },
                    { id: "spacePiano", src: assetsPath + "JazzyJaySounds/SpacePiano.mp3", data: 1 },
                ];
                resourceLoader.loadManifest(soundsJazzyJay);
                gameState.soundsJazzyJay = soundsJazzyJay;

                // And the Sound Effects
                var soundEffects = [
                    { id: "correctAnswer", src: assetsPath + "SoundEffects/correctAnswer.mp3", data: 1 },
                    { id: "crickets", src: assetsPath + "SoundEffects/crickets.mp3", data: 1 },
                    { id: "energyPulse", src: assetsPath + "SoundEffects/energyPulse.mp3", data: 1 },
                    { id: "roundBegin", src: assetsPath + "SoundEffects/roundBegin.mp3", data: 1 },
                    { id: "teleport", src: assetsPath + "SoundEffects/teleport.mp3", data: 3 },
                    { id: "tubePop", src: assetsPath + "SoundEffects/tubePop.mp3", data: 3 },
                    { id: "tubeShatter", src: assetsPath + "SoundEffects/tubeShatter.mp3", data: 1 },
                    { id: "tubeShimmer", src: assetsPath + "SoundEffects/tubeShimmer.mp3", data: 1 },
                    { id: "tubeSlurp", src: assetsPath + "SoundEffects/tubeSlurp.mp3", data: 3 },
                    { id: "ufoGone", src: assetsPath + "SoundEffects/ufoGone.mp3", data: 1 },
                    { id: "ufoHover", src: assetsPath + "SoundEffects/ufoHover.mp3", data: 1 },
                    { id: "ufoLeaving", src: assetsPath + "SoundEffects/ufoLeaving.mp3", data: 1 },
                    { id: "ufoMoving", src: assetsPath + "SoundEffects/ufoMoving.mp3", data: 1 },
                    { id: "wrongAnswer", src: assetsPath + "SoundEffects/wrongAnswer.mp3", data: 1 },
                ];
                resourceLoader.loadManifest(soundEffects);
                gameState.soundEffects = soundEffects;

                // CUSTOM BACKGROUND AND OTHER IMAGES
                var customAssets = [
                    { id: "add", src: assetsPath + "CustomAssets/add.png" },
                    { id: "fieldLayer", src: assetsPath + "CustomAssets/fieldLayer.png" },
                    { id: "grassShadowLayer", src: assetsPath + "CustomAssets/grassShadowLayer.png" },
                    { id: "hefferShip", src: assetsPath + "CustomAssets/hefferShip.png" },
                    { id: "hillLayer", src: assetsPath + "CustomAssets/hillLayer.png" },
                    { id: "microphoneBG", src: assetsPath + "CustomAssets/microphoneBG.png" },
                    { id: "mountainLayer", src: assetsPath + "CustomAssets/mountainLayer.png" },
                    { id: "play", src: assetsPath + "CustomAssets/play.png" },
                    { id: "spaceShip", src: assetsPath + "CustomAssets/spaceShipSPRITE.png" },
                    { id: "starBackground", src: assetsPath + "CustomAssets/starBackground.jpg" },
                    { id: "tubeBottomLayer", src: assetsPath + "CustomAssets/tubeBottomLayer.png" },
                    { id: "tubeLid", src: assetsPath + "CustomAssets/tubeLid.png" },
                    { id: "tubeTopLayer", src: assetsPath + "CustomAssets/tubeTopLayer.png" },
                    { id: "udderSquirts", src: assetsPath + "CustomAssets/udderSquirtsSPRITE.png" },
                    { id: "volumeKnob", src: assetsPath + "CustomAssets/volumeKnob.png" },
                    { id: "volumeKnobGauge", src: assetsPath + "CustomAssets/volumeKnobGauge.png" },
                ];
                resourceLoader.loadManifest(customAssets);

                // CREATURE IMAGE
                var creatures = [
                    { id: "accordiCow", src: assetsPath + "Creatures/accordianSPRITE.png", soundid: ["digeridoo", "spaceAccordian"] },
                    { id: "bass", src: assetsPath + "Creatures/bassCowSPRITE.png", soundid: ["bass", "purpleOne"] },
                    { id: "bouncyCow", src: assetsPath + "Creatures/bouncyCowDrum.png", soundid: ["cardFoot", "drumHead"] },
                    { id: "cymbolCow", src: assetsPath + "Creatures/cymbolCowSPRITE.png", soundid: ["tamborineShaker", "hellBass"] },
                    { id: "flyingMonster", src: assetsPath + "Creatures/flyingMonsterSPRITE.png", soundid: ["booBaa", "sadPuppy"] },
                    { id: "hammerHead", src: assetsPath + "Creatures/hammerHeadSPRITE.png", soundid: ["africanCowbell", "hammerHead"] },
                    { id: "mouthMonster", src: assetsPath + "Creatures/mouthMonsterSPRITE.png", soundid: ["breath", "moo"] },
                    { id: "pianoTeeth", src: assetsPath + "Creatures/pianoTeethSPRITE.png", soundid: ["oy", "spacePiano"] },
                    { id: "pingPongCow", src: assetsPath + "Creatures/pingPongCowSPRITE.png", soundid: ["maracas", "hatHair"] },
                    { id: "simon", src: assetsPath + "Creatures/simonSPRITE.png", soundid: ["lead", "simonSays"] },
                    { id: "slide", src: assetsPath + "Creatures/slideSPRITE.png", soundid: ["bendingTone", "pigsInSpace"] },
                    { id: "spineMan", src: assetsPath + "Creatures/spineManSPRITE.png", soundid: ["tremoloClav", "cowString"] },
                    { id: "tenticles", src: assetsPath + "Creatures/tenticleSPRITE.png", soundid: ["rhythmFX", "bassOmatic"] },
                    { id: "turntableCow", src: assetsPath + "Creatures/turntableCowSPRITE.png", soundid: ["scratch", "itchy"] },
                ];
                resourceLoader.loadManifest(creatures);
                gameState.creatures = creatures;

                resourceLoader.addEventListener("fileload", function (event) {
                    try {
                        //console.log("resourceLoader.loaded" + resourceLoader.loaded);
                        //console.log("resourceLoader.total" + resourceLoader.total);
                        //console.log("resourceLoader.progress" + resourceLoader.progress);

                        if (resourceLoader.progress > 0.5) {
                            loadingText.text = "LOADING ASSETS\n" + Math.floor(resourceLoader.progress * 100) + "% COMPLETE...";
                            loadingText.text += "\n\n Your game will begin \nshortly...";
                            loadingText.y = (self.stage.canvas.height / 2) - 35;
                        }
                        else {
                            loadingText.text = "LOADING ASSETS\n\n" + Math.floor(resourceLoader.progress * 100) + "% COMPLETE...";
                            loadingText.y = (self.stage.canvas.height / 2) - 20;
                        }
                    }
                    catch (ex) {
                        console.log("ERROR FROM resourceLoader.complete :: " + ex);
                    }
                });
                resourceLoader.addEventListener("complete", function (event) {
                    try {
                        // Need to Randomize which set of music will be used.
                        selectMusicTracks();

                        showView(getTitleView());
                        //showView(getSoundBoardView());
                    }
                    catch (ex) {
                        console.log("ERROR FROM resourceLoader.complete :: " + ex);
                    }
                });
            }
            catch (ex) {
                console.log("ERROR FROM resourceLoader :: " + ex);
            }
        })();

        createjs.Ticker.setFPS(60);
        createjs.Ticker.on("tick", tickHandler, this);
        //createjs.Ticker.addEventListener("tick", tickHandler);

        function addMember() {
            try {
                //getCreature();

                var _conBandStage = view.getChildByName("conBandStage");
                //var myCreature = _conBandStage.getChildByName("conCreature");

                var myContainedCreature = creatureContainer(getCreature());
                myContainedCreature.x = 300;
                myContainedCreature.y = 500;

                _conBandStage.addChild(myContainedCreature);
            }
            catch (ex) {
                console.log("ERROR FROM addMember :: " + ex);
            }
        }

        function animateBackground(isStartOfRound) {
            try {
                //console.log("HELLO FROM :: animateBackground()");
                var _conBandStage = view.getChildByName("conBandStage");
                var _conBackground = _conBandStage.getChildByName("conBackground");
                var _bgField = _conBackground.getChildByName("bgField");
                var _bgHill = _conBackground.getChildByName("bgHill");


                // if statement
                if (isStartOfRound) {
                    var tweenField = new createjs.Tween.get(_bgField)
                        .to({ y: 700 }, 1500 * tweenMultiplier);
                    var tweenHill = new createjs.Tween.get(_bgHill)
                        .to({ y: 600 }, 2000 * tweenMultiplier);

                    if (gameState.myBand.length > 0) {
                        for (var i = 0; i < gameState.myBand.length; ++i) {
                            var tempCritter = gameState.myBand[i];
                            var tweenCritter = new createjs.Tween.get(tempCritter)
                                .to({ y: (tempCritter.y + 250) }, 1000 * tweenMultiplier);
                        }
                    }
                }
                else {
                    var tweenField = new createjs.Tween.get(_bgField)
                        .to({ y: 450 }, 2000 * tweenMultiplier);
                    var tweenHill = new createjs.Tween.get(_bgHill)
                        .to({ y: 450 }, 1500 * tweenMultiplier);

                    if (gameState.myBand.length > 0) {
                        for (var i = 0; i < gameState.myBand.length; ++i) {
                            var tempCritter = gameState.myBand[i];
                            var tweenCritter = new createjs.Tween.get(tempCritter)
                                .to({ y: (tempCritter.y - 250) }, 1500 * tweenMultiplier);
                        }
                    }
                }

            } catch (ex) {
                console.log("ERROR FROM animateBackground() :: " + ex);
            }
        }

        function animateCreature(_tempCreature) {
            try {
                //if (_tempCreature.soundInstance.getMute()) { return; };
                var selectedTracks = gameState.gameTracks[gameState.selectedTracks];

                switch (_tempCreature.name) // ADD CASE FOR EACH CHARACTER
                {
                    case "accordiCow":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First progression *****
                                        .call(_tempCreature.gotoAndPlay, ["halfUpDownHalf"], _tempCreature).wait(800)
                                        .call(_tempCreature.gotoAndPlay, ["halfUpDownUpHalf"], _tempCreature).wait(1100)
                                        .call(_tempCreature.gotoAndPlay, ["halfDownUpDownHalf"], _tempCreature).wait(1100)
                                        .call(_tempCreature.gotoAndPlay, ["halfUpDownUpHalf"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["leftRight"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["rightleft"], _tempCreature).wait(50)
                                        // ***** Second progression *****
                                        .call(_tempCreature.gotoAndPlay, ["halfUpDownHalf"], _tempCreature).wait(800)
                                        .call(_tempCreature.gotoAndPlay, ["halfUpDownUpHalf"], _tempCreature).wait(1100)
                                        .call(_tempCreature.gotoAndPlay, ["halfDownUpDownHalf"], _tempCreature).wait(1200)
                                        .call(_tempCreature.gotoAndPlay, ["leftRight"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["rightleft"], _tempCreature).wait(200)
                                        .call(_tempCreature.gotoAndPlay, ["leftRight"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["rightleft"], _tempCreature).wait(800);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First progression *****
                                        .call(_tempCreature.gotoAndPlay, ["idleDown"], _tempCreature).wait(1000)
                                        //.call(_tempCreature.gotoAndPlay, ["up"], _tempCreature).wait(2500)
                                        .call(_tempCreature.gotoAndPlay, ["upSlow"], _tempCreature).wait(2500)
                                        .call(_tempCreature.gotoAndPlay, ["upEnding"], _tempCreature).wait(2700)
                                        //.call(_tempCreature.gotoAndPlay, ["down"], _tempCreature).wait(2500)
                                        .call(_tempCreature.gotoAndPlay, ["downSlow"], _tempCreature).wait(2500)
                                        .call(_tempCreature.gotoAndPlay, ["downEnding"], _tempCreature).wait(2000);
                                    break;
                            }
                            break;
                        }
                    case "bass":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First Riff *****
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(100)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(800)
                                        // ***** Second Riff *****
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(900)
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(1100)
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(800)
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(600);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First Riff *****
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(300)
                                        // ***** Second Riff *****
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["lowMid"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["blink"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["highMid"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(600);
                                    break;
                            }
                            break;
                        }
                    case "bouncyCow":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["fullMotionReverse"], _tempCreature).wait(650);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["leftToRight"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["rightToLeft"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["shortHop"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["fullMotionForward"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["leftToRight"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["rightToLeft"], _tempCreature).wait(700)
                                        .call(_tempCreature.gotoAndPlay, ["dance"], _tempCreature).wait(800);
                                    break;
                            }
                            break;
                        }
                    case "cymbolCow":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["shake"], _tempCreature).wait(650)
                                        .call(_tempCreature.gotoAndPlay, ["clap"], _tempCreature).wait(650)
                                        .call(_tempCreature.gotoAndPlay, ["shake"], _tempCreature).wait(650)
                                        .call(_tempCreature.gotoAndPlay, ["clap"], _tempCreature).wait(700);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["clap"], _tempCreature).wait(900)
                                        .call(_tempCreature.gotoAndPlay, ["extendedClap"], _tempCreature).wait(1800);
                                    break;
                            }
                            break;
                        }
                    case "flyingMonster":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(650)
                                        .call(_tempCreature.gotoAndPlay, ["baa"], _tempCreature).wait(650)
                                        .call(_tempCreature.gotoAndPlay, ["baa"], _tempCreature).wait(650)
                                        .call(_tempCreature.gotoAndPlay, ["baa"], _tempCreature).wait(700);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First progression *****
                                        .wait(300).call(_tempCreature.gotoAndPlay, ["wow"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlapDouble"], _tempCreature).wait(800)
                                        .call(_tempCreature.gotoAndPlay, ["yip"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlapDouble"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["baa"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["yip"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(450)
                                        .call(_tempCreature.gotoAndPlay, ["yip"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(450)

                                        // ***** Second progression *****
                                        .call(_tempCreature.gotoAndPlay, ["wow"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlapDouble"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["yip"], _tempCreature).wait(700)
                                        .call(_tempCreature.gotoAndPlay, ["yip"], _tempCreature).wait(700)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["baa"], _tempCreature).wait(450)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(450)
                                        .call(_tempCreature.gotoAndPlay, ["yip"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(450)
                                        .call(_tempCreature.gotoAndPlay, ["yip"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["wingFlap"], _tempCreature).wait(450);
                                    break;
                            }
                            break;
                        }
                    case "hammerHead":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First progression *****
                                        .wait(75).call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(200)
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature)
                                        .wait(400).call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(400)

                                        // ***** Second progression *****
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(500);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First progression *****
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(300)
                                        .wait(150).call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(150)

                                        // ***** Second progression *****
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["double"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(300)
                                        .wait(150).call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(150);
                                    break;
                            }
                            break;
                        }
                    case "mouthMonster":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First progression *****                                   
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["footTap"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(750)
                                        .call(_tempCreature.gotoAndPlay, ["headBob"], _tempCreature).wait(750)

                                        // ***** Second progression *****
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["footTap"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["smallMouth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["bigMouth"], _tempCreature).wait(750)
                                        .call(_tempCreature.gotoAndPlay, ["headBob"], _tempCreature).wait(750);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["holdOut"], _tempCreature).wait(2000)
                                        .call(_tempCreature.gotoAndPlay, ["closedMouth"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["footTap"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["holdOut"], _tempCreature).wait(2000)
                                        .call(_tempCreature.gotoAndPlay, ["closedMouth"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["footTap"], _tempCreature).wait(400)
                                        .call(_tempCreature.gotoAndPlay, ["holdOut"], _tempCreature).wait(2000)
                                        .call(_tempCreature.gotoAndPlay, ["closedMouth"], _tempCreature).wait(350)
                                        .call(_tempCreature.gotoAndPlay, ["footTap"], _tempCreature).wait(350)
                                        .call(_tempCreature.gotoAndPlay, ["holdOut"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["closedMouth"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["footTap"], _tempCreature).wait(800);
                                    break;
                            }
                            break;
                        }
                    case "pianoTeeth":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["buckTooth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["eyeRoll"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["eyeRoll"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["eyeRoll"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["eyeRoll"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["eyeRoll"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["eyeRoll"], _tempCreature).wait(150);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["buckTooth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(200)
                                        .call(_tempCreature.gotoAndPlay, ["buckTooth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(200)
                                        .call(_tempCreature.gotoAndPlay, ["buckTooth"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["high"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["low"], _tempCreature).wait(150);
                                    break;
                            }
                            break;
                        }
                    case "pingPongCow":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["third"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["fourth"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["third"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["fourth"], _tempCreature).wait(250);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        // ***** First progression *****
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["third"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["fourth"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["third"], _tempCreature).wait(250)

                                        // ***** Second progression *****
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["third"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["fourth"], _tempCreature).wait(250);
                                    break;
                            }
                            break;
                        }
                    case "simon":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["blue"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["red"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["green"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["yellow"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["green"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["blue"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["green"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["yellowHold"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["red"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["greenHold"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(725)
                                        .call(_tempCreature.gotoAndPlay, ["blue"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["red"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["green"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["red"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["yellow"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["blue"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["green"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["blueHold"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["red"], _tempCreature).wait(325)
                                        .call(_tempCreature.gotoAndPlay, ["yellowHold"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["hop"], _tempCreature).wait(425);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["jazzyJay"], _tempCreature).wait(3000);
                                    break;
                            }

                            break;
                        }
                    case "slide":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["idle"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["upFullDown"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["up"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["upFullDown"], _tempCreature).wait(3500);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["idle"], _tempCreature).wait(250)
                                        .call(_tempCreature.gotoAndPlay, ["downHalfDownUp"], _tempCreature).wait(700)
                                        .call(_tempCreature.gotoAndPlay, ["wavy"], _tempCreature).wait(500)
                                        .call(_tempCreature.gotoAndPlay, ["down"], _tempCreature).wait(3850);
                                    break;
                            }

                            break;
                        }
                    case "spineMan":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .wait(750)
                                        .call(_tempCreature.gotoAndPlay, ["extend"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["blinkEar"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["dualBend"], _tempCreature).wait(900)
                                        .call(_tempCreature.gotoAndPlay, ["blinkEar"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["extend"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["blinkEar"], _tempCreature).wait(2000)
                                        .call(_tempCreature.gotoAndPlay, ["dualBend"], _tempCreature).wait(1500);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["leftBend"], _tempCreature).wait(100)
                                        .call(_tempCreature.gotoAndPlay, ["extendAndRelease"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["dualBend"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["dualBend"], _tempCreature).wait(1200)
                                        .call(_tempCreature.gotoAndPlay, ["extendAndRelease"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["extendAndRelease"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["dualBend"], _tempCreature).wait(1500)
                                        .call(_tempCreature.gotoAndPlay, ["dualBend"], _tempCreature).wait(1200)
                                        .call(_tempCreature.gotoAndPlay, ["extendAndRelease"], _tempCreature).wait(1750);
                                    break;
                            }

                            break;
                        }
                    case "tenticles":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .wait(900)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(1200)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(1300)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(800);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        //.wait(100)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(550)
                                        .call(_tempCreature.gotoAndPlay, ["left"], _tempCreature).wait(550)
                                        .call(_tempCreature.gotoAndPlay, ["right"], _tempCreature).wait(600)
                                        .call(_tempCreature.gotoAndPlay, ["quickTriple"], _tempCreature).wait(1000);
                                    break;
                            }

                            break;
                        }
                    case "turntableCow":
                        {
                            switch (selectedTracks) {
                                case "original":
                                    //console.log("Animate original :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["rightScratch"], _tempCreature).wait(950)
                                        .call(_tempCreature.gotoAndPlay, ["leftScratch"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(600);
                                    break;
                                case "jazzyJay":
                                    //console.log("Animate jazzyJay :: ");
                                    _tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                                        .call(_tempCreature.gotoAndPlay, ["rightScratch"], _tempCreature).wait(1200)
                                        .call(_tempCreature.gotoAndPlay, ["leftScratch"], _tempCreature).wait(1000)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(300)
                                        .call(_tempCreature.gotoAndPlay, ["spinning"], _tempCreature).wait(200);
                                    break;
                            }
                            break;
                        }
                }
            } catch (ex) {
                console.log("ERROR FROM animateCreature :: " + ex);
            }
        }

        function animateSelection(_conBandStage) {
            try {
                //console.log("HELLO FROM :: animateCannons()");
                var imageUFO = _conBandStage.getChildByName("imageUFO");

                //gameState.arrSelection
                for (var i = 0; i < gameState.arrSelection.length; i++) {
                    var tempSelection = gameState.arrSelection[i];

                    if (gameState.arrSelection.length == 2) {
                        // only do the Left and right utter
                        if (i == 1) { ++i; }
                    }
                    else if (gameState.arrSelection.length == 1) {
                        // Only do the central utter
                        if (i == 0) { ++i; }
                    }

                    // End Coords, still need to set the starting coords
                    tempSelection.endX = 200 + (i * 200);
                    tempSelection.endY = 375;

                    switch (i) {
                        case 0: // leftUdder
                            //console.log("HELLO FROM :: " + tempSelection.name);
                            tempSelection.x = 325;
                            tempSelection.y = 225;
                            tempSelection.scaleX = 0.0;
                            tempSelection.scaleY = 0.0;

                            if (!soundEffect.getMute()) {
                                soundEffect = createjs.Sound.play("tubeSlurp", { loop: 0, volume: 0.75 });
                                arrSoundEffects.push(soundEffect);
                            }

                            var spriteLeft = imageUFO.getChildByName("leftUdder");

                            var tweenLeft = new createjs.Tween.get(tempSelection)
                                .call(function () {
                                    var tweenRightUdder = new createjs.Tween.get(spriteLeft)
                                        .call(spriteLeft.gotoAndPlay, ["leftfire"], spriteLeft)
                                        .wait(500)
                                        .call(function () { if (!soundEffect.getMute()) { soundEffect = createjs.Sound.play("tubePop", { loop: 0, volume: 0.75 }); } })
                                })
                                .wait(500)
                                .to({ x: tempSelection.endX, y: tempSelection.endY, scaleX: 0.5, scaleY: 0.5 }, 2000 * tweenMultiplier);

                            break;
                        case 1: // centerUdder
                            //console.log("HELLO FROM :: " + tempSelection.name);
                            tempSelection.x = 400;
                            tempSelection.y = 250;
                            tempSelection.scaleX = 0.0;
                            tempSelection.scaleY = 0.0;

                            if (!soundEffect.getMute()) {
                                soundEffect = createjs.Sound.play("tubeSlurp", { loop: 0, volume: 0.75 });
                                arrSoundEffects.push(soundEffect);
                            }

                            var spriteCenter = imageUFO.getChildByName("centerUdder");

                            var tweenCenter = new createjs.Tween.get(tempSelection)
                                .call(function () {
                                    var tweenCenterUdder = new createjs.Tween.get(spriteCenter)
                                        .call(spriteCenter.gotoAndPlay, ["centerfire"], spriteCenter)
                                        .wait(500)
                                        .call(function () { createjs.Sound.createInstance("tubePop", { loop: 0, volume: 0.75 }) })
                                })
                                .wait(500)
                                .to({ x: tempSelection.endX, y: tempSelection.endY, scaleX: 0.5, scaleY: 0.5 }, 2000 * tweenMultiplier);

                            break;
                        case 2: // rightUdder
                            //console.log("HELLO FROM :: " + tempSelection.name);
                            tempSelection.x = 475;
                            tempSelection.y = 225;
                            tempSelection.scaleX = 0.0;
                            tempSelection.scaleY = 0.0;

                            if (!soundEffect.getMute()) {
                                soundEffect = createjs.Sound.play("tubeSlurp", { loop: 0, volume: 0.75 });
                                arrSoundEffects.push(soundEffect);
                            }

                            var spriteRight = imageUFO.getChildByName("rightUdder");

                            var tweenLeft = new createjs.Tween.get(tempSelection)
                                .call(function () {
                                    var tweenRight = new createjs.Tween.get(spriteRight)
                                        .call(spriteRight.gotoAndPlay, ["rightfire"], spriteRight)
                                        .wait(500)
                                        .call(function () { createjs.Sound.createInstance("tubePop", { loop: 0, volume: 0.75 }) })
                                })
                                .wait(500)
                                .to({ x: tempSelection.endX, y: tempSelection.endY, scaleX: 0.5, scaleY: 0.5 }, 2000 * tweenMultiplier);

                            break;
                    }

                    // BE SURE TO ADD TO STAGE AT END
                    _conBandStage.addChild(tempSelection);
                }
            } catch (ex) {
                console.log("ERROR FROM animateCannons() :: " + ex);
            }
        }

        function checkAnswer() {
            try {
                //console.log("HELLO from checkAnswer()");
                var tempContainer = view.getChildByName("conBandStage");
                var tempWindow = tempContainer.getChildByName("windowQuestions");

                if (gameState.currentAnswer.IsCorrect) {
                    var tempImage = tempWindow.getChildByName("imageResult");
                    tempImage.image = resourceLoader.getResult("right_answer");
                    //var tempFeedback = tempWindow.getChildByName("conFeedback");
                    //tempFeedback.visible = true;
                    tempWindow.name = "windowCorrect";
                    showCorrectAnswer();

                    if (!soundEffect.getMute()) {
                        soundEffect = createjs.Sound.play("correctAnswer", { loop: 0, volume: 0.75 });
                        arrSoundEffects.push(soundEffect);
                    }
                }
                else {
                    var tempImage = tempWindow.getChildByName("imageResult");
                    tempImage.image = resourceLoader.getResult("wrong_answer");
                    //var tempFeedback = tempWindow.getChildByName("conFeedback");
                    //tempFeedback.visible = true;
                    tempWindow.name = "windowWrong";
                    showCorrectAnswer();

                    if (!soundEffect.getMute()) {
                        soundEffect = createjs.Sound.play("wrongAnswer", { loop: 0, volume: 0.75 });
                        arrSoundEffects.push(soundEffect);
                    }
                }
            }
            catch (ex) {
                console.log("ERROR FROM checkAnswer() :: " + ex);
            }
        }

        function clearScreen() {
            try {
                if (document.getElementById('masterVolumeSlider')) {
                    domElement = new createjs.DOMElement(document.getElementById('masterVolumeSlider'));
                    domElement.htmlElement.parentNode.removeChild(domElement.htmlElement);
                }

                // RESET SCREENS
                instructionsView = null;
                windowQuestion = null;
                selectInstrumentView = null;
                soundBoardView = null;
                titleView = null;
            }
            catch (ex) {
                console.log("ERROR FROM clearScreen() :: " + ex);
            }
        }

        function createBandView() {
            try {
                view = new createjs.Container();
                view.name = "viewBand";

                if (!soundEffect.getMute()) {
                    soundEffect = createjs.Sound.play("crickets", { loop: -1, volume: 0.08 });
                    soundEffect.name = "crickets";
                    arrSoundEffects.push(soundEffect);
                }
                masterSound.setVolume(1.0);

                var conBandStage = new createjs.Container();
                conBandStage.name = "conBandStage";
                conBandStage.x = 0;
                conBandStage.y = -300;

                var conBackground = new createjs.Container();
                conBackground.name = "conBackground";
                conBackground.x = 0;
                conBackground.y = 0;

                var bgMountain = new createjs.Bitmap(resourceLoader.getResult("mountainLayer"));
                bgMountain.name = "bgMountain";
                bgMountain.regX = bgMountain.getBounds().width / 2;
                //conBandStageMountain.regY = conBandStageMountain.getBounds().height;
                bgMountain.x = bgMountain.getBounds().width / 2;
                bgMountain.y = 0;

                var bgHill = new createjs.Bitmap(resourceLoader.getResult("hillLayer"));
                bgHill.name = "bgHill";
                bgHill.regX = bgHill.getBounds().width / 2;
                //conBandStageMountain.regY = conBandStageMountain.getBounds().height;
                bgHill.x = bgHill.getBounds().width / 2;
                bgHill.y = 450;

                var bgField = new createjs.Bitmap(resourceLoader.getResult("fieldLayer"));
                bgField.name = "bgField";
                bgField.regX = bgField.getBounds().width / 2;
                //conBandStageMountain.regY = conBandStageMountain.getBounds().height;
                bgField.x = bgField.getBounds().width / 2;
                bgField.y = 450;
                bandFieldStage = bgField;

                var bgGrass = new createjs.Bitmap(resourceLoader.getResult("grassShadowLayer"));
                bgGrass.name = "bgGrass";
                bgGrass.regX = bgGrass.getBounds().width / 2;
                //conBandStageMountain.regY = conBandStageMountain.getBounds().height;
                bgGrass.x = bgGrass.getBounds().width / 2;
                bgGrass.y = 600;

                bgGrass.addEventListener("tick", function (e) {
                    var bgSkewX = new createjs.Tween.get(bgGrass, { loop: true })
                        .to({ skewX: 5 }, 1500 * tweenMultiplier)
                        .to({ skewX: -5 }, 3000 * tweenMultiplier)
                        .to({ skewX: 0 }, 1500 * tweenMultiplier);
                });

                var bgStar = new createjs.Bitmap(resourceLoader.getResult("starBackground"));
                bgStar.regX = (bgStar.getBounds().width / 2);
                bgStar.regY = (bgStar.getBounds().height / 2);
                bgStar.x = (originalWidth / 2);
                bgStar.y = (originalHeight / 2);

                bgStar.addEventListener("tick", function (e) {
                    var bgRotate = new createjs.Tween.get(bgStar, { loop: true })
                        .to({ rotation: 0 }, 0, createjs.Ease.linear)
                        .to({ rotation: 360 }, 3600000, createjs.Ease.linear);
                });

                conBackground.addChild(bgStar, bgMountain, bgHill, bgField);
                conBandStage.addChild(conBackground, bgGrass);

                var btnInstructions = helpers.instructions(); // THIS MAY NEED TO BE CHANGED
                var btnSoundEffects = helpers.soundEffects();

                var conControls = helpers.masterControlsBandView();
                conControls.name = "conControls";
                conControls.x = 0;
                conControls.y = 500;

                highlightButton(conControls);
                // USE THIS WHEN ADDING A NEW CREATURE TO THE GAME.
                // THIS FUNCTION HAS THE TEMPLATE READY FOR TESTING
                //newSpriteTesting();

                view.addChild(conBandStage, conControls, btnInstructions, btnSoundEffects);
                return view;
            }
            catch (ex) {
                console.log("ERROR FROM createBandView() :: " + ex);
            }
        }

        function createInstructionsView() {
            try {
                view = new createjs.Container();
                view.name = "viewInstructions";

                var image = new createjs.Bitmap(resourceLoader.getResult("HaveUHerd"));

                var hit = new createjs.Shape();
                var exitContainer = new createjs.Container();
                var exitBox = new createjs.Shape();

                exitContainer.x = 720;
                exitContainer.y = 570;

                var exitText = new createjs.Text("BACK", 'bold 18px Arial', "#fff");
                exitText.x = 8;
                exitText.y = 8;

                exitContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#911F94").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke());
                hit.graphics.beginFill("#000").drawRect(0, 0, exitText.getMeasuredWidth(), exitText.getMeasuredHeight());

                exitBox.graphics.beginFill("#911F94").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke();
                exitText.hitArea = hit;
                exitContainer.addChild(exitBox, exitText);

                view.addChild(image, exitContainer);

                exitContainer.addEventListener("click", function (event) {
                    try {
                        showView(getBandView());
                    }
                    catch (ex) {
                        console.log("ERROR FROM createInstructionsView.exitContainer() :: " + ex);
                    }
                });

                return view;
            }
            catch (ex) {
                console.log("ERROR FROM createInstructionsView() :: " + ex);
            }
        }

        function createClipCell(_sound, _column) {
            try {
                var conCell = new createjs.Container();
                conCell.name = _sound.id;

                if (_column == 0) {
                    conCell.x = 0;
                    conCell.y = 0;
                }
                else {
                    conCell.x = 350;
                    conCell.y = -15;
                }

                var bgSoundTest = new createjs.Shape();
                bgSoundTest.graphics.setStrokeStyle(5).beginFill("").beginStroke("#3A4B9C").drawRoundRect(30, 20, 300, 30, 0).endStroke().endFill;
                conCell.addChild(bgSoundTest);

                var _soundID = _sound.id;
                var myInstance = gameState.audioClips[_soundID];

                // CREATE NAME SPACE
                var txtClipName = new createjs.Text("", "10pt Arial Black", "#435CCE");
                txtClipName.x = 50;
                txtClipName.y = 25;
                txtClipName.text = _sound.id;

                // CREATE PLAY BUTTON
                var btnPlay = new createjs.Bitmap(resourceLoader.getResult("start_button"));
                btnPlay.name = "btnPlay";
                btnPlay.shadow = new createjs.Shadow("gray", 3, 3, 3);
                btnPlay.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                btnPlay.cursor = 'pointer';
                btnPlay.regX = 10;
                btnPlay.regY = 10;
                btnPlay.x = 215;
                btnPlay.y = 25;
                btnPlay.scaleX = 0.25;
                btnPlay.scaleY = 0.25;

                btnPlay.addEventListener("click", function (event) {
                    try {
                        //console.log("btnPlay click :: _sound.id " + _sound.id);
                        //console.log("playState BEFORE IF :: " + myInstance.playState);

                        if (myInstance.playState == "playFinished" || !myInstance.playState) {
                            myInstance.play({ loop: -1 });
                            btnPlay.image = resourceLoader.getResult("stop_button");
                        }
                        else {
                            myInstance.stop();
                            btnPlay.image = resourceLoader.getResult("start_button");
                        }
                        //console.log("playState AFTER IF :: " + myInstance.playState);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createClipCell.btnPlay.click() :: " + ex);
                    }
                });
                btnPlay.addEventListener("mouseover", function (event) {
                    try {
                        createjs.Tween.get(event.currentTarget)
                            .to({ scaleX: 0.35, scaleY: 0.35 }, 100);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createClipCell.btnPlay.mouseover() :: " + ex);
                    }
                });
                btnPlay.addEventListener("mouseout", function (event) {
                    try {
                        createjs.Tween.get(event.currentTarget)
                            .to({ scaleX: 0.25, scaleY: 0.25 }, 100);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createClipCell.btnPlay.mouseout() :: " + ex);
                    }
                });

                // CREATE THE MUTE BUTTON
                var btnMute = new createjs.Bitmap(resourceLoader.getResult("musicOn"));
                btnMute.name = "btnMute";
                btnMute.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                btnMute.cursor = 'pointer';
                btnMute.regX = 10;
                btnMute.regY = 10;
                btnMute.x = 250;
                btnMute.y = 30;
                btnMute.scaleX = 0.25;
                btnMute.scaleY = 0.25;

                btnMute.addEventListener("click", function (event) {
                    try {
                        //console.log("btnMute click :: isMuted " + resourceLoader.getResult("musicOn"));   
                        var string = _sound.id;
                        var myInstance = gameState.audioClips[string];
                        var isMuted = myInstance.getMute();

                        if (isMuted) {
                            btnMute.image = resourceLoader.getResult("musicOn");
                            myInstance.setMute(false);
                        }
                        else {
                            btnMute.image = resourceLoader.getResult("musicOff");
                            myInstance.setMute(true);
                        }
                    }
                    catch (ex) {
                        console.log("ERROR FROM createClipCell.btnMute.click() :: " + ex);
                    }
                });
                btnMute.addEventListener("mouseover", function (event) {
                    try {
                        createjs.Tween.get(event.currentTarget)
                            .to({ scaleX: 0.35, scaleY: 0.35 }, 100);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createClipCell.btnMute.mouseover() :: " + ex);
                    }
                });
                btnMute.addEventListener("mouseout", function (event) {
                    try {
                        createjs.Tween.get(event.currentTarget)
                            .to({ scaleX: 0.25, scaleY: 0.25 }, 100);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createClipCell.btnMute.mouseout() :: " + ex);
                    }
                });

                var sldVolume = document.createElement("input");
                sldVolume.name = "masterVolumeSlider";
                sldVolume.id = "masterVolumeSlider";
                sldVolume.setAttribute("type", "range");
                sldVolume.value = 50;
                sldVolume.min = 1;
                sldVolume.max = 100;
                sldVolume.step = 1;
                //sldVolume.style.font = "16pt Georgia";
                self.stage.canvas.parentElement.insertBefore(sldVolume, canvas);

                var sldVolumeInputControl = new createjs.DOMElement(sldVolume);
                sldVolumeInputControl.name = "masterVolumeSliderControl";
                sldVolumeInputControl.x = 270;
                sldVolumeInputControl.y = 25;
                sldVolumeInputControl.width = 20;
                sldVolumeInputControl.height = 16;
                sldVolumeInputControl.scaleX = 0.4;

                //sldVolumeInputControl.setBounds(sldVolumeInputControl.x, sldVolumeInputControl.y, sldVolumeInputControl.width, sldVolumeInputControl.height);

                sldVolume.addEventListener("change", function () {
                    try {
                        myInstance.setVolume(sldVolume.value / 100);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createClipCell.sldVolume.change() :: " + ex);
                    }
                });

                conCell.addChild(txtClipName, btnPlay, btnMute, sldVolumeInputControl);
                return conCell;
            }
            catch (ex) {
                console.log("ERROR FROM createClipCell() :: " + ex);
            }
        }

        function createLightBeam() {
            try {
                var lightBeam = new createjs.Container()
                lightBeam.regX = 50;
                lightBeam.regY = 0;
                //lightBeam.alpha = 0.5;
                var tempFilter = colorFilters.filterWhite;

                var beamLength = new createjs.Shape();
                beamLength.graphics.beginFill("#FFFFFF")//.beginStroke("#FFFFFF")
                    .moveTo(50, 0).lineTo(100, 200).lineTo(0, 200).lineTo(50, 0).endFill();
                beamLength.alpha = 0.5;
                beamLength.filters = [tempFilter];

                var beamFocus = new createjs.Shape();
                beamFocus.graphics.beginFill("#FFFFFF").drawEllipse(0, 175, 100, 50);
                beamFocus.filters = [tempFilter];

                lightBeam.cache(0, 0, 300, 300);
                lightBeam.addChild(beamLength, beamFocus);//
                return lightBeam;
            }
            catch (ex) { console.log("ERROR FROM createLightBeam() :: " + ex); }
        }

        function createQuestionWindow() {
            try {
                var window = new createjs.Container();
                window.name = "windowQuestions";
                
                var questionIndex = 0;
                do {
                    // GET QUESTION THAT HASN'T BEEN USED
                    var isUsed = false;
                    //randomIndex = Math.floor(Math.random() * gameState.questions.length);
                    gameState.currentQuestion = gameState.questions[questionIndex];
                    

                    for (var i = 0; i < gameState.usedQuestions.length; i++) {
                        var tempQuestionUsed = gameState.usedQuestions[i];
                        if (gameState.currentQuestion.Id == tempQuestionUsed.Id) {
                            isUsed = true;
                        }
                    }
                    questionIndex++

                    if (!isUsed) {
                        var imageResult = new createjs.Bitmap();
                        imageResult.name = "imageResult";
                        imageResult.x = 610;
                        imageResult.y = 30;
                        imageResult.scaleX = 0.45;
                        imageResult.scaleY = 0.45;

                        // Display Instruction at top
                        var titleHeading = helpers.pageHeading(gameState.currentQuestion.Text);
                        titleHeading.x = 10;
                        titleHeading.y = 10;

                        var conAnswers = new createjs.Container()
                        conAnswers.name = "conAnswers";
                        conAnswers.x = 0;
                        conAnswers.y = 150;

                        // For Loop to display Answer Choices
                        
                        var _answers = gameState.currentQuestion.Answers;

                        for (var i = 0; i < _answers.length; ++i) {
                            var txtAnswer = helpers.answer(_answers[i]);
                            txtAnswer.name = "Answer_" + i;
                            txtAnswer.x = 50;
                            txtAnswer.y = ((85 * i) + 10);

                            conAnswers.addChild(txtAnswer);
                        }

                        // Display Feed back area, but hide until Next is clicked
                        var conFeedback = helpers.feedback(gameState.currentQuestion.Feedback);
                        conFeedback.name = "conFeedback";
                        conFeedback.x = 10;
                        conFeedback.y = 510;
                        //conFeedback.alpha = 0;
                        conFeedback.visible = false;

                        // Display Next Button
                        var btnNext = helpers.nextButton("NEXT -->");
                        btnNext.name = "btnNext";
                        btnNext.x = 525;
                        btnNext.y = 525;

                        //Question Timer Variables
                        gameState.isTimerRunning = true;
                        gameState.startTime = (new Date()).getTime();

                        var conQuestionBG = new createjs.Shape()
                        conQuestionBG.graphics.setStrokeStyle(5).beginStroke("#000066")
                            .beginRadialGradientFill(
                            ["#000000", "#00001F", "#000033"],
                            [0.1, 0.8, 0.95],
                            350, 300, 200,
                            350, 300, 350,
                            350, 300, 500
                            )
                            .drawRoundRect(0, 0, originalWidth - 100, 600, 5).endStroke().endFill();

                        window.addChild(conQuestionBG, titleHeading, conAnswers, conFeedback, btnNext, imageResult);//,image, conSelection, conCurrentSelection, 
                        return window;
                    }
                } while (isUsed)
            }
            catch (ex) {
                console.log("ERROR FROM createQuestionWindow() :: " + ex);
            }
        }

        function createSoundBoard() {
            try {
                view = new createjs.Container();
                view.name = "viewSoundBoard";

                var conSoundBoard = new createjs.Container();
                conSoundBoard.name = "conSoundBoard";
                conSoundBoard.x = 50;
                conSoundBoard.y = 50;
                var bgSoundTest = new createjs.Shape();
                bgSoundTest.graphics.setStrokeStyle(5).beginFill("#232A4C").beginStroke("3A4B9C").drawRoundRect(0, 0, 700, 500, -25).endStroke().endFill;

                conSoundBoard.addChild(bgSoundTest); // bgSoundTest

                var conControl = new createjs.Container();
                conControl.name = "conControl";
                conControl.x = 25;
                conControl.y = 50;

                for (var i = 0; i < gameState.sounds.length; ++i) {
                    var _Sound = gameState.sounds[i]; // GRAB CURRENT SOUND CLIP

                    // CREATE ROW CONTAINER
                    var conRow = new createjs.Container();
                    conRow.name = _Sound.id;
                    conRow.x = 15;
                    conRow.y = (i * 30) / 2;

                    if (i % 2) {
                        //console.log("ODD :: if (i % 2) :: " + (i % 2));
                        conRow.addChild(createClipCell(_Sound, (i % 2)));
                    }
                    else {
                        //console.log("EVEN :: else (i % 2) :: " + (i % 2));
                        conRow.addChild(createClipCell(_Sound, (i % 2)));
                    }
                    conControl.addChild(conRow);
                }

                var masterControls = helpers.masterControlsSoundBoard();

                view.addChild(conSoundBoard, conControl, masterControls);
                return view;
            }
            catch (ex) {
                console.log("ERROR FROM showSoundBoard() :: " + ex);
            }
        }

        function createTitleView() {
            try {
                view = new createjs.Container();
                view.name = "viewTitle";

                var titleText = new createjs.Text(gameData.Title, "36px Arial Black", "#7649AE");
                titleText.shadow = new createjs.Shadow("gray", 1, 1, 3);
                titleText.lineWidth = 780;
                titleText.x = 10;
                titleText.y = 10;

                var descriptionText = new createjs.Text(gameData.Description, "20px Bold Arial", "dark gray");
                descriptionText.lineWidth = 780;
                descriptionText.x = 10;
                descriptionText.y = 100;

                var startButton = new createjs.Bitmap(resourceLoader.getResult("start_button"));
                startButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
                startButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                startButton.cursor = 'pointer';
                startButton.regX = 50;
                startButton.regY = 50;
                startButton.x = 725;
                startButton.y = 525;

                view.addChild(new createjs.Bitmap(resourceLoader.getResult("title_background")))
                view.addChild(startButton, descriptionText, titleText);

                startButton.addEventListener("click", function (event) {
                    try {
                        showView(getBandView());
                        // Used For Testing the ounds in the SoundBoard
                        //showView(getSoundBoardView());
                    }
                    catch (ex) {
                        console.log("ERROR FROM createTitleView.startButton.click() :: " + ex);
                    }
                });
                startButton.addEventListener("mouseover", function (event) {
                    try {
                        createjs.Tween.get(event.currentTarget)
                            .to({ scaleX: 1.0625, scaleY: 1.0625 }, 100)
                            .to({ scaleX: 1.0, scaleY: 1.0 }, 100)
                            .to({ scaleX: 1.0625, scaleY: 1.0625 }, 200);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createTitleView.startButton.mouseover() :: " + ex);
                    }
                });
                startButton.addEventListener("mouseout", function (event) {
                    try {
                        createjs.Tween.get(event.currentTarget)
                            .to({ scaleX: 1.0, scaleY: 1.0 }, 100);
                    }
                    catch (ex) {
                        console.log("ERROR FROM createTitleView.startButton.mouseout() :: " + ex);
                    }
                });

                return view;
            }
            catch (ex) {
                console.log("ERROR FROM showTitleView() :: " + ex);
            }
        }

        function creatureContainer(imageCreature) {
            try {
                var conTube = new createjs.Container();
                conTube.regX = 98;
                conTube.regY = 195.5;
                conTube.x = 0;
                conTube.y = 0;

                var imageTubeBottom = new createjs.Bitmap(resourceLoader.getResult("tubeBottomLayer"));
                var imageTubeTop = new createjs.Bitmap(resourceLoader.getResult("tubeTopLayer"));

                var imageTubeLid = new createjs.Bitmap(resourceLoader.getResult("tubeLid"));
                imageTubeLid.x = -8;
                imageTubeLid.y = imageTubeBottom.getBounds().height - 72;

                // Was used for testing myMask and setting up the tubeImages
                //var conTubeBG = new createjs.Shape();
                //conTubeBG.graphics.beginFill("#ff0000").drawRect(0, 0, imageTubeBottom.getBounds().width + 10, imageTubeBottom.getBounds().height).endFill();

                var myMask = new createjs.Shape();
                myMask.graphics.beginFill("#ff0000").drawRect(0, 0, imageTubeBottom.getBounds().width, imageTubeBottom.getBounds().height - 10).endFill();

                imageCreature.x = (imageTubeTop.getBounds().width / 2);
                imageCreature.y = (imageTubeTop.getBounds().height / 2);
                imageCreature.scaleX = 0.75;
                imageCreature.scaleY = 0.75;
                imageCreature.mask = myMask;

                conTube.addChild(imageTubeLid, imageTubeBottom, imageCreature, imageTubeTop); // conTubeBG, 
                conTube.scaleX = 0.5;
                conTube.scaleY = 0.5;

                //conTube.name = "conCreature";
                conTube.name = imageCreature.name;
                return conTube;
            } catch (ex) {
                console.log("ERROR FROM creatureContainer() :: " + ex);
            }
        }

        function creatureControls(_tempCreature) {
            try {
                //console.log("HELLO FROM creatureControls(_tempCreature) ::::");
                _tempCreature.addEventListener("dblclick", function (e) {
                    try {
                        //console.log("HELLO FROM :: dblclick");
                        if (gameState.isRunning) { return; };

                        _tempCreature.isMuted = _tempCreature.soundInstance.getMute();
                        //console.log("isMuted :: " + _tempCreature.isMuted);

                        if (_tempCreature.isMuted) {
                            _tempCreature.alpha = 1.0;
                            _tempCreature.soundInstance.setMute(false);
                        }
                        else {
                            _tempCreature.alpha = 0.5;
                            _tempCreature.soundInstance.setMute(true);
                        }
                    }
                    catch (ex) {
                        console.log("ERROR FROM _tempCreature.addEventListener.dblclick :: " + ex);
                    }
                });
                _tempCreature.addEventListener("pressmove", function (e) {
                    try {
                        //console.log("HELLO FROM :: pressmove");
                        if (gameState.isRunning) { return; };

                        var _conBandStage = view.getChildByName("conBandStage");
                        var globalToLocal = _conBandStage.globalToLocal(e.stageX, e.stageY);

                        var _heightHalf = (_tempCreature.height / 2);
                        //var _widthHalf = (_tempCreature.width / 2);

                        _tempCreature.x = globalToLocal.x;// - (_widthHalf);
                        _tempCreature.y = globalToLocal.y;// + (_heightHalf);

                        // X BOUNDS
                        if (_tempCreature.x < 60) {
                            _tempCreature.x = 60;
                        } else if (_tempCreature.x > 740) {
                            _tempCreature.x = 740;
                        }

                        // Y BOUNDS
                        if (_tempCreature.y < 500) {
                            _tempCreature.y = 500;
                        }
                        else if (_tempCreature.y > 675) {
                            _tempCreature.y = 675;
                        }

                        var scaleRange = (_tempCreature.y - 500); // Range of 0-200
                        var percentage = (scaleRange / 1.75); // Range of 0-100
                        var scale = (percentage / 100); // Range of 0-1

                        // Set Volume
                        if (scale <= 0.2) {
                            _tempCreature.soundInstance.setVolume(0.2);
                        }
                        else {
                            _tempCreature.soundInstance.setVolume(scale);
                        }

                        // Set Scale, needed to limit size of images
                        if (scale < 0.30) {
                            _tempCreature.scaleX = 0.30;
                            _tempCreature.scaleY = 0.30;
                        }
                        else if (scale > 0.75) {
                            _tempCreature.scaleX = 0.75;
                            _tempCreature.scaleY = 0.75;
                        }
                        else {
                            _tempCreature.scaleX = scale;
                            _tempCreature.scaleY = scale;
                        }
                    }
                    catch (ex) {
                        console.log("ERROR FROM _tempCreature.addEventListener.pressmove :: " + ex);
                    }
                });
                _tempCreature.addEventListener("pressup", function (e) {
                    try {
                        if (gameState.isRunning) { return; };

                        var _conBandStage = view.getChildByName("conBandStage");

                        if (gameState.myBand != null) {
                            sortArrOfObjectsByParam(gameState.myBand, "scaleX");

                            for (var i = 0; i < gameState.myBand.length; i++) {
                                var _tempObject = gameState.myBand[i];

                                _conBandStage.removeChild(_tempObject);
                                _conBandStage.addChild(_tempObject);
                            }
                        }
                    } catch (ex) {
                        console.log("ERROR FROM _tempCreature.addEventListener.pressup :: " + ex);
                    }
                });
            }
            catch (ex) {
                console.log("ERROR FROM creatureControls() :: " + ex);
            }
        }

        function displayMasterVolumeGauge(intVolume) {
            try {
                var _conControls = bandView.getChildByName("conControls");
                var volumeGauge = _conControls.getChildByName("volumeGauge");
                var volumeLevel = volumeGauge.getChildByName("volumeLevel");

                volumeLevel.graphics.clear();

                if (intVolume == 100) {
                    volumeLevel.graphics.setStrokeStyle(1).beginStroke("#666666").beginFill("#990000").drawRect(0, 100, 25, -intVolume).endStroke().endStroke();
                } else {
                    volumeLevel.graphics.setStrokeStyle(1).beginStroke("#666666").beginFill("#00FF00").drawRect(0, 100, 25, -intVolume).endStroke().endStroke();
                }
            } catch (ex) { console.log("ERROR FROM displayMasterVolumeGauge() :: " + ex); }
        }

        function displayScore(score) {
            try {
                scoreText.text = "SCORE: " + score.toString();
            }
            catch (ex) {
                console.log("ERROR FROM displayScore() :: " + ex);
            }
        }

        function finishGame() {
            try {
                //console.log("HELLO FROM finishGame() :: ");
                // Clean up old Stage Lights for new Tween, setTIMEOUT AVOIDS BUG
                removeStageLights();
                var finaleTime = 1000 + (1000 * gameState.myBand.length);
                setTimeout(function () { getStageLights(); }, 1000 * tweenMultiplier)

                // NEED TO LOOP THROUGH MYBAND AND REMOVE EACH ONE WITH A LIGHTBEAM...
                // THEN RUN FINALE...
                var lastBeam = 999; // Random number to get beams started
                (function myLoop(i) {
                    setTimeout(function () {
                        do {
                            var randomBeam = Math.floor(Math.random() * 3);
                        } while (randomBeam == lastBeam)
                        lastBeam = randomBeam;

                        var tempCreature = gameState.myBand[i - 1];
                        var tempBeam = gameState.stageLights[randomBeam];

                        if (!soundEffect.getMute()) {
                            soundEffect = createjs.Sound.play("teleport", { loop: 0, volume: 0.5, override: true });
                            soundEffect.name = "teleport";
                            arrSoundEffects.push(soundEffect);
                        }

                        createjs.Tween.get(tempBeam, { override: false })
                            .to({ alpha: 1.0, scaleX: 1.75, scaleY: 2.0, skewX: 1.0, rotation: (getAngle(tempCreature, tempBeam)) })
                            .call(function () { createjs.Tween.get(tempCreature).to({ alpha: 0.0 }, 500) })
                            .to({ alpha: 0.0 }, 500)
                            .addEventListener("change", handleChange);

                        function handleChange(event) {
                            var tempFilter = colorFilters[3];
                            tempBeam.filters = [tempFilter];
                            tempBeam.cache(0, 0, 300, 300);
                        }

                        if (--i) myLoop(i);
                    }, 1000)
                })(gameState.myBand.length);

                setTimeout(function () { getStarFinale(); }, finaleTime)
            } catch (ex) {
                console.log("ERROR FROM finishGame() :: " + ex);
            }
        }

        function getAngle(_tempCreature, _tempBeam) {
            try {
                // angle in degrees
                var angleDeg = (Math.atan2(_tempBeam.y - _tempCreature.y, _tempBeam.x - _tempCreature.x) * 180 / Math.PI);

                if (angleDeg > -50) {
                    angleDeg += 15;
                } else if (angleDeg < -100) {
                    angleDeg -= 25;
                }
                return (angleDeg + 100);
            } catch (ex) {
                console.log("ERROR FROM getAngle() :: " + ex);
            }
        }

        function getBandView() {
            try {
                if (bandView == null) {
                    bandView = createBandView();
                }

                return bandView;
            }
            catch (ex) {
                console.log("ERROR FROM getBandView() :: " + ex);
            }
        }

        function getBonusPoints() {
            try {
                //console.log("HELLO FROM :: getBonusPoints()");
                var bonus = Math.round(gameState.questionPoints / gameState.questionTime);

                if (gameState.questionTime <= 3) { bonus = bonus * 2; }
                else if (gameState.questionTime > 10) { bonus = 0; }

                //console.log("gameState.questionTime :: " + gameState.questionTime);
                //console.log("bonus :: " + bonus);
                return bonus;
            } catch (ex) {
                console.log("ERROR FROM getBonusPoints() :: " + ex);
            }
        }

        function getCreature() {
            try {
                //console.log("HELLO FROM getCreature :: ");
                var randomIndex = Math.floor(Math.random() * gameState.creatures.length);
                var selectedCreature = gameState.creatures[randomIndex];

                switch (selectedCreature.id) // ADD CASE FOR EACH CHARACTER
                {
                    // USE THIS TO SET SPRITE, SPRITESHEET, AND SOUND
                    // ALSO NEED SPEED AND LOOP???
                    case "accordiCow":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.01; }
                            else { var speed = 0.2; }

                            var data = {
                                images: [resourceLoader.getResult("accordiCow")],
                                frames: {
                                    width: 149.7, height: 300, frames: 18,
                                    regX: 149.7 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [7], // used for selection screen
                                    idleUp: [0],
                                    idleDown: [5],
                                    idleHalf: [7], // idle for animations
                                    up: {
                                        frames: [5, 6, 7, 8, 9],
                                        next: "idleUp",
                                        speed: speed,
                                    },
                                    down: {
                                        frames: [9, 8, 7, 6, 5],
                                        next: "idleDown",
                                        speed: speed,
                                    },
                                    upSlow: {
                                        frames: [5, 4, 6, 3, 7, 2, 8, 1, 9, 0],
                                        next: "idleUp",
                                        speed: speed,
                                    },
                                    downSlow: {
                                        frames: [0, 9, 1, 8, 2, 7, 3, 6, 4, 5],
                                        next: "idleDown",
                                        speed: speed,
                                    },
                                    // ***** SLOW ENDING BENDS *****
                                    upEnding: {
                                        frames: [8, 7, 8, 9, 8, 7, 8, 9, 8, 7, 8, 9, 8, 7, 8, 9, 8, 7, 8, 9],
                                        next: "idleUp",
                                        speed: (speed / 2),
                                    },
                                    downEnding: {
                                        frames: [6, 7, 6, 5, 6, 7, 6, 5, 6, 7, 6, 5, 6, 7, 6, 5, 6, 7, 6, 5],
                                        next: "idleDown",
                                        speed: (speed / 2),
                                    },
                                    // ***** New Full PATH Animations
                                    halfUpDownHalf: {
                                        frames: [7, 8, 9, 8, 7, 6, 5, 6, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    halfUpDownUpHalf: {
                                        frames: [7, 8, 9, 8, 7, 6, 5, 6, 7, 8, 9, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    halfDownUpDownHalf: {
                                        frames: [7, 6, 5, 6, 7, 8, 9, 8, 7, 6, 5, 6, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    leftRight: {
                                        frames: [7, 8, 14, 8, 7, 8, 18, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    leftRight: {
                                        frames: [7, 8, 18, 8, 7, 8, 14, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    // ***** UNUSED ANIMATION, BUT HELPFUL AS REFERENCE *****
                                    halfUp: {
                                        frames: [7, 8, 9, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    halfDown: {
                                        frames: [7, 6, 5, 6, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    left: {
                                        frames: [7, 8, 14, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    right: {
                                        frames: [7, 8, 18, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },

                                },
                            };
                            break;
                        }
                    case "bass":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("bass")],
                                frames: {
                                    width: 150, height: 300, frames: 24,
                                    regX: 150 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    low: {
                                        frames: [0, 1, 2, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    high: {
                                        frames: [4, 5, 6, 7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    hop: {
                                        frames: [8, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blink: {
                                        frames: [12, 13, 14], //,15
                                        next: "idle",
                                        speed: speed,
                                    },
                                    highMid: {
                                        frames: [15, 16, 17],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    lowMid: {
                                        frames: [18, 19, 20],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "bouncyCow":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.2; }
                            else { var speed = 0.275; }

                            var data = {
                                images: [resourceLoader.getResult("bouncyCow")],
                                frames: {
                                    width: 300, height: 300, frames: 6,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleEnd: [5],
                                    leftToRight: {
                                        frames: [0, 1, 2, 3, 4, 5],
                                        next: "idleEnd",
                                        speed: speed,
                                    },
                                    rightToLeft: {
                                        frames: [5, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    fullMotionForward: {
                                        frames: [0, 1, 2, 3, 4, 5, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    fullMotionReverse: {
                                        frames: [5, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5],
                                        next: "idleEnd",
                                        speed: speed,
                                    },
                                    shortHop: {
                                        frames: [0, 1, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    dance: {
                                        frames: [0, 1, 2, 1, 0, 1, 0, 1],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "cymbolCow":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.13; }
                            else { var speed = 0.25; }

                            var data = {
                                images: [resourceLoader.getResult("cymbolCow")],
                                frames: {
                                    width: 300, height: 300, frames: 7,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleOpen: [3],
                                    up: {
                                        frames: [0, 1, 2, 3],
                                        next: "idleOpen",
                                        speed: speed,
                                    },
                                    down: {
                                        frames: [3, 2, 1, 0],
                                        next: "idleOpen",
                                        speed: speed,
                                    },
                                    clap: {
                                        frames: [0, 1, 2, 3, 4, 5, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    shake: {
                                        frames: [0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    extendedClap: {
                                        frames: [0, 1, 0, 1, 2, 1, 0, 1, 2, 3, 4, 5, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "flyingMonster":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.1; }
                            else { var speed = 0.4; }

                            var data = {
                                images: [resourceLoader.getResult("flyingMonster")],
                                frames: {
                                    width: 300, height: 100, frames: 6,
                                    regX: 300 / 2,
                                    regY: 100 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    wingFlap: {
                                        frames: [0, 1, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    wingFlapDouble: {
                                        frames: [0, 1, 2, 1, 0, 1, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    baa: {
                                        frames: [3, 4, 5, 4, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    yip: {
                                        frames: [3, 4, 5],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    wow: {
                                        frames: [5, 4, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "hammerHead":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("hammerHead")],
                                frames: {
                                    width: 300, height: 300, frames: 10,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    hop: {
                                        frames: [0, 1, 2],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    left: {
                                        frames: [0, 1, 2, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    right: {
                                        frames: [0, 1, 2, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    double: {
                                        frames: [5, 6, 7, 8, 9],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "mouthMonster":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.4; }
                            else { var speed = 0.2; }

                            var data = {
                                images: [resourceLoader.getResult("mouthMonster")],
                                frames: {
                                    width: 300, height: 300, frames: 12,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [2],
                                    footTap: {
                                        frames: [0, 1, 2],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    smallMouth: {
                                        frames: [2, 3, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    headBob: {
                                        frames: [6, 7, 8],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    bigMouth: {
                                        frames: [2, 3, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    holdOut: {
                                        frames: [2, 3, 9, 10, 11, 10, 9, 10, 11, 10, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    closedMouth: {
                                        frames: [5, 4, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "pianoTeeth":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("pianoTeeth")],
                                frames: {
                                    width: 300, height: 300, frames: 20,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    high: [0, 4, "idle", speed],
                                    buckTooth: [5, 9, "idle", speed],
                                    eyeRoll: [10, 14, "idle", speed],
                                    low: [15, 19, "idle", speed],
                                },
                            };

                            break;
                        }
                    case "pingPongCow":
                        {
                            var speed = 0.3;
                            var data = {
                                images: [resourceLoader.getResult("pingPongCow")],
                                frames: {
                                    width: (1798 / 6), height: 300, frames: 12,
                                    regX: (1798 / 6) / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleHalf: [5],
                                    idleEnd: [9],
                                    first: {
                                        frames: [0, 1, 2, 3, 4, 5],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    second: {
                                        frames: [5, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    third: {
                                        frames: [6, 7, 8, 9, 10, 11],
                                        next: "idleEnd",
                                        speed: speed,
                                    },
                                    fourth: {
                                        frames: [11, 10, 9, 8, 7, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "simon":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.1; }
                            else { var speed = 0.3; }

                            var data = {
                                images: [resourceLoader.getResult("simon")],
                                frames: {
                                    width: 300, height: 300, frames: 20,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    hop: {
                                        frames: [0, 1, 2, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    red: {
                                        frames: [4, 5, 6, 7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    yellow: {
                                        frames: [8, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blue: {
                                        frames: [12, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    green: {
                                        frames: [16, 17, 18, 19],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    // ***** HoldOuts *****
                                    redHold: {
                                        frames: [4, 5, 6, 7, 5, 6, 7, 5, 6, 7, 5, 6, 7, 5, 6, 7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    yellowHold: {
                                        frames: [8, 9, 10, 11, 9, 10, 11, 9, 10, 11, 9, 10, 11, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blueHold: {
                                        frames: [12, 13, 14, 15, 13, 14, 15, 13, 14, 15, 13, 14, 15, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    greenHold: {
                                        frames: [16, 17, 18, 19, 17, 18, 19, 17, 18, 19, 17, 18, 19, 17, 18, 19],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    jazzyJay: {
                                        frames: [1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 5, 7, 13, 15, 9, 11,
                                            17, 19, 13, 15, 5, 7, 17, 19, 9, 11, 9, 11, 13, 15, 9, 11, 17, 19,
                                            5, 7, 13, 15, 9, 11, 17, 19, 5, 7, 17, 19, 13, 15, 9, 11],
                                        next: "experiment",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "slide":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.4; }
                            else { var speed = 0.2; }

                            var data = {
                                images: [resourceLoader.getResult("slide")],
                                frames: {
                                    width: 114, height: 300, frames: 9,
                                    regX: 114 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleHalf: [2],
                                    idleTop: [4],
                                    down: {
                                        frames: [4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    up: {
                                        frames: [0, 1, 2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                    // Bottom - to - Half
                                    bottomHalf: {
                                        frames: [0, 1, 2],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    // Half - to - Bottom
                                    halfBottom: {
                                        frames: [2, 1, 0],
                                        next: "idleBottom",
                                        speed: speed,
                                    },
                                    // Half - to - Top
                                    halfTop: {
                                        frames: [2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                    // Top - to - Half
                                    topHalf: {
                                        frames: [4, 3, 2],
                                        next: "idleHalf",
                                        speed: speed,
                                    },

                                    // up, full drop
                                    upFullDown: {
                                        frames: [0, 1, 2, 3, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    // jazzyJay Tracks
                                    downHalfDownUp: {
                                        frames: [0, 1, 2, 1, 0, 1, 2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                    wavy: {
                                        frames: [4, 3, 2, 3, 4, 3, 2, 3, 4, 3, 2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                },
                            };

                            break;
                        }
                    case "spineMan":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("spineMan")],
                                frames: {
                                    width: 200, height: 300, frames: 16,
                                    regX: 200 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    extend: {
                                        frames: [0, 1, 2, 3, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    extendAndRelease: {
                                        frames: [0, 1, 2, 3, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blinkEar: {
                                        frames: [0, 5, 6.7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    rightBend: {
                                        frames: [8, 9, 10],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    leftBend: {
                                        frames: [11, 12, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    dualBend: {
                                        frames: [8, 9, 10, 11, 12, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "tenticles":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("tenticles")],
                                frames: {
                                    width: 400, height: 300, frames: 10,
                                    regX: 400 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [4],
                                    right: {
                                        frames: [0, 1, 2, 3, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    left: {
                                        frames: [5, 6, 7, 8, 9],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    quickTriple: {
                                        frames: [0, 1, 4, 5, 6, 0, 1],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "turntableCow":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("turntableCow")],
                                frames: {
                                    width: 300, height: 300, frames: 18,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    spinning: {
                                        frames: [0, 1, 2, 3, 4, 5],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    leftScratch: {
                                        frames: [6, 7, 8, 9, 10, 11, 10, 9, 10, 11, 10, 9, 8, 7, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    rightScratch: {
                                        frames: [12, 13, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    //leftScratch: {
                                    //    frames: [6, 7, 8, 9, 10, 11, 10, 9, 8, 7, 6],
                                    //    next: "idle",
                                    //    speed: speed,
                                    //},
                                    //rightScratch: {
                                    //    frames: [12, 13, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17],
                                    //    next: "idle",
                                    //    speed: speed,
                                    //},
                                },
                            };
                            break;
                        }
                }

                var spriteSheet = new createjs.SpriteSheet(data);
                var spriteCreature = new createjs.Sprite(spriteSheet, "idle");
                spriteCreature.name = selectedCreature.id;
                spriteCreature.soundInstance = gameState.audioClips[selectedCreature.soundid[gameState.selectedTracks]];

                return spriteCreature;
            }
            catch (ex) {
                console.log("ERROR FROM getCreature(NEW)() :: " + ex);
            }
        }

        function getCreatureNew(randomIndex) {
            try {
                //console.log("HELLO FROM getCreature :: ");
                //var randomIndex = Math.floor(Math.random() * gameState.creatures.length);
                var selectedCreature = gameState.creatures[randomIndex];

                switch (selectedCreature.id) // ADD CASE FOR EACH CHARACTER
                {
                    // USE THIS TO SET SPRITE, SPRITESHEET, AND SOUND
                    // ALSO NEED SPEED AND LOOP???
                    case "accordiCow":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.01; }
                            else { var speed = 0.2; }

                            var data = {
                                images: [resourceLoader.getResult("accordiCow")],
                                frames: {
                                    width: 149.7, height: 300, frames: 18,
                                    regX: 149.7 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [7], // used for selection screen
                                    idleUp: [0],
                                    idleDown: [5],
                                    idleHalf: [7], // idle for animations
                                    up: {
                                        frames: [5, 6, 7, 8, 9],
                                        next: "idleUp",
                                        speed: speed,
                                    },
                                    down: {
                                        frames: [9, 8, 7, 6, 5],
                                        next: "idleDown",
                                        speed: speed,
                                    },
                                    // ***** SLOW ENDING BENDS *****
                                    upEnding: {
                                        frames: [8, 7, 8, 9, 8, 7, 8, 9, 8, 7, 8, 9, 8, 7, 8, 9, 8, 7, 8, 9],
                                        next: "idleUp",
                                        speed: (speed / 2),
                                    },
                                    downEnding: {
                                        frames: [6, 7, 6, 5, 6, 7, 6, 5, 6, 7, 6, 5, 6, 7, 6, 5, 6, 7, 6, 5],
                                        next: "idleDown",
                                        speed: (speed / 2),
                                    },
                                    // ***** New Full PATH Animations
                                    halfUpDownHalf: {
                                        frames: [7, 8, 9, 8, 7, 6, 5, 6, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    halfUpDownUpHalf: {
                                        frames: [7, 8, 9, 8, 7, 6, 5, 6, 7, 8, 9, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    halfDownUpDownHalf: {
                                        frames: [7, 6, 5, 6, 7, 8, 9, 8, 7, 6, 5, 6, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    leftRight: {
                                        frames: [7, 8, 14, 8, 7, 8, 18, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    leftRight: {
                                        frames: [7, 8, 18, 8, 7, 8, 14, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    // ***** UNUSED ANIMATION, BUT HELPFUL AS REFERENCE *****
                                    halfUp: {
                                        frames: [7, 8, 9, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    halfDown: {
                                        frames: [7, 6, 5, 6, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    left: {
                                        frames: [7, 8, 14, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    right: {
                                        frames: [7, 8, 18, 8, 7],
                                        next: "idleHalf",
                                        speed: speed,
                                    },

                                },
                            };
                            break;
                        }
                    case "bass":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("bass")],
                                frames: {
                                    width: 150, height: 300, frames: 24,
                                    regX: 150 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    low: {
                                        frames: [0, 1, 2, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    high: {
                                        frames: [4, 5, 6, 7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    hop: {
                                        frames: [8, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blink: {
                                        frames: [12, 13, 14], //,15
                                        next: "idle",
                                        speed: speed,
                                    },
                                    highMid: {
                                        frames: [15, 16, 17],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    lowMid: {
                                        frames: [18, 19, 20],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "bouncyCow":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.2; }
                            else { var speed = 0.275; }

                            var data = {
                                images: [resourceLoader.getResult("bouncyCow")],
                                frames: {
                                    width: 300, height: 300, frames: 6,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleEnd: [5],
                                    leftToRight: {
                                        frames: [0, 1, 2, 3, 4, 5],
                                        next: "idleEnd",
                                        speed: speed,
                                    },
                                    rightToLeft: {
                                        frames: [5, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    fullMotionForward: {
                                        frames: [0, 1, 2, 3, 4, 5, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    fullMotionReverse: {
                                        frames: [5, 4, 3, 2, 1, 0, 1, 2, 3, 4, 5],
                                        next: "idleEnd",
                                        speed: speed,
                                    },
                                    shortHop: {
                                        frames: [0, 1, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    dance: {
                                        frames: [0, 1, 2, 1, 0, 1, 0, 1],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "cymbolCow":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.13; }
                            else { var speed = 0.25; }

                            var data = {
                                images: [resourceLoader.getResult("cymbolCow")],
                                frames: {
                                    width: 300, height: 300, frames: 7,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleOpen: [3],
                                    up: {
                                        frames: [0, 1, 2, 3],
                                        next: "idleOpen",
                                        speed: speed,
                                    },
                                    down: {
                                        frames: [3, 2, 1, 0],
                                        next: "idleOpen",
                                        speed: speed,
                                    },
                                    clap: {
                                        frames: [0, 1, 2, 3, 4, 5, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    shake: {
                                        frames: [0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    extendedClap: {
                                        frames: [0, 1, 0, 1, 2, 1, 0, 1, 2, 3, 4, 5, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "flyingMonster":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.1; }
                            else { var speed = 0.4; }

                            var data = {
                                images: [resourceLoader.getResult("flyingMonster")],
                                frames: {
                                    width: 300, height: 100, frames: 6,
                                    regX: 300 / 2,
                                    regY: 100 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    wingFlap: {
                                        frames: [0, 1, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    wingFlapDouble: {
                                        frames: [0, 1, 2, 1, 0, 1, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    baa: {
                                        frames: [3, 4, 5, 4, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    yip: {
                                        frames: [3, 4, 5],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    wow: {
                                        frames: [5, 4, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "hammerHead":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("hammerHead")],
                                frames: {
                                    width: 300, height: 300, frames: 10,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    hop: {
                                        frames: [0, 1, 2],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    left: {
                                        frames: [0, 1, 2, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    right: {
                                        frames: [0, 1, 2, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    double: {
                                        frames: [5, 6, 7, 8, 9],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "mouthMonster":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.4; }
                            else { var speed = 0.2; }

                            var data = {
                                images: [resourceLoader.getResult("mouthMonster")],
                                frames: {
                                    width: 300, height: 300, frames: 12,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [2],
                                    footTap: {
                                        frames: [0, 1, 2],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    smallMouth: {
                                        frames: [2, 3, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    headBob: {
                                        frames: [6, 7, 8],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    bigMouth: {
                                        frames: [2, 3, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    holdOut: {
                                        frames: [2, 3, 9, 10, 11, 10, 9, 10, 11, 10, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    closedMouth: {
                                        frames: [5, 4, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "pianoTeeth":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("pianoTeeth")],
                                frames: {
                                    width: 300, height: 300, frames: 20,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    high: [0, 4, "idle", speed],
                                    buckTooth: [5, 9, "idle", speed],
                                    eyeRoll: [10, 14, "idle", speed],
                                    low: [15, 19, "idle", speed],
                                },
                            };

                            break;
                        }
                    case "pingPongCow":
                        {
                            var speed = 0.3;
                            var data = {
                                images: [resourceLoader.getResult("pingPongCow")],
                                frames: {
                                    width: (1798 / 6), height: 300, frames: 12,
                                    regX: (1798 / 6) / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleHalf: [5],
                                    idleEnd: [9],
                                    first: {
                                        frames: [0, 1, 2, 3, 4, 5],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    second: {
                                        frames: [5, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    third: {
                                        frames: [6, 7, 8, 9, 10, 11],
                                        next: "idleEnd",
                                        speed: speed,
                                    },
                                    fourth: {
                                        frames: [11, 10, 9, 8, 7, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "simon":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.1; }
                            else { var speed = 0.3; }

                            var data = {
                                images: [resourceLoader.getResult("simon")],
                                frames: {
                                    width: 300, height: 300, frames: 20,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    hop: {
                                        frames: [0, 1, 2, 3],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    red: {
                                        frames: [4, 5, 6, 7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    yellow: {
                                        frames: [8, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blue: {
                                        frames: [12, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    green: {
                                        frames: [16, 17, 18, 19],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    // ***** HoldOuts *****
                                    redHold: {
                                        frames: [4, 5, 6, 7, 5, 6, 7, 5, 6, 7, 5, 6, 7, 5, 6, 7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    yellowHold: {
                                        frames: [8, 9, 10, 11, 9, 10, 11, 9, 10, 11, 9, 10, 11, 9, 10, 11],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blueHold: {
                                        frames: [12, 13, 14, 15, 13, 14, 15, 13, 14, 15, 13, 14, 15, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    greenHold: {
                                        frames: [16, 17, 18, 19, 17, 18, 19, 17, 18, 19, 17, 18, 19, 17, 18, 19],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    jazzyJay: {
                                        frames: [1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 5, 7, 13, 15, 9, 11,
                                            17, 19, 13, 15, 5, 7, 17, 19, 9, 11, 9, 11, 13, 15, 9, 11, 17, 19,
                                            5, 7, 13, 15, 9, 11, 17, 19, 5, 7, 17, 19, 13, 15, 9, 11],
                                        next: "experiment",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "slide":
                        {
                            if (gameState.selectedTracks == "jazzyJay") { var speed = 0.4; }
                            else { var speed = 0.2; }

                            var data = {
                                images: [resourceLoader.getResult("slide")],
                                frames: {
                                    width: 114, height: 300, frames: 9,
                                    regX: 114 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    idleHalf: [2],
                                    idleTop: [4],
                                    down: {
                                        frames: [4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    up: {
                                        frames: [0, 1, 2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                    // Bottom - to - Half
                                    bottomHalf: {
                                        frames: [0, 1, 2],
                                        next: "idleHalf",
                                        speed: speed,
                                    },
                                    // Half - to - Bottom
                                    halfBottom: {
                                        frames: [2, 1, 0],
                                        next: "idleBottom",
                                        speed: speed,
                                    },
                                    // Half - to - Top
                                    halfTop: {
                                        frames: [2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                    // Top - to - Half
                                    topHalf: {
                                        frames: [4, 3, 2],
                                        next: "idleHalf",
                                        speed: speed,
                                    },

                                    // up, full drop
                                    upFullDown: {
                                        frames: [0, 1, 2, 3, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    // jazzyJay Tracks
                                    downHalfDownUp: {
                                        frames: [0, 1, 2, 1, 0, 1, 2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                    wavy: {
                                        frames: [4, 3, 2, 3, 4, 3, 2, 3, 4, 3, 2, 3, 4],
                                        next: "idleTop",
                                        speed: speed,
                                    },
                                },
                            };

                            break;
                        }
                    case "spineMan":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("spineMan")],
                                frames: {
                                    width: 200, height: 300, frames: 16,
                                    regX: 200 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    extend: {
                                        frames: [0, 1, 2, 3, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    extendAndRelease: {
                                        frames: [0, 1, 2, 3, 4, 3, 2, 1, 0],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    blinkEar: {
                                        frames: [0, 5, 6.7],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    rightBend: {
                                        frames: [8, 9, 10],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    leftBend: {
                                        frames: [11, 12, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    dualBend: {
                                        frames: [8, 9, 10, 11, 12, 13, 14, 15],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "tenticles":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("tenticles")],
                                frames: {
                                    width: 400, height: 300, frames: 10,
                                    regX: 400 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [4],
                                    right: {
                                        frames: [0, 1, 2, 3, 4],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    left: {
                                        frames: [5, 6, 7, 8, 9],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    quickTriple: {
                                        frames: [0, 1, 4, 5, 6, 0, 1],
                                        next: "idle",
                                        speed: speed,
                                    },
                                },
                            };
                            break;
                        }
                    case "turntableCow":
                        {
                            var speed = 0.2;
                            var data = {
                                images: [resourceLoader.getResult("turntableCow")],
                                frames: {
                                    width: 300, height: 300, frames: 18,
                                    regX: 300 / 2,
                                    regY: 300 / 2,
                                },
                                animations: {
                                    idle: [0],
                                    spinning: {
                                        frames: [0, 1, 2, 3, 4, 5],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    leftScratch: {
                                        frames: [6, 7, 8, 9, 10, 11, 10, 9, 10, 11, 10, 9, 8, 7, 6],
                                        next: "idle",
                                        speed: speed,
                                    },
                                    rightScratch: {
                                        frames: [12, 13, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17],
                                        next: "idle",
                                        speed: speed,
                                    },

                                    //leftScratch: {
                                    //    frames: [6, 7, 8, 9, 10, 11, 10, 9, 8, 7, 6],
                                    //    next: "idle",
                                    //    speed: speed,
                                    //},
                                    //rightScratch: {
                                    //    frames: [12, 13, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17],
                                    //    next: "idle",
                                    //    speed: speed,
                                    //},
                                },
                            };
                            break;
                        }
                }

                var spriteSheet = new createjs.SpriteSheet(data);
                var spriteCreature = new createjs.Sprite(spriteSheet, "idle");
                spriteCreature.name = selectedCreature.id;
                spriteCreature.soundInstance = gameState.audioClips[selectedCreature.soundid[gameState.selectedTracks]];

                // *********************************************************
                //myCreature.push(data);
                //myCreature.push(spriteSheet);
                //myCreature.push(spriteCreature);
                //myCreature.push();

                //console.log("myCreature :: ");
                //console.log(myCreature);
                // *********************************************************

                //spriteCreature.myObject = myCreature;
                //myCreature = null;


                // SHOULD BE SAME FOR ALL
                // x, y, scaleX, and scaleY 
                //spriteCreature.x = 0;
                //spriteCreature.y = 0;
                //spriteCreature.regX = (spriteCreature.getBounds().width / 2);
                //spriteCreature.regY = (spriteCreature.getBounds().height / 2);
                //spriteCreature.scaleX = 1.0;
                //spriteCreature.scaleY = 1.0;

                //conCreature.addChild(spriteCreature);
                //conCreature.soundInstance = gameState.audioClips[selectedCreature.soundid];
                //conCreature.height = spriteCreature.getBounds().height;
                //conCreature.width = spriteCreature.getBounds().width;

                //var _conBandStage = view.getChildByName("conBandStage");
                //_conBandStage.addChild(conCreature);

                return spriteCreature;
            }
            catch (ex) {
                console.log("ERROR FROM getCreature(NEW)() :: " + ex);
            }
        }

        function getGameProgress() {
            try {
                var _conControls = view.getChildByName("conControls");
                var _conText = _conControls.getChildByName("conText");
                var txtInstructions = _conText.getChildByName("txtInstructions");

                if (gameState.myBand.length >= gameState.maxMembers) {
                    gameState.selectionNumber = -1;
                    txtInstructions.text = "Your Band is ready. Make your final adjustments to the band and click on the Add Member to conclude the game.";
                    txtInstructions.font = "14pt Arial Black";
                    txtInstructions.y = 45;

                    readyEnding();
                    gameState.isEndingReady = true;
                    return;
                };

                // check questions so user won't be reusing any questions
                if (gameState.usedQuestions.length >= gameState.questions.length) {
                    gameState.selectionNumber = -1;
                    txtInstructions.text = "You are out of questions for this game, so you can no longer release creatures. Make your final adjustments to the band and click on the Add Member to conclude the game.";
                    txtInstructions.font = "10pt Arial Black";
                    txtInstructions.y = 40;

                    readyEnding();
                    gameState.isEndingReady = true;
                    return;
                }

                // Check number of creatures with your band and lost creatures
                var creaturesLeft = gameState.creatures.length - (gameState.myBand.length + gameState.lostCreatures.length);

                if (creaturesLeft <= 2) {
                    gameState.selectionNumber = creaturesLeft - 1;
                }
                else {
                    gameState.selectionNumber = 2
                }

                if (creaturesLeft <= 0) {
                    txtInstructions.text = "Sorry, but there is no creatures left to obtain. Feel free to experiment with the creatures you have obtained, or click on the Add Member to conclude the game.";
                    txtInstructions.font = "10pt Arial Black";
                    txtInstructions.y = 40;

                    readyEnding();
                    gameState.isEndingReady = true;
                    return;
                }
            }
            catch (ex) {
                console.log("ERROR FROM getGameProgress() :: " + ex);
            }
        }

        function getInstructionsView() {
            try {
                if (instructionsView == null) {
                    instructionsView = createInstructionsView();
                }

                return instructionsView;
            }
            catch (ex) {
                console.log("ERROR FROM getInstructionsView() :: " + ex);
            }
        }

        function getQuestionView() {
            try {
                if (questionView == null) {
                    questionView = createQuestionView();
                }

                return questionView;
            }
            catch (ex) {
                console.log("ERROR FROM getQuestionView() :: " + ex);
            }
        }

        function getSelectInstrumentView() {
            try {
                if (selectInstrumentView == null) {
                    selectInstrumentView = createSelectInstrumentView();
                }

                return selectInstrumentView;
            }
            catch (ex) {
                console.log("ERROR FROM getSelectionView() :: " + ex);
            }
        }

        function getSoundBoardView() {
            try {
                if (soundBoardView == null) {
                    soundBoardView = createSoundBoard();
                }

                return soundBoardView;
            }
            catch (ex) {
                console.log("ERROR FROM getSoundBoardView() :: " + ex);
            }
        }

        function getStageLights() {
            try {
                if (gameState.stageLights.length > 0) { return; }

                var beamStartingCoords = {
                    left: { x: 320, y: 127 },
                    center: { x: 400, y: 158 },
                    right: { x: 485, y: 127 }
                }

                var leftLightBeam = createLightBeam();
                leftLightBeam.name = "leftLightBeam";
                leftLightBeam.x = beamStartingCoords.left.x;
                leftLightBeam.y = beamStartingCoords.left.y;
                leftLightBeam.scaleX = 1.5;
                leftLightBeam.scaleY = 1.75;
                leftLightBeam.skewX = 25;
                leftLightBeam.alpha = 0.0;

                var centerLightBeam = createLightBeam();
                centerLightBeam.name = "centerLightBeam";
                centerLightBeam.x = beamStartingCoords.center.x;
                centerLightBeam.y = beamStartingCoords.center.y;
                centerLightBeam.scaleX = 1.5;
                centerLightBeam.scaleY = 1.5;
                centerLightBeam.alpha = 0.0;

                var rightLightBeam = createLightBeam();
                rightLightBeam.name = "rightLightBeam";
                rightLightBeam.x = beamStartingCoords.right.x;
                rightLightBeam.y = beamStartingCoords.right.y;
                rightLightBeam.scaleX = 1.5;
                rightLightBeam.scaleY = 1.75;
                rightLightBeam.skewX = -25;
                rightLightBeam.alpha = 0.0;

                gameState.stageLights.push(leftLightBeam);
                gameState.stageLights.push(centerLightBeam);
                gameState.stageLights.push(rightLightBeam);

                view.addChild(leftLightBeam, centerLightBeam, rightLightBeam);
            }
            catch (ex) { console.log("ERROR FROM getStageLights() :: " + ex); }
        }

        function getStarFinale() {
            try {
                var starFlashOne = new createjs.Shape();
                starFlashOne.graphics.beginFill("#FFFFFF").drawPolyStar(315, 127, 35, 8, 0.9, 45);
                starFlashOne.alpha = 0.0;
                createjs.Tween.get(starFlashOne, { loop: -1 }).to({ alpha: 0.0 }, 100).to({ alpha: 1.0 }, 100);

                var starFlashTwo = new createjs.Shape();
                starFlashTwo.graphics.beginFill("#FFFFFF").drawPolyStar(400, 158, 35, 8, 0.9, 45);
                starFlashTwo.alpha = 0.0;
                createjs.Tween.get(starFlashTwo, { loop: -1 }).to({ alpha: 0.0 }, 100).to({ alpha: 1.0 }, 100);

                var starFlashThree = new createjs.Shape();
                starFlashThree.graphics.beginFill("#FFFFFF").drawPolyStar(480, 127, 35, 8, 0.9, 45);
                starFlashThree.alpha = 0.0;
                createjs.Tween.get(starFlashThree, { loop: -1 }).to({ alpha: 0.0 }, 100).to({ alpha: 1.0 }, 100);

                var whiteOut = new createjs.Shape();
                whiteOut.graphics.setStrokeStyle(1).beginStroke("#FFFFFF").beginFill("#FFFFFF").drawRect(0, 0, originalWidth, originalHeight).endStroke().endFill();
                whiteOut.alpha = 0.0;

                if (!soundEffect.getMute()) {
                    soundEffect = createjs.Sound.play("energyPulse", { loop: -1, volume: 0.5 });
                    soundEffect.name = "energyPulse";
                    arrSoundEffects.push(soundEffect);
                }

                var tweenWhiteOut = new createjs.Tween.get(whiteOut).to({ alpha: 1.0 }, 3000 * tweenMultiplier).call(onFinaleComplete);

                function onFinaleComplete() {
                    // This will need to shut down all sound clips, remove all tween, and reset varables
                    // Stop all music and animations
                    arrSoundEffects = [];
                    masterSound.setMute(false); // BUG FIX :: turn off mute before restart
                    masterSound.stop();
                    removeStageLights();
                    createjs.Tween.removeAllTweens();

                    // NEED TO SUBMIT SCORE HERE, BEFORE RESET ALL THE VARIABLES
                    submitScore(gameState.score);

                    // Round Clean Up, Variable reset
                    gameState.currentAnswer = null;
                    gameState.currentQuestion = null;
                    gameState.currentSelection = null;
                    gameState.endGame = false;
                    gameState.isEndingReady = false;
                    gameState.isFinale = false;
                    gameState.isRunning = false;
                    gameState.isQuestionComplete = false;
                    gameState.lostCreatures = [];
                    gameState.myBand = [];
                    gameState.questions = gameData.Questions;
                    gameState.score = 0;
                    gameState.selectionNumber = 2;
                    gameState.usedQuestions = [];
                    gameState.submitedScore = false;


                    // if GameData does NOT specify whether or not the questions should be randomized, randomize them
                    // otherwise do what gamaData.RandomizeQuestions says
                    /*
                    if (typeof gameData.RandomizeQuestions === 'undefined' || gameData.RandomizeQuestions == true) {
                        gameState.questions = shuffle(gameData.Questions);
                    }
                    */



                    // null all old views
                    bandView = null;
                    instructionsView = null;
                    soundBoardView = null;
                    titleView = null;
                    windowQuestion = null;

                    // Last Tasks of trigger ending...
                    // This will reset the game and select another trackset
                    self.stage.removeAllChildren();
                    selectMusicTracks();
                    showView(getTitleView());
                }

                view.addChild(whiteOut, starFlashOne, starFlashTwo, starFlashThree);
            } catch (ex) {
                console.log("ERROR FROM getStarFinale() :: " + ex);
            }
        }

        function getTitleView() {
            try {
                if (titleView == null) {
                    titleView = createTitleView();
                }

                return titleView;
            }
            catch (ex) {
                console.log("ERROR FROM getTitleView() :: " + ex);
            }
        }

        function getUFO() {
            try {
                //var _conBandStage = view.getChildByName("conBandStage");
                // NEW UFO SIGHTING !!!
                var conUFO = new createjs.Container();

                var speedUFO = 0.1;
                var dataUFO = {
                    images: [resourceLoader.getResult("spaceShip")],
                    frames: {
                        width: 455, height: 150, frames: 4,
                        regX: 455 / 2,
                        regY: 0,
                    },
                    animations: {
                        rotation: [0, 3, "rotation", speedUFO],
                    },
                };

                var spriteSheetUFO = new createjs.SpriteSheet(dataUFO);
                var spriteUFO = new createjs.Sprite(spriteSheetUFO);

                conUFO.myTween = createjs.Tween.get(spriteUFO, { override: true, loop: 0 })
                    .wait(100)
                    .addEventListener("change", handleChange);

                if (!soundEffect.getMute()) {
                    soundEffect = createjs.Sound.play("ufoHover", { loop: -1, volume: 0.6 });
                    soundEffect.name = "ufoHover";
                    arrSoundEffects.push(soundEffect);
                }

                function handleChange() {
                    try {
                        spriteUFO.gotoAndPlay("rotation", { loop: -1 });
                    }
                    catch (ex) {
                        console.log("ERROR FROM getUFO.handleChange() :: " + ex);
                    }
                }

                var speedUdder = 0.1;
                var dataUdder = {
                    images: [resourceLoader.getResult("udderSquirts")],
                    frames: {
                        width: 50, height: 75, frames: 18,
                        regX: 25,
                        regY: 0,
                    },
                    animations: {
                        leftIdle: [0],
                        leftfire: {
                            frames: [0, 1, 2, 3],
                            next: "leftIdle",
                            speed: speedUdder,
                        },

                        rightIdle: [11],
                        rightfire: {
                            frames: [11, 6, 7, 8],
                            next: "rightIdle",
                            speed: speedUdder,
                        },

                        centerIdle: [17],
                        centerfire: {
                            frames: [17, 12, 13, 14],
                            next: "centerIdle",
                            speed: speedUdder,
                        },
                    },
                };

                spriteSheet = new createjs.SpriteSheet(dataUdder);

                var spriteLeftUdder = new createjs.Sprite(spriteSheet, "leftIdle");
                spriteLeftUdder.name = "leftUdder";
                spriteLeftUdder.x = -75;
                spriteLeftUdder.y = 100;

                var spriteRightUdder = new createjs.Sprite(spriteSheet, "rightIdle");
                spriteRightUdder.name = "rightUdder";
                spriteRightUdder.x = 75;
                spriteRightUdder.y = 100;

                var spriteCenterUdder = new createjs.Sprite(spriteSheet, "centerIdle");
                spriteCenterUdder.name = "centerUdder";
                spriteCenterUdder.x = 0;
                spriteCenterUdder.y = 125;

                conUFO.addChild(spriteUFO, spriteRightUdder, spriteLeftUdder, spriteCenterUdder);
                return conUFO;
            } catch (ex) {
                console.log("ERROR FROM getUFO() :: " + ex);
            }
        }

        function highlightAnswer() {
            try {
                if (windowQuestion.name != "windowQuestions") { return; }
                var tempContainer = view.getChildByName("conBandStage");
                var tempWindow = tempContainer.getChildByName("windowQuestions");
                var tempContainerAnswers = tempWindow.getChildByName("conAnswers");

                highlightButton(tempWindow);

                for (var i = 0; i < tempContainerAnswers.children.length; ++i) {
                    var tempAnswer = tempContainerAnswers.getChildByName("Answer_" + i);
                    var text = tempAnswer.getChildByName("txtAnswer").text;

                    if (text == gameState.currentAnswer.Text) {
                        var background = tempAnswer.getChildByName("answerBG");
                        background.graphics.setStrokeStyle(3).beginStroke("#FFFF00")//.beginFill("#003D66")
                            .beginLinearGradientFill(
                            ["#003152", "#003D66", "#003D66", "#003152"],
                            [0.1, 0.35, 0.65, 0.9],
                            0, 0, 0, 75)
                            .drawRoundRect(0, 0, 600, 75, 5).endStroke().endFill();
                        background.shadow = buttonShadow;
                    }
                    else {
                        var background = tempAnswer.getChildByName("answerBG");
                        background.graphics.setStrokeStyle(3).beginStroke("#0099FF")//.beginFill("#003D66")
                            .beginLinearGradientFill(
                            ["#003152", "#003D66", "#003D66", "#003152"],
                            [0.1, 0.35, 0.65, 0.9],
                            0, 0, 0, 75)
                            .drawRoundRect(0, 0, 600, 75, 5).endStroke().endFill();
                        background.shadow = buttonShadow;
                    }
                }
            }
            catch (ex) {
                console.log("ERROR FROM highlightAnswer() :: " + ex);
            }
        }

        function highlightButton(tempContainer) {
            try {
                //console.log("tempContainer :: ");
                //console.log(tempContainer);

                switch (tempContainer.name) {
                    case "btnConfirm":
                        var background = tempContainer.getChildByName("BG");

                        var tweenFlash = new createjs.Tween.get(background, { override: false, loop: true })
                            .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 200, 50, 5).endStroke().endFill(), 500)
                            .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#000080").drawRoundRect(0, 0, 200, 50, 5).endStroke().endFill(), 500);

                        break;
                    case "conControls":
                        //if (gameState.isEndingReady == true)

                        var btnAddMember = tempContainer.getChildByName("btnAddMember");
                        var background = btnAddMember.getChildByName("BG");

                        var tweenFlash = new createjs.Tween.get(background, { override: false, loop: true })
                            .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 350, 50, 25).endStroke().endFill(), 500)
                            .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#000080").drawRoundRect(0, 0, 350, 50, 25).endStroke().endFill(), 500);

                        break;
                    case "viewBand":
                        var endGame = tempContainer.getChildByName("endGame");
                        var background = endGame.getChildByName("BG");

                        var tweenFlash = new createjs.Tween.get(background, { override: false, loop: true })
                            .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 150, 25, 5).endStroke().endFill(), 500)
                            .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#990000").drawRoundRect(0, 0, 150, 25, 5).endStroke().endFill(), 500);

                        break;
                    case "windowQuestions":
                        var button = tempContainer.getChildByName("btnNext");
                        var background = button.getChildByName("BG");

                        if (gameState.currentAnswer != null) {
                            var tweenFlash = new createjs.Tween.get(background, { override: false, loop: true })
                                .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#000000").drawRoundRect(0, 0, 150, 50, 5).endStroke().endFill(), 500)
                                .to(background.graphics.setStrokeStyle(3).beginStroke("#0099FF").beginFill("#000080").drawRoundRect(0, 0, 150, 50, 5).endStroke().endFill(), 500);
                        }
                        break;
                }
            }
            catch (ex) {
                console.log("ERROR FROM highlightButton() :: " + ex);
            }
        }

        function highlightCreature() {
            try {
                for (var i = 0; i <= gameState.arrSelection.length - 1; ++i) {
                    var tempCreature = gameState.arrSelection[i];

                    if (gameState.currentSelection.name == tempCreature.name) {
                        //console.log("SHADOW");
                        tempCreature.shadow = highlightShadow;
                    }
                    else {
                        //console.log("NO SHADOW");
                        tempCreature.shadow = null;
                    }
                }
            }
            catch (ex) {
                console.log("ERROR FROM highlightCreature() :: " + ex);
            }
        }

        function newSpriteTesting() {
            try {
                //console.log("HELLO FROM newSpriteTesting :: ");
                // ***************************************************************************
                // USING THIS TO TEST SPRITESHEETS BEFORE PLACING IN THE GAME
                var _conBandStage = view.getChildByName("conBandStage");

                var tempCreature = new createjs.Bitmap(resourceLoader.getResult("pingPongCow"));
                var tempCreature = new createjs.Container();
                tempCreature.x = 200;
                tempCreature.y = 500;

                tempCreature.scaleX = 1.0;
                tempCreature.scaleY = 1.0;

                // *******************************************************
                // COPY INTO getCreature() AND getCreatureNew()
                // BE SURE TO PLACE IT INTO A NEW SWITCH CASE SHARING THE SAME NAME
                var speed = 0.2;
                var data = {
                    images: [resourceLoader.getResult("turntableCow")],
                    frames: {
                        width: 300, height: 300, frames: 18,
                        regX: 300 / 2,
                        regY: 300 / 2,
                    },
                    animations: {
                        idle: [0],
                        first: {
                            frames: [0, 1, 2, 3, 4, 5],
                            next: "idle",
                            speed: speed,
                        },
                        second: {
                            frames: [6, 7, 8, 9, 10, 11, 10, 9, 8, 7, 6],
                            next: "idle",
                            speed: speed,
                        },
                        third: {
                            frames: [12, 13, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17, 16, 15, 14, 15, 16, 17],
                            next: "idle",
                            speed: speed,
                        },
                    },
                };
                // *******************************************************

                var spriteSheet = new createjs.SpriteSheet(data);
                var _tempCreature = new createjs.Sprite(spriteSheet, "idle");
                tempCreature.soundInstance = gameState.audioClips["scratch"];

                tempCreature.addChild(_tempCreature);

                tempCreature.addEventListener("click", function () {
                    tempCreature.soundInstance.play({ loop: -1, volume: 1.0 });
                    // *******************************************************
                    // THIS NEES TO BE ADDED INTO THE ANIMATION CREATURE
                    // ALSO WITHIN ITS OWN SWITCH CASE
                    tempCreature = createjs.Tween.get(_tempCreature, { override: true, loop: -1 })
                        .call(_tempCreature.gotoAndPlay, ["third"], _tempCreature)
                        .wait(1000)
                        .call(_tempCreature.gotoAndPlay, ["second"], _tempCreature)
                        .wait(1000)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300)
                        .call(_tempCreature.gotoAndPlay, ["first"], _tempCreature)
                        .wait(300);
                    // *******************************************************
                });

                //creatureControls(tempCreature);
                _conBandStage.addChild(tempCreature);
                // **************************************************************************** 
            }
            catch (ex) {
                console.log("ERROR FROM newSpriteTesting() :: " + ex);
            }
        }

        function playAllTracks(_myTracks) {
            try {
                for (var i = 0; i < _myTracks.length; i++) {
                    var tempSound = _myTracks[i];
                    var myInstance = gameState.audioClips[tempSound.id];

                    var myCell = view.getChildByName("conControl").getChildByName(tempSound.id).getChildByName(tempSound.id);
                    var playButton = myCell.getChildByName("btnPlay");

                    //console.log("playState BEFORE IF :: " + myInstance.playState);
                    if (!myInstance.playState || !(myInstance.playState == "playSucceeded")) {
                        myInstance.play({ loop: -1 });
                        playButton.image = resourceLoader.getResult("stop_button");
                    }
                    else {
                        myInstance.stop();
                        playButton.image = resourceLoader.getResult("start_button");
                    }
                    //console.log("playState AFTER IF :: " + myInstance.playState);
                }
            }
            catch (ex) {
                console.log("ERROR FROM playAllTracks() :: " + ex);
            }
        }

        function readyEnding() {
            try {
                //console.log("HELLO FROM readyEnding() :: ");
                var conControls = view.getChildByName("conControls");
                var btnAddMember = conControls.getChildByName("btnAddMember");

                var tweenButtonEnding = new createjs.Tween.get(btnAddMember, { override: true, loop: true })
                    .to({ scaleX: 1.1, scaleY: 1.1 }, 500)
                    .to({ scaleX: 1.0, scaleY: 1.0 }, 500);

                function handleChange(event) {
                    var tempFilter = colorFilters[1];
                    btnAddMember.filters = [tempFilter];
                    btnAddMember.cache(-50, -50, 100, 100);
                }

            } catch (ex) {
                console.log("ERROR FROM readyEnding() :: " + ex);
            }
        }

        function removeStageLights() {
            try {
                //console.log("HELLO FROM removeStageLights() :: ");
                var leftLightBeam = gameState.stageLights[0];
                var centerLightBeam = gameState.stageLights[1];
                var rightLightBeam = gameState.stageLights[2];

                createjs.Tween.removeTweens(leftLightBeam);
                createjs.Tween.removeTweens(centerLightBeam);
                createjs.Tween.removeTweens(rightLightBeam);

                gameState.stageLights = [];

                view.removeChild(leftLightBeam);
                view.removeChild(centerLightBeam);
                view.removeChild(rightLightBeam);

            } catch (ex) {
                console.log("ERROR FROM removeStageLights() :: " + ex);
            }
        }

        function roundCleanUp() {
            try {
                var _conBandStage = bandView.getChildByName("conBandStage")
                gameState.usedQuestions.push(gameState.currentQuestion);

                // Stop all music and animations
                arrSoundEffects = [];
                masterSound.stop();
                createjs.Tween.removeAllTweens();

                // Restart all myBand tracks and animations
                for (var i = 0; i < gameState.myBand.length; i++) {
                    var myCritter = gameState.myBand[i];
                    myCritter.soundInstance.play({ loop: -1 }); //, offset: 1000, startTime: 1000, duration: 10000
                    animateCreature(myCritter);
                }

                //if (!soundEffect.getMute()) {
                //    soundEffect = createjs.Sound.play("crickets", { loop: -1, volume: 0.25 });
                //    soundEffect.name = "crickets";
                //    arrSoundEffects.push(soundEffect);
                //}

                // Round Clean Up
                gameState.currentAnswer = null;
                gameState.currentQuestion = null;
                gameState.currentSelection = null;
                gameState.isRunning = false;
                gameState.isQuestionComplete = false;

                _conBandStage.removeChild(windowQuestion);
                windowQuestion = null;

                updateInstructionPanel();
                getGameProgress();

                // Bug fix for flashing button (AddMember) issue
                var _conControls = view.getChildByName("conControls");
                var _btnMember = _conControls.getChildByName("btnAddMember");
                _conControls.removeChild(_btnMember);

                var btnAddMember = helpers.addMember();
                btnAddMember.name = "btnAddMember";
                btnAddMember.x = 400
                btnAddMember.y = 5

                _conControls.addChild(btnAddMember);

                highlightButton(_conControls); // Button Flash for new round
            }
            catch (ex) {
                console.log("ERROR FROM roundCleanUp() :: " + ex);
            }
        }

        function selectMusicTracks() {
            try {
                //console.log("Hello from selectMusicTracks()");
                //gameState.selectedTracks = Math.floor(Math.random() * (gameState.totalSetsOfTracks));
                //gameState.selectedTracks = 0; // Hardcoded to test SPECIFIC sound tracks
                var selectedTracks = gameState.gameTracks[gameState.selectedTracks];

                switch (selectedTracks) {
                    case "original":
                        //console.log("original :: ");
                        //console.log(gameState.sounds);
                        setAudioClips(gameState.sounds);
                        break;
                    case "jazzyJay":
                        //console.log("jazzyJay :: ");
                        //console.log(gameState.soundsJazzyJay);
                        setAudioClips(gameState.soundsJazzyJay);
                        break;
                }
            } catch (ex) {
                console.log("ERROR FROM selectMusicTracks() :: " + ex);
            }
        }

        function setAudioClips(_myTracks) {
            try {
                //console.log("HELLO FROM setAudioClips() :: ");
                for (var i = 0; i < _myTracks.length; ++i) {
                    var tempSound = _myTracks[i];
                    var mySound = createjs.Sound.createInstance(tempSound.id, { loop: -1 });
                    gameState.audioClips[tempSound.id] = mySound;
                }
            }
            catch (ex) {
                console.log("ERROR FROM setAudioClips() :: " + ex);
            }
        }

        function showCorrectAnswer() {
            try {
                var _windowQuestions = windowQuestion;
                var tempContainerAnswers = _windowQuestions.getChildByName("conAnswers");

                for (var i = 0; i < tempContainerAnswers.children.length; ++i) {
                    var tempAnswer = tempContainerAnswers.getChildByName("Answer_" + i);
                    //var text = tempAnswer.getChildByName("txtAnswer").text;
                    var answer = gameState.currentQuestion.Answers[i];
                    var background = tempAnswer.getChildByName("answerBG");

                    if (answer.Text == gameState.currentAnswer.Text) {
                        background.graphics.setStrokeStyle(3).beginStroke("#FFFF00").beginFill("#003D66").drawRoundRect(0, 0, 600, 75, 5).endStroke().endFill();
                        background.cursor = "pointer";
                    }
                    if (answer.IsCorrect) {
                        background.graphics.setStrokeStyle(3).beginStroke("#00CC00").beginFill("#003D66").drawRoundRect(0, 0, 600, 75, 5).endStroke().endFill();
                        background.cursor = "pointer";
                    }

                }
            } catch (ex) {
                console.log("ERROR FROM showCorrectAnswer() :: " + ex);
            }
        }

        function showFeedbackWarning(isAnswerSelected) {
            try {
                //var _windowQuestions = windowQuestion;
                var _conFeedback = windowQuestion.getChildByName("conFeedback");
                var background = _conFeedback.getChildByName("bgFeedback");
                var txtFeedback = _conFeedback.getChildByName("txtFeedback");

                if (isAnswerSelected) {
                    background.graphics.setStrokeStyle(3).beginStroke("#29ABE2")//.beginFill("#4F5570")
                        .beginLinearGradientFill(
                        ["#333333", "#666666", "#333333"],
                        [0.1, 0.5, 0.9],
                        0, 0, 0, 75)
                        .drawRoundRect(0, 0, 500, 75, 5).endStroke().endFill();
                    txtFeedback.text = gameState.currentQuestion.Feedback;
                    txtFeedback.color = "#29ABE2";
                    _conFeedback.visible = true;
                }
                else {
                    background.graphics.setStrokeStyle(3).beginStroke("#29ABE2")//.beginFill("#4F5570")
                        .beginLinearGradientFill(
                        ["#333333", "#666666", "#333333"],
                        [0.1, 0.5, 0.9],
                        0, 0, 0, 75)
                        .drawRoundRect(0, 0, 500, 75, 5).endStroke().endFill();
                    txtFeedback.text = "Please select an answer before clicking the next button.";
                    txtFeedback.color = "#29ABE2";
                    _conFeedback.visible = true;
                }

                if ((txtFeedback.text) && (txtFeedback.text.length > 0)) {
                    if (txtFeedback.text.length < 50) {
                        txtFeedback.font = "16pt Arial Black";
                        txtFeedback.y = 40;
                    } else if (txtFeedback.text.length < 100) {
                        txtFeedback.font = "14pt Arial Black";
                        txtFeedback.y = 30;
                    } else if (txtFeedback.text.length < 150) {
                        txtFeedback.font = "12pt Arial Black";
                        txtFeedback.y = 25;
                    } else {
                        txtFeedback.font = "10pt Arial Black";
                        txtFeedback.y = 20;
                    }
                }
                else {
                    _conFeedback.visible = false;
                    return;
                }
            } catch (ex) {
                console.log("ERROR FROM showFeedbackWarning() :: " + ex);
            }
        }

        function showTime() {
            try {
                //console.log("HELLO FROM showTime() :: ");
                var _conControls = view.getChildByName("conControls");
                var _conText = _conControls.getChildByName("conText");
                var txtInstructions = _conText.getChildByName("txtInstructions");
                txtInstructions.text = "SHOW TIME...";

                var _UFO = getUFO();
                _UFO.x = originalWidth / 2;
                _UFO.y = -200;

                var tweenUFO = createjs.Tween.get(_UFO)
                    .wait(1000).to({ y: -30 }, 1500 * tweenMultiplier);

                var blackOut = new createjs.Shape();
                blackOut.graphics.setStrokeStyle(1).beginStroke("#000000").beginFill("#000000").drawRect(0, 0, originalWidth, originalHeight).endStroke().endFill();
                blackOut.alpha = 0.0;
                view.addChild(blackOut);

                getStageLights();
                tweenblackOut = new createjs.Tween.get(blackOut)
                    .wait(1000)
                    .to({ alpha: 0.5 }, 3000 * tweenMultiplier);

                var conControls = view.getChildByName("conControls");
                var tweenControls = createjs.Tween.get(conControls).to({ y: 850, alpha: 0.0 }, 1000 * tweenMultiplier);

                var _conBandStage = view.getChildByName("conBandStage");
                var bgGrass = _conBandStage.getChildByName("bgGrass");
                var tweenGrass = createjs.Tween.get(bgGrass).to({ y: 850, alpha: 0.0 });

                var tweenStage = createjs.Tween.get(_conBandStage).to({ y: -200 }, 1000 * tweenMultiplier);

                var endGame = helpers.endGame();
                endGame.name = "endGame";
                endGame.x = originalWidth / 2;
                endGame.y = 50;

                var tweenEndGame = createjs.Tween.get(endGame, { override: true, loop: -1 })
                    .call(highlightButton, [view], endGame)
                    .wait(1000)
                    .call(stageLighting);

                endGame.addEventListener("click", function () {
                    if (isLmsConnected) {
                        console.log("end game function submit scorm")
                        ScormHelper.cmi.successStatus(ScormHelper.successStatus.passed);
                        ScormHelper.cmi.completionStatus(ScormHelper.completionStatus.completed);
                    }
                    gameState.endGame = true;
                    createjs.Tween.removeTweens(tweenEndGame);
                    finishGame();

                });

                view.addChild(_UFO, endGame);
            } catch (ex) {
                console.log("ERROR FROM showTime() :: " + ex);
            }
        }

        function skipTweens() {
            try {
                console.log("Hello from skipTweens() ::");
            } catch (ex) {
                console.log("ERROR FROM skipTweens() :: " + ex);
            }
        }

        function sortArrOfObjectsByParam(arrToSort /* array */, strObjParamToSortBy /* string */, sortAscending /* bool(optional, defaults to true) */) {
            if (sortAscending == undefined) sortAscending = true;  // default to true

            if (sortAscending) {
                arrToSort.sort(function (a, b) {
                    return a[strObjParamToSortBy] > b[strObjParamToSortBy];
                });
            }
            else {
                arrToSort.sort(function (a, b) {
                    return a[strObjParamToSortBy] < b[strObjParamToSortBy];
                });
            }
        }

        function showView(_view) {
            try {
                if (self.currentView) {
                    self.previousView = self.currentView;
                    self.stage.removeChild(self.currentView);
                }
                else {
                    self.previousView = null;
                }

                if (_view) {
                    self.stage.addChild(_view);
                    self.currentView = _view;
                }
                else {
                    self.currentView = null;
                }

                view = self.currentView;
                self.stage.update();
            }
            catch (ex) {
                console.log("ERROR FROM showView() :: " + ex);
            }
        }

        function shuffle(array) {
            try {
                var currentIndex = array.length, temporaryValue, randomIndex;

                // While there remain elements to shuffle...
                while (0 !== currentIndex) {
                    // Pick a remaining element...
                    randomIndex = Math.floor(Math.random() * currentIndex);
                    currentIndex -= 1;

                    // And swap it with the current element.
                    temporaryValue = array[currentIndex];
                    array[currentIndex] = array[randomIndex];
                    array[randomIndex] = temporaryValue;
                }

                return array;
            }
            catch (ex) {
                console.log("ERROR FROM shuffle() :: " + ex);
            }
        }

        function stageLighting() {
            try {
                //console.log("Hello from stageLighting()");
                if (gameState.endGame == true) { return; }

                setTimeout(function () {
                    // RANDOM LIGHT FORMATION
                    do {
                        var randomUdder = Math.floor(Math.random() * 5); // Considering 5 here, 1-3 = individual lights, 4 = outer lights, 5 = all
                    } while (lastLightFormation == randomUdder)
                    lastLightFormation = randomUdder;

                    // RANDOM COLOR FILTER
                    do {
                        var randomColor = Math.floor(Math.random() * colorFilters.length);
                    } while (lastLightColor == randomColor)
                    lastLightColor = randomColor;

                    switch (randomUdder) {
                        case 0:
                            // Left
                            var tempTween = gameState.stageLights[randomUdder];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0, rotation: -20, skewX: -40 })
                                .to({ rotation: 10, skewX: 30 }, 500)
                                .to({ alpha: 0.0 }, 500)
                                .to({ skewX: 25 })
                                .addEventListener("change", handleChange);
                            break;
                        case 1:
                            // Center
                            var tempTween = gameState.stageLights[randomUdder];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0 })
                                .to({ rotation: 20, skewX: 30 }, 250)
                                .to({ rotation: 0, scaleY: 1.25, skewX: 0 }, 250)
                                .to({ rotation: -20, scaleY: 1.5, skewX: -30 }, 250)
                                .to({ alpha: 0.0 }, 500)
                                .addEventListener("change", handleChange);
                            break;
                        case 2:
                            // Right
                            var tempTween = gameState.stageLights[randomUdder];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0, rotation: 20, skewX: 40 })
                                .to({ rotation: -10, skewX: -30 }, 500)
                                .to({ alpha: 0.0 }, 500)
                                .to({ skewX: -25 })
                                .addEventListener("change", handleChange);
                            break;
                        case 3:
                            // Left and Right
                            var tempTween = gameState.stageLights[0];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0 })
                                .to({ rotation: -20, skewX: -40 }, 500)
                                .to({ alpha: 0.0 }, 500)
                                .to({ rotation: 0, skewX: 25 })
                                .addEventListener("change", handleChange);

                            var tempTween = gameState.stageLights[2];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0 })
                                .to({ rotation: 20, skewX: 40 }, 500)
                                .to({ alpha: 0.0 }, 500)
                                .to({ skewX: -25, rotation: 0 })
                                .to({ rotation: 0, skewX: -25 })
                                .addEventListener("change", handleChange);
                            break;
                        case 4:
                            // All Lights
                            var tempTween = gameState.stageLights[0];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0, scaleX: 2.0, skewX: 25, x: 320, rotation: 0 })
                                .to({ alpha: 0.0 }, 1000)
                                .to({ scaleX: 1.5, x: 320 }).wait(500)
                                .addEventListener("change", handleChange);

                            var tempTween = gameState.stageLights[1];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0, scaleX: 2.0, skewX: 0, x: 400, rotation: 0 })
                                .to({ alpha: 0.0 }, 1000)
                                .to({ scaleX: 1.5, x: 400 }).wait(500)
                                .addEventListener("change", handleChange);

                            var tempTween = gameState.stageLights[2];
                            createjs.Tween.get(tempTween, { override: true })
                                .to({ alpha: 1.0, scaleX: 2.0, skewX: -25, x: 485, rotation: 0 })
                                .to({ alpha: 0.0 }, 1000)
                                .to({ scaleX: 1.5, x: 485 }).wait(500)
                                .addEventListener("change", handleChange);
                            break;
                    }

                    function handleChange(event) {
                        var tempFilter = colorFilters[randomColor];
                        tempTween.filters = [tempFilter];
                        tempTween.cache(0, 0, 300, 300);
                    }
                }, 1500)
            } catch (ex) {
                console.log("ERROR FROM stageLighting() :: " + ex);
            }
        }

        $(window).bind('beforeunload', function () {
            submitScore(gameState.score)
        })


        function submitScore(score) {
            if (gameState.submitedScore || score == 0)
                return false;
            gameState.submitedScore = true;

            try {
                var url = gameData.leaderboardUrl;

                if (url) {

                    var data = {
                        gameId: gameData.id,
                        score: score
                    };

                    $.ajax(url, {
                        type: "POST",
                        data: data,
                        success: function (x) {

                        },
                        error: function (x, y, z) {

                        }
                    });
                }
            }
            catch (ex) {
                console.log("ERROR FROM submitScore() :: " + ex);
            }
        }

        function tickHandler(event) {
            try {
                self.stage.update();

                if (gameState.isTimerRunning) {
                    var currentTime = (new Date()).getTime();
                    gameState.currentTime = ((currentTime - gameState.startTime) / 1000).toFixed(2);
                }
            }
            catch (ex) {
                console.log("ERROR FROM tickHandler() :: " + ex);
            }
        }

        function updateInstructionPanel() {
            try {
                //console.log("HELLO from updateInstructionPanel() :: ");
                var _conControls = view.getChildByName("conControls");
                var _conText = _conControls.getChildByName("conText");
                var txtInstructions = _conText.getChildByName("txtInstructions");

                do { // randomly select a NEW hint to display
                    var randomIndex = Math.floor(Math.random() * gameHints.length);
                    var selectedHint = gameHints[randomIndex];
                } while (selectedHint == lastHint)

                txtInstructions.text = selectedHint;

                if (txtInstructions.text.length < 50) {
                    txtInstructions.font = "14pt Arial Black";
                    txtInstructions.y = 55;
                } else if (txtInstructions.text.length < 100) {
                    txtInstructions.font = "13pt Arial Black";
                    txtInstructions.y = 40;
                } else if (txtInstructions.text.length < 150) {
                    txtInstructions.font = "12pt Arial Black";
                    txtInstructions.y = 35;
                } else if (txtInstructions.text.length < 200) {
                    txtInstructions.font = "10pt Arial Black";
                    txtInstructions.y = 45;
                } else {
                    txtInstructions.font = "8pt Arial Black";
                    txtInstructions.y = 35;
                }
                lastHint = txtInstructions.text;

                // BAND COUNT
                var _conBandCount = _conControls.getChildByName("conBandCount");
                var txtBandCount = _conBandCount.getChildByName("txtBandCount");
                txtBandCount.text = "Band Count : " + gameState.myBand.length;

                if ((gameState.maxMembers - gameState.myBand.length) <= 1) {
                    txtBandCount.color = "#FF0000";
                    if ((gameState.maxMembers - gameState.myBand.length) == 1) {
                        txtInstructions.font = "16pt Arial";
                        txtInstructions.y = 55;
                        txtInstructions.text = "YOUR BAND ONLY HAS ONE MORE POSITION AVAILABLE";
                    }
                } else {
                    txtBandCount.color = "#29ABE2";
                }

                // SCORE COUNT
                var _conScore = _conControls.getChildByName("conScore");
                var txtScore = _conScore.getChildByName("txtScore");
                txtScore.text = "Score : " + gameState.score;
            }
            catch (ex) {
                console.log("ERROR FROM updateInstructionPanel() :: " + ex);
            }
        }

    }

    return Game;
})(createjs);

(function () {

    var stageMouseDownHandler = createjs.Stage.prototype._handlePointerDown;
    var stageMouseUpHandler = createjs.Stage.prototype._handlePointerUp;
    var mouseInterval = {};
    var MIN_CLICK_TIME = 20;

    if (navigator.userAgent.indexOf("Android") > -1) {
        createjs.Stage.prototype._handlePointerDown = function (event) {
            var lastTime = mouseInterval.mousedown;
            var now = new Date().getTime(); // Slower than Date.now(), but compatible with IE8 and others.
            if (lastTime == null || now - lastTime > MIN_CLICK_TIME) {
                mouseInterval.mousedown = now;
                stageMouseDownHandler.call(this, event);
            }
        }
        createjs.Stage.prototype._handlePointerUp = function (event) {
            var lastTime = mouseInterval.mouseup;
            var now = new Date().getTime();
            if (lastTime == null || now - lastTime > MIN_CLICK_TIME) {
                mouseInterval.mouseup = now;
                stageMouseUpHandler.call(this, event);
            }
        }
    }

}())