﻿/// <reference path="http://code.createjs.com/createjs-2013.12.12.min.js" />
/// <reference path="../../../Content/GamesDownloadTemplate/lib/ScormHelper.js" />
var Game = Game || (function (createjs) {
    function Game(canvas, gameData) {
        var haveSignalR = false
        tryingToReconnect = false;
        if ($.connection && $.connection.gameHub) {
            var theHub = $.connection.gameHub;
            theHub.state.wiscID = gameData.id;
            theHub.state.displayName = "";
            haveSignalR = true;
        }
        else
            var theHub = { client: {}, server: {}, connection: { disconnected: function () { } } };


        var gameBoard = null;
        var self = this;
        var htmlElements = [];
        self.stage = new createjs.Stage(canvas);
        createjs.Touch.enable(self.stage, false, true);
        self.stage.enableMouseOver(10);
        var gameTimer = 108000;
        timerOn = false;
        var Timer = new createjs.Text("Time until game expires: ", "14px Arial bold", "black");
        Timer.x = 10;
        Timer.y = 260;
        var standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);
        createjs.Ticker.setFPS(60);
        createjs.Ticker.addEventListener("tick", tickHandler);
        var startTime = createjs.Ticker.getTime(true);
        function tickHandler(event) {
            UpdateTimer();
            self.stage.update();
        }

        $(window).resize(function () {
            for (var j = 0; j < htmlElements.length; j++) {
                htmlElements[j].setPosition();
            }
        });
        function UpdateTimer() {
            //30 mins to exp

            var theTime = (108000 * 100 - (createjs.Ticker.getTime(true) - startTime))


            var Minutes = Math.floor(theTime / 360000);
            theTime -= Minutes * (360000);

            var Seconds = Math.floor(theTime / 6000);
            theTime -= Seconds * (6000);

            var TimeStr = LeadingZero(Minutes) + ":" + LeadingZero(Seconds);

            Timer.text = "Time until game expires: " + TimeStr;
        }

        function LeadingZero(Time) {
            return (Time < 10) ? "0" + Time : +Time;
        }

        var isLmsConnected = false;
        var currentLmsInteraction = null;

        if (typeof ScormHelper !== 'undefined') {
            isLmsConnected = ScormHelper.initialize();
        }

        var quit;

        if (isLmsConnected) {
            quit = function () {
                ScormHelper.cmi.exit("");
                ScormHelper.adl.nav.request("exitAll");
                ScormHelper.terminate();
            }
        }
        else {
            quit = function () {
                window.location = "http://www.wisc-online.com";
            }
        }

        // show a loading screen initially.
        showView((function () {
            var container = new createjs.Container();

            var loadingText = new createjs.Text("Loading...", "24px Arial", "green")
            loadingText.x = self.stage.canvas.width / 2;
            loadingText.y = self.stage.canvas.height / 2;
            loadingText.textAlign = "center";
            loadingText.textBaseline = "middle";

            var loadingShape = new createjs.Shape();
            loadingShape.x = self.stage.canvas.width / 2 - 100;
            loadingShape.y = loadingText.y + 30;
            loadingShape.graphics.beginFill("red").drawRoundRect(0, 0, 200, 20, 3).endFill();
            loadingShape.scaleX = 0;

            createjs.Tween.get(loadingShape, { loop: true }).to({ scaleX: 1.0 }, 1000, createjs.Ease.quartIn)
                .call(function () { loadingShape.regX = 200; loadingShape.x = self.stage.canvas.width / 2 + 100 })
                .to({ scaleX: 0 }, 750, createjs.Ease.quartOut)
                .call(function () { loadingShape.regX = 0; loadingShape.x = self.stage.canvas.width / 2 - 100 });



            container.addChild(loadingText, loadingShape);
            container.name = "loadingScreen";
            return container;
        })());

        var resourceLoader = new createjs.LoadQueue(false);

        resourceLoader.addEventListener("complete", function (event) {
            showTitleView();
        });

        // setup the resources to be loaded.
        (function () {
            var assetsDir = gameData.assetsPath || "";

            var assets = [
                { id: "titleBackground", src: assetsDir + "title_background.jpg" },
                { id: "startButton", src: assetsDir + "start_button.png" },
                { id: "background", src: assetsDir + "plain_background.jpg" },
                { id: "TimeOut_Instructions", src: assetsDir + "TimeOut_Instructions.png" },
                { id: "instructions_background", src: assetsDir + "instructions_background.png" },
                { id: "instructions_question", src: assetsDir + "instructions_question.png" },
                { id: "buttonBackground", src: assetsDir + "buttonBackground.png" },
                { id: "playerListBackground", src: assetsDir + "feedbackBox.png" },
                { id: "buttonBackground", src: assetsDir + "buttonBackground.png" },
                { id: "clockBack", src: assetsDir + "clockBack.png" },
                { id: "clockHand", src: assetsDir + "clockHand.png" },
                { id: "Happy", src: assetsDir + "happyFace.jpg" },
                { id: "infoBtn", src: assetsDir + "infoBtn.png" },
                { id: "infoBtnMark", src: assetsDir + "infoBtnWithMark.png" },
                { id: "nextBtn", src: assetsDir + "next-tryAgainBtn.png" },
                { id: "Sad", src: assetsDir + "sadFace.jpg" },
                { id: "backGround", src: assetsDir + "timeOutGameBackground.jpg" },
                { id: "musicOn", src: assetsDir + "musicOn.png" },
                { id: "musicOff", src: assetsDir + "musicOff.png" },
            ];

            createjs.Sound.registerSound({ src: assetsDir + "ButtonClick.mp3", id: "clickSound" });
            createjs.Sound.registerSound({ src: assetsDir + "timeOutTimer2.mp3", id: "timerBuild" });
            createjs.Sound.registerSound({ src: assetsDir + "correctBell.mp3", id: "correctBell" });
            createjs.Sound.registerSound({ src: assetsDir + "Wisc_Buzzer.mp3", id: "Wisc_Buzzer" });

            resourceLoader.loadManifest(assets);

        })();

        // Randomize Questions/Answers?
        if (gameData.RandomizeQuestions) {
            gameData.Questions = shuffle(gameData.Questions);
        }

        for (var i = 0; i < gameData.Questions.length; i++) {
            if (gameData.Questions[i].RandomizeAnswers) {
                gameData.Questions[i].Answers = shuffle(gameData.Questions[i].Answers);
            }
        }

        function shuffle(array) {
            var currentIndex = array.length, temporaryValue, randomIndex;

            while (0 !== currentIndex) {
                randomIndex = Math.floor(Math.random() * currentIndex);
                currentIndex -= 1;
                temporaryValue = array[currentIndex];
                array[currentIndex] = array[randomIndex];
                array[randomIndex] = temporaryValue;
            }
            return array;
        }


        var gameState = {
            joinSuccess: false,
            isHost: false,
            gameOn: false,
            musicOn: true,
            gamePass: "",
            score: 0,
            displayName: gameData.UserName ? gameData.UserName : "",
            questionsResults: [],
        };

        var clickSound = createjs.Sound.createInstance("clickSound");
        clickSound.volume = clickSound.volume * 0.40;
        var timerBuild = createjs.Sound.createInstance("timerBuild");
        timerBuild.volume = timerBuild.volume * 0.35;
        var correctBell = createjs.Sound.createInstance("correctBell");
        correctBell.volume = correctBell.volume * 0.40;
        var Wisc_Buzzer = createjs.Sound.createInstance("Wisc_Buzzer");
        Wisc_Buzzer.volume = Wisc_Buzzer.volume * 0.30;

        var questionMark = new createjs.Bitmap(resourceLoader.getResult("instructions_question"));
        var instructionsView = null;

        function showTitleView() {
            var view = new createjs.Container();

            var titleText = new createjs.Text(gameData.Title, "36px Arial Black", "#2f6765");
            //titleText.shadow = new createjs.Shadow("gray", 1, 1, 3);
            titleText.lineWidth = 780;
            titleText.x = 10;
            titleText.y = 10;

            var descriptionText = new createjs.Text(gameData.Description, "22px Bold Arial", "dark gray");
            descriptionText.lineWidth = 780;
            descriptionText.x = 10;
            descriptionText.y = 100;

            var startButton = new createjs.Bitmap(resourceLoader.getResult("startButton"));
            //startButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
            startButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
            startButton.cursor = 'pointer';
            startButton.regX = 50;
            startButton.regY = 50;
            startButton.x = 725;
            startButton.y = 525;

            view.addChild(new createjs.Bitmap(resourceLoader.getResult("titleBackground")))
            view.addChild(startButton);
            view.addChild(descriptionText);
            view.addChild(titleText);




            startButton.addEventListener("click", function (event) {
                clickSound.play();

                if (haveSignalR) {
                    CreateGameSessionView();
                } else {
                    gameState.gameOn = true;
                    initializeGame();
                }

            });

            startButton.addEventListener("mouseover", function (event) {
                createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100).to({ scaleX: 1.0, scaleY: 1.0 }, 100).to({ scaleX: 1.0625, scaleY: 1.0625 }, 200);
            });

            startButton.addEventListener("mouseout", function (event) {
                createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0, scaleY: 1.0 }, 100);
            });

            var instructionsContainer = new createjs.Container();
            instructionsContainer.x = 0;
            instructionsContainer.y = 550;

            instructionsContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 50, 50));
            instructionsContainer.cursor = 'pointer';

            instructionsContainer.addChild(new createjs.Bitmap(resourceLoader.getResult("instructions_background")));
            instructionsContainer.addChild(new createjs.Bitmap(resourceLoader.getResult("instructions_question")));

            instructionsContainer.addEventListener("click", function () {
                clickSound.play();
                showView(getInstructionsView());
            });

            instructionsContainer.on("mouseover", handleInstructionsMouseOver);
            instructionsContainer.on("mouseout", handleInstructionsMouseOver);
            view.addChild(instructionsContainer);
            self.stage.addChild(view);

            showView(view);
        }
        function createButton(container, text, color, background, x, y, wide, height, font) {
            this.passedInContain = container;
            this.contain = new createjs.Container();
            container.addChild(this.contain);
            this.text = new createjs.Text(text, font ? font : "14px Arial Bold", color);
            this.background = new createjs.Bitmap(resourceLoader.getResult(background));
            this.background.scaleX = (wide / this.background.getBounds().width);
            this.background.scaleY = (height / this.background.getBounds().height);
            this.sx = this.background.scaleX; // orignals for tweening
            this.sy = this.background.scaleY;
            this.background.regX = this.background.getBounds().width / 2;
            this.background.regY = this.background.getBounds().height / 2;
            this.text.x = this.background.x = (wide / 2) + x;
            this.text.y = this.background.y = (height / 2) + y;
            this.text.textAlign = "center"
            this.text.regY = this.text.getBounds().height / 2;
            this.contain.addChild(this.background, this.text);
            this.click = false;
            this.contain.cursor = 'pointer';
            this.contain.hitArea = this.background;

            this.contain.on("mouseover", function (event) {
                createjs.Tween.get(this.background).to({ scaleX: this.sx + .0225, scaleY: this.sy + .0225 }, 70).to({ scaleX: this.sx + .02, scaleY: this.sy + .02 }, 100).to({ scaleX: this.sx + .04, scaleY: this.sy + .04 }, 200);
            }, this, false);

            this.contain.on("mouseout", function (event) {
                createjs.Tween.get(this.background).to({ scaleX: this.sx, scaleY: this.sy }, 100);
            }, this, false);
            this.contain.on("click", function () {

                if (typeof (this.click) == "function")
                    this.click();
            }, this, false);
        }
        function getParameterByName(name) {
            name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
            var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
                results = regex.exec(location.search);
            return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
        }

        function CreateGameSessionView() {
            var view = new createjs.Container();
            view.name = "theView";
            var background = new createjs.Bitmap(resourceLoader.getResult("background"));
            view.addChild(background);
            var pageText = new createjs.Text("Hosting a game will allow players to join a game with a shared link. If the host does not start the game within 30 minutes, the game will have to be recreated with a new password or link to be shared.  \n\nPlayers will only be able to join publicly available games.", "Bold 18px Arial ");
            pageText.x = 25;
            pageText.y = 25;
            pageText.lineWidth = 700;
            pageText.maxWidth = 700;

            $("#gameID").val(getParameterByName("sessionID"));

            this.passWord = new containerInput(view, "gameID", "Game Password:", getParameterByName("sessionID"), 400, 350);
            this.displayName = new containerInput(view, "displayName", "Display Name:", gameData.UserName, 400, 400);
            this.displayName.html.focus();

            theHub.connection.disconnected(function () {
                // alert("!!! You've been disconnected");
            });


            theHub.client.postToPlayerWindow = function (content, msg) {
                if (!document.getElementById('playerWindow')) {
                    var html = document.createElement('div');
                    html.id = 'playerWindow';
                    html.style.fontWeight = "bold";
                    html.style.fontSize = "16px";
                    html.style.height = '200px';
                    html.style.width = '500px';
                    html.style.backgroundColor = "#33CCFF";
                    html.style.position = "absolute";
                    html.style.top = 0;
                    html.style.left = 0;
                    html.style.padding = "5px";
                    html.innerHTML = content + msg;
                    document.body.appendChild(html);
                } else {
                    var html = document.getElementById('playerWindow');
                    html.innerHTML = html.innerHTML + "<br/>" + content + msg;
                }

                var playerControl = new createjs.DOMElement(html);
                playerControl.x = 200;
                playerControl.y = 300;

                view.addChild(playerControl);
            }


            var createGameButton = new createButton(view, "Host Game", "white", "buttonBackground", 100, 250, 170, 65, "bold 20px Arial");
            createGameButton.tag = this.passWord;
            createGameButton.click = function () {
                clickSound.play()
                gameState.gamePass = this.tag.html.value
                // Start the connection.
                theHub.state.displayName = "admin";
                theHub.connection.start().done(function () {

                    theHub.server.createSession(gameState.gamePass).done(function () {
                        // action moved to setJoinSuccess
                    });
                });
            }
            var PlaySingleButton = new createButton(view, "Play Single \nPlayer Game", "white", "buttonBackground", 200, 140, 170, 80, "bold 20px Arial");

            PlaySingleButton.click = function (e) {
                clickSound.play();
                gameState.gameOn = true;
                haveSignalR = false;
                initializeGame();
            }

            var JoinGameButton = new createButton(view, "Join Game", "white", "buttonBackground", 300, 250, 170, 65, "bold 20px Arial");
            JoinGameButton.click = function (e) {
                clickSound.play();
                gameState.gamePass = this.pass.html.value
                theHub.state.sessionID = gameState.gamePass
                gameState.displayName = this.name.html.value
                theHub.state.displayName = this.name.html.value;
                theHub.connection.start().done(function () {
                    theHub.server.joinGroup("")
                });
            }
            JoinGameButton.pass = this.passWord;
            JoinGameButton.name = this.displayName;

            theHub.connection.disconnected(function () {
                tryingToReconnect = false;

            });
            theHub.connection.reconnecting(function () {
                tryingToReconnect = true;
            });

            theHub.connection.reconnected(function () {
                tryingToReconnect = false;
                sendMessage({ Type: "clientReDisconnected" });
            });



            view.addChild(pageText);

            var instructionsContainer = new createjs.Container();
            instructionsContainer.x = 0;
            instructionsContainer.y = 550;

            instructionsContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 50, 50));
            instructionsContainer.cursor = 'pointer';
            instructionsContainer.addChild(new createjs.Bitmap(resourceLoader.getResult("instructions_background")));
            instructionsContainer.addChild(new createjs.Bitmap(resourceLoader.getResult("instructions_question")));
            instructionsContainer.addEventListener("click", function () {
                clickSound.play();
                showView(getInstructionsView());
                this.passWord.setVisible(false);
                this.displayName.setVisible(false);

            }, false, this);
            var instructionsView = null;

            instructionsContainer.on("mouseover", handleInstructionsMouseOver);
            instructionsContainer.on("mouseout", handleInstructionsMouseOver);

            view.addChild(instructionsContainer);
            showView(view);
        }

        function createInstructionsView() {
            var view = new createjs.Container();
            //var image = new createjs.Bitmap(resourceLoader.getResult("instructions"));
            var image = new createjs.Bitmap(resourceLoader.getResult("TimeOut_Instructions"));

            var hit = new createjs.Shape();
            var exitContainer = new createjs.Container();
            var exitBox = new createjs.Shape();

            exitContainer.x = 720;
            exitContainer.y = 555;
            var exitText = new createjs.Text("BACK", 'bold 18px Arial', "#fff");
            exitText.x = 8;
            exitText.y = 8;
            exitContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#7449AE").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke());
            hit.graphics.beginFill("#000").drawRect(0, 0, exitText.getMeasuredWidth(), exitText.getMeasuredHeight());
            exitBox.graphics.beginFill("#7449AE").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke();
            exitText.hitArea = hit;
            exitContainer.addChild(exitBox, exitText);
            //   var instructionsText = new createjs.Text("we need instructions on how to create a session and distribute the session to your users", "18px Arial", "#2f6765")

            view.addChild(image, exitContainer);//, 

            exitContainer.addEventListener("click", function (event) {
                clickSound.play();
                showView(self.previousView);
                if (this.passWord) {
                    this.passWord.setVisible(true);
                    this.displayName.setVisible(true);
                }
            }, false, this);

            return view;
        }

        self.previousView = null;
        self.currentView = null;
        function showView(view) {

            // TODO: add transition animation (fade)

            if (self.currentView) {
                self.stage.removeChild(self.currentView);
                self.previousView = self.currentView;
            }
            else {
                self.previousView = null;
            }

            if (view) {
                self.stage.addChild(view);
                self.currentView = view;
            }
            else {
                self.currentView = null;
            }
            var x = self.stage.getChildByName("loadingScreen");

            self.stage.removeChild(x);

            self.stage.update();
        };

        function getInstructionsView() {

            if (instructionsView == null) {
                instructionsView = createInstructionsView();
                instructionsView.name = "InstructionsView";
            }

            return instructionsView;
        }

        function handleInstructionsMouseOver(event) {
            if (event.type == "mouseover") {
                createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0625, scaleY: 1.0625 }, 50);
            }
            else {
                createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0, scaleY: 1.0 }, 50);
            }
        }
        function PopUpInfo(container, text, x, y, wide, closeOnClick) {
            this.contain = container;
            this.text = new createjs.Text(text, "14pt Arial bold");
            this.text.lineWidth = wide;
            this.text.x = x;
            this.text.y = y;
            this.bg = new createjs.Shape();
            this.bg.graphics.beginFill("white");
            this.bg.graphics.drawRoundRectComplex(this.text.x - 8, this.text.y - 4, this.text.getBounds().width + 30, this.text.getMeasuredHeight() + 8, 8, 0, 8, 8);
            this.bg.shadow = standardTextShadow;
            this.click = false;
            this.contain.addChild(this.bg, this.text);
            if (closeOnClick) {
                this.closeX = new createjs.Text("X", "14pt Arial bold");
                this.closeX.x = this.text.x + this.text.getBounds().width + 8;
                this.closeX.y = this.text.y - 4;
                this.closeBox = new createjs.Shape();
                this.closeBox.graphics.beginFill("LightGray");
                this.closeBox.graphics.drawRoundRectComplex(this.closeX.x - 1, this.closeX.y, this.closeX.getBounds().width + 2, this.closeX.getMeasuredHeight(), 0, 0, 0, 0);
                this.contain.addChild(this.closeBox, this.closeX);
                this.bg.on("click", function () {
                    if (typeof (this.click) == "function")
                        this.click();
                    this.contain.removeChild(this.text);
                    this.contain.removeChild(this.bg);
                    if (closeOnClick) {
                        this.contain.removeChild(this.closeX);
                        this.contain.removeChild(this.closeBox);
                    }
                }, this, false);
            }
        }
        function initializeGame() {
            addGameView();

            function addGameView() {
                self.stage.removeAllChildren();
                $("#gameID").hide();
                $("#displayName").hide();
                var GameView = new createjs.Container();
                var GameBackground = new createjs.Bitmap(resourceLoader.getResult("backGround"));
                GameView.addChild(GameBackground);
                addSoundControl(GameView);
                // here we will have the honeycomb trail and the question / answer area
                gameBoard = new GameBoard(GameView);
                gameBoard.init();
                if (!gameState.joinSuccess)
                    gameBoard.showNextQuestion();
                self.stage.addChild(GameView);
            }

            function GameBoard(container) {
                this.container = container;
                this.questions = gameData.Questions.slice();
                this.timer = new Clock(this);
                this.selectedAnswer = false;
                this.playerList = [];
                this.timerTween = createjs.Tween.get(this.timer.clockHand);
                this.questionsAsked = 0;
                gameState.score = 0;
                Object.defineProperty(this, "score", {
                    get: function () { return gameState.score; },
                    set: function (value) {
                        this.scoreText.text = value + ".";
                        gameState.score = value;
                    }
                });

                this.infoButton = new createjs.Bitmap(resourceLoader.getResult("infoBtnMark"));
                this.infoButtonContainer = new createjs.Container();
                this.infoButton.on("click", function () {
                    clickSound.play();
                    var info = new PopUpInfo(this.container, "Choose the correct answer. For more points answer questions quickly. You may change your answer while the clock is ticking.", 200, 400, 300, true);

                }, this, false, { action: "normal", obj: this.infoButton });

                this.infoButton.x = 660;
                this.infoButton.y = 545;
                this.infoButtonContainer.addChild(this.infoButton);
                this.container.addChild(this.infoButtonContainer);

                this.totalPoints = new createjs.Text(gameState.displayName + " \n TOTAL POINTS", "bold 19px Arial", "#868686");
                this.scoreText = new createjs.Text(this.score + ".", "bold 19px Arial", "#868686");
                this.scoreText.textAlign = this.totalPoints.textAlign = "center";
                this.scoreText.x = this.totalPoints.x = 677;
                this.totalPoints.y = 250;
                this.scoreText.y = 300;
                this.container.addChild(this.totalPoints, this.scoreText)

                this.leaderTxt = new createjs.Text("", "bold 19px Arial", "#868686");
                this.leaderTxt.textAlign = "center";
                this.leaderTxt.x = 677;
                this.leaderTxt.y = 340;
                this.container.addChild(this.leaderTxt);

                var _currentQuestion = -1;
                Object.defineProperty(this, "currentQuestion", {
                    get: function () { return _currentQuestion; },
                    set: function (value) {
                        if (_currentQuestion != -1)
                            this.container.removeChild(_currentQuestion.contain);
                        _currentQuestion = null;
                        this.questionsAsked++;
                        _currentQuestion = value;
                    }
                });

                this.init = function () {
                    // calculate point values
                }
                GameBoard.prototype.shoWaitForHost = function () {
                    this.waitContain = new createjs.Container();

                    this.waitlbl = new createjs.Text("Waiting for host to start game", "bold 30px Arial");
                    this.waitlbl.x = 100;
                    this.waitlbl.y = 130;
                    var bg = new createjs.Shape();
                    bg.graphics.beginFill("LightGray");
                    bg.graphics.drawRoundRect(90, 120, this.waitlbl.getBounds().width + 20, 50, 8);
                    this.waitContain.addChild(bg, this.waitlbl);
                    this.container.addChild(this.waitContain);
                }
                ///////////////////
                GameBoard.prototype.startGame = function () {
                    this.container.removeChild(this.waitContain)
                    gameState.gameOn = true;
                    this.showNextQuestion();
                }
                GameBoard.prototype.showNextQuestion = function () {
                    var selfme = this;
                    this.currentQuestion = new Question((this.questions.shift()), this);

                    this.updateLeaderText();

                    var landingSpot = new createjs.Container();
                    var Highlight = new createjs.Shape();
                    Highlight.graphics.beginFill("Khaki").drawRoundRect(40, 350, 500, 30, 8);

                    var HighLightlabel = new createjs.Text("Start Timer & Show Possible Answers", "18pt arial bold", "Black");
                    HighLightlabel.textAlign = "center";
                    HighLightlabel.x = 255;
                    HighLightlabel.y = 350;

                    Highlight.landingSpot = landingSpot;
                    HighLightlabel.landingSpot = landingSpot;
                    landingSpot.addChild(Highlight, HighLightlabel);
                    container.addChild(landingSpot);


                    landingSpot.addEventListener("click", function () {
                        container.removeChild(landingSpot);
                        selfme.startTimerForGamePaused();
                        selfme.currentQuestion.showAnswers();
                    });

                }
                GameBoard.prototype.startTimerForGamePaused = function () {

                    if (gameState.gameOn) {
                        timerBuild.play({ offset: 0, loop: 0, pan: 0 });
                        this.timerTween._steps.length = 0;
                        this.timerTween = createjs.Tween.get(this.timer.clockHand, { override: true });
                        this.timerTween._paused = false;
                        this.timerTween.to({ rotation: 1 }, 1);
                        this.timerTween.to({ rotation: 360 }, 10000).call(function () {
                            if (currentLmsInteraction) {
                                currentLmsInteraction.result = ScormHelper.results.incorrect;
                                currentLmsInteraction.learnerResponse = null;
                                currentLmsInteraction.save();
                                currentLmsInteraction = null;
                            }
                            this.currentQuestion.showResults(false, false)
                        }, this, this);
                    }

                }
                GameBoard.prototype.updateLeaderText = function () {
                    this.leaderTxt.text = "Leader Board \n";
                    for (var j = 0; j < this.playerList.length && j < 3; j++)
                        this.leaderTxt.text = this.leaderTxt.text + this.playerList[j].displayName + " " + this.playerList[j].score + "\n";

                    this.leaderTxt.text = this.leaderTxt.text + "\n \n Question \n" + (gameData.Questions.length - gameBoard.questions.length) + " / " + (gameData.Questions.length);
                }

                GameBoard.prototype.updatePlayer = function (info) {
                    var found = false;
                    for (var j = 0; j < this.playerList.length; j++) {
                        if (this.playerList[j].id == info.id) {
                            this.playerList[j] = info;
                            found = true;
                        }
                    }
                    if (!found)
                        this.playerList.push(info);

                    // this.playerList.sort(function (a, b) { return a.score - b.score }); -- Might be faster.
                    this.playerList.sort(function (a, b) {
                        if (a.score < b.score)
                            return 1
                        if (a.score > b.score)
                            return -1;
                        return 0;
                    });
                    this.updateLeaderText();

                }
                function replay() {
                    gameBoard = null;
                    //we dont replay
                }

            }
            $(window).bind('beforeunload', function () {
                submitScore(gameBoard)
            })
            function submitScore(gameBoard) {
                if (gameBoard.submittedScore)
                    return false;
                gameBoard.submittedScore = true;
                var url = gameData.leaderboardUrl;
                if (url) {
                    var data = {
                        gameId: gameData.id,
                        score: gameBoard.score
                    };
                    $.ajax(url, {
                        type: "POST",
                        data: data,
                        success: function (x) {

                        },
                        error: function (x, y, z) {

                        }
                    });
                }
            }
            function Question(question, gameBoard) {
                if (!question) {
                    //audio stop
                    correctBell.stop()
                    gameState.gameOn = false;

                    if (isLmsConnected) {
                        ScormHelper.cmi.successStatus(ScormHelper.successStatus.passed);
                        ScormHelper.cmi.completionStatus(ScormHelper.completionStatus.completed);
                    }

                    submitScore(gameBoard);

                    var q = { Text: "Game Over", Answers: [{}] };
                    if (isLmsConnected || navigator.userAgent.match(/Android/i)
                        || navigator.userAgent.match(/webOS/i)
                        || navigator.userAgent.match(/iPhone/i)
                        || navigator.userAgent.match(/iPad/i)
                        || navigator.userAgent.match(/iPod/i)
                        || navigator.userAgent.match(/BlackBerry/i)
                        || navigator.userAgent.match(/Windows Phone/i)
                    )
                        //quit shown only on mobile
                        q.Answers.push({ Text: "Quit", click: quit });
                    else {
                        if (!haveSignalR)
                            q.Answers.push({
                                Text: "Re-play", click: function () {
                                    gameBoard.submittedScore = false;
                                    gameBoard = null;
                                    showTitleView();
                                }
                            });
                    }
                    return new Question(q, gameBoard);
                }

                if (question.Id) { // seeing from above, we create a new Question for the quit menu, but that question won't have an ID
                    if (isLmsConnected) {
                        currentLmsInteraction = ScormHelper.cmi.interactions().new();

                        currentLmsInteraction.id = question.Id;
                        currentLmsInteraction.description = question.Text;
                        currentLmsInteraction.type = ScormHelper.interactions.choice;
                    }
                }
                this.gameBoard = gameBoard;
                this.gameBoard.selectedAnswer = null;
                this.x = 25;
                this.y = 80;
                this.width = 500;
                this.questionFont = "bold 24px Arial";
                this.questionColor = "white";
                //this.answerColor = "#d8d8d8";
                this.answerColor = "black";
                this.answerFont = "bold 40px Arial";
                this.answered = false;
                this.question = question;
                this.value = 0;
                this.contain = new createjs.Container();
                this.categoryText = new createjs.Text(getCategoryById(question.CategoryId), this.questionFont);
                this.categoryText.x = 50;
                this.categoryText.y = 25;
                this.contain.addChild(this.categoryText);
                this.questionText = new createjs.Text(question.Text, this.questionFont);
                this.questionText.x = this.x + 20;
                this.questionText.y = this.y;
                this.questionText.color = this.questionColor;
                this.questionText.lineWidth = this.width;
                this.answers = [];
                var currentY = this.questionText.y + this.questionText.getMeasuredHeight() + 35;
                this.contain.addChild(this.questionText);
                this.gameBoard.container.addChild(this.contain);

                this.showAnswers = function () {

                    for (var j = 0; j < question.Answers.length; j++) {
                        var a = new createjs.Text(question.Answers[j].Text, this.questionFont, this.answerColor);
                        a.y = currentY;
                        a.x = this.x + 40;
                        a.lineWidth = this.width - 20;
                        currentY += 20 + a.getMeasuredHeight();
                        this.answers.push(a);

                        var bg = new createjs.Shape();
                        bg.graphics.beginFill("Khaki");
                        bg.graphics.drawRoundRect(a.x - 4, a.y - 4, this.width, a.getMeasuredHeight() + 8, 8);
                        bg.id = "Answer" + j;
                        var answerContainer = new createjs.Container();
                        answerContainer.hitArea = bg;
                        answerContainer.correct = question.Answers[j].IsCorrect;
                        answerContainer.click = question.Answers[j].click;
                        if (answerContainer.correct)
                            this.correctAnswer = answerContainer;
                        answerContainer.text = a;
                        answerContainer.question = question;
                        answerContainer.gameBoard = this.gameBoard;
                        answerContainer.answer = question.Answers[j];
                        a.hitArea = bg;
                        answerContainer.addChild(bg);
                        answerContainer.addChild(a);
                        this.contain.addChild(answerContainer);
                        this.gameBoard.container.addChild(this.contain);

                        answerContainer.addEventListener("click", function (evt) {
                            clickSound.play();

                            var board = evt.currentTarget.gameBoard;
                            if (evt.currentTarget.click) {
                                evt.currentTarget.click();
                                return;
                            }

                            if (board.selectedAnswer != evt.currentTarget)
                                if (evt.currentTarget.correct)

                                    board.currentQuestion.value = 101 - Math.floor(board.timerTween.target.rotation * 100 / 360);

                                else
                                    board.currentQuestion.value = 0;

                            changeBGcolor(evt.currentTarget, "#e0e7e7", "#184745");

                            if (board.selectedAnswer != null) {
                                changeBGcolor(board.selectedAnswer, "khaki", "black");
                            }

                            board.selectedAnswer = evt.currentTarget;
                        });

                    }
                }
            }
            function changeBGcolor(evt, bgColor, fgColor) {
                var oldbox = evt.children[0];
                var a = evt.text;

                a.color = fgColor;
                evt.removeChild(oldbox);
                evt.removeChild(a);

                var bg = new createjs.Shape();
                bg.graphics.beginFill(bgColor);
                bg.graphics.drawRoundRect(a.x - 8, a.y - 4, a.lineWidth + 20, a.getMeasuredHeight() + 8, 8);
                bg.shadow = standardTextShadow;
                evt.addChild(bg);
                evt.addChild(a);
            }
            Question.prototype.showResults = function () {
                var selectedAnswer = this.gameBoard.selectedAnswer
                this.gameBoard.score = this.gameBoard.score + this.gameBoard.currentQuestion.value;
                var isCorrect = selectedAnswer ? selectedAnswer.correct : false;
                var qMessage = { action: "answer", number: this.gameBoard.questionsAsked, correct: isCorrect, answer: "", point: this.gameBoard.currentQuestion.value }
                postAnswerResults(qMessage)

                if (currentLmsInteraction != null) {
                    currentLmsInteraction.result = selectedAnswer.IsCorrect ? ScormHelper.resuls.correct : ScormHelper.results.incorrect;
                    currentLmsInteraction.learnerResponse = selectedAnswer.Text;
                    currentLmsInteraction.save();
                    currentLmsInteraction = null;
                }

                var feedBackBg = new createjs.Bitmap(resourceLoader.getResult("playerListBackground"));
                feedBackBg.x = 45;
                feedBackBg.y = 410;
                this.contain.addChild(feedBackBg);
                var feedBackImg = new createjs.Bitmap(resourceLoader.getResult(isCorrect ? "Happy" : "Sad"));
                feedBackImg.x = 60;
                feedBackImg.y = 429;
                this.contain.addChild(feedBackImg);
                var correct = new createjs.Text(isCorrect ? "CORRECT!" : "IN-CORRECT!", "bold 36px Arial", "#184745");
                correct.x = 195;
                correct.y = 435;
                this.contain.addChild(correct);
                if (!isCorrect) {
                    Wisc_Buzzer.play();
                    changeBGcolor(this.correctAnswer, "red");
                }
                if (isCorrect)
                    correctBell.play();
                var feed = this.gameBoard.currentQuestion.question.Feedback ? this.gameBoard.currentQuestion.question.Feedback : "";
                this.feedback = new createjs.Text(feed, "bold 18px Arial", "#6f6f6f;");
                this.feedback.x = 195;
                this.feedback.y = 480;
                this.feedback.lineWidth = 300;
                this.contain.addChild(this.feedback);

                timerTween = createjs.Tween.get(this.gameBoard.timer.clockHand, { override: true });
                timerTween.to({ rotation: 360 }, 1)

                timerTween.to({ rotation: 1 }, 3000).call(function () {
                    //audio
                    //                 timerBuild.play({ offset: 0, loop: 1, pan: 0 });
                    //createjs.Tween.get(this.feedback).wait(5000).call(function () {
                    this.gameBoard.showNextQuestion()
                }, this, this);

            }

            function Clock(board) {
                this.board = board;
                this.contain = new createjs.Container();
                this.clockBack = new createjs.Bitmap(resourceLoader.getResult("clockBack"));
                this.clockHand = new createjs.Bitmap(resourceLoader.getResult("clockHand"));
                this.clockBack.x = 565;
                this.clockBack.y = 10;
                this.board.container.addChild(this.clockBack);
                this.contain.placeholder = this;
                this.board.container.addChild(this.contain);
                var t = this.clockHand.getBounds();
                this.clockHand.regX = t.width / 2;
                this.clockHand.regY = t.height;
                this.clockHand.y = 130;
                this.clockHand.x = 677;
                this.contain.hitArea = this.clockBack;
                this.contain.addChild(this.clockHand);
            }
        }

        function getCategoryById(id) {
            if (gameData.Categories)
                for (var j = 0; j < gameData.Categories.length; j++)
                    if (gameData.Categories[j].Id == id)
                        return gameData.Categories[j].Name;
            return "";
        }
        function addSoundControl(container) {
            var soundContainer = new createjs.Container();
            soundContainer.x = 0;
            soundContainer.y = 0;
            soundContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 50, 50));
            soundContainer.cursor = 'pointer';
            var sound = new createjs.Bitmap(resourceLoader.getResult(gameState.musicOn ? "musicOn" : "musicOff"));
            sound.name = "music";
            sound.scaleX = .75;
            sound.scaleY = .75;
            soundContainer.addChild(sound);
            createjs.Sound.setMute(!gameState.musicOn);
            container.addChild(soundContainer);
            soundContainer.addEventListener("click", function (evt) {
                gameState.musicOn = !gameState.musicOn;
                var sound = new createjs.Bitmap(resourceLoader.getResult(gameState.musicOn ? "musicOn" : "musicOff"));
                sound.name = "music"
                sound.scaleX = .75;
                sound.scaleY = .75;
                var destroy = evt.currentTarget.getChildByName("music");
                evt.currentTarget.removeChild(destroy);
                evt.currentTarget.addChild(sound);
                createjs.Sound.setMute(!gameState.musicOn);
            });
        }

        function containerInput(container, id, label, value, x, y, multiLine) {
            this.multiLine = multiLine;
            if (multiLine)
                this.html = document.createElement('textarea');
            else
                this.html = document.createElement('input');
            this.html.id = id;
            this.html.rows = 1;
            this.html.isMultiLine = false;
            this.x = x;
            this.y = y;
            this.id = id;
            this.html.style.backgroundColor = "#E9E9E9";
            this.html.style.position = "absolute";
            this.html.style.top = this.html.style.left = 0;
            // document.body.appendChild(this.html);                
            this.html.value = value
            self.stage.canvas.parentElement.insertBefore(this.html, canvas);
            this.createJsDomElement = new createjs.DOMElement(this.html);
            this.label = new createjs.Text(label, "bold 14px Arial");
            this.label.textAlign = "right";
            this.label.x = x;
            this.label.y = y + 2;
            this.createJsDomElement.x = x + self.stage.canvas.parentElement.offsetLeft;
            this.createJsDomElement.y = y
            //this.createJsDomElement.setBounds(0, y, this.createJsDomElement.width, this.createJsDomElement.height);

            container.addChild(this.createJsDomElement, this.label);
            this.height = $("#" + this.html.id).height();
            this.length = $("#" + this.html.id).width();
            htmlElements.push(this)
            this.setPosition();

        }
        containerInput.prototype.setVisible = function (visible) {
            $("#" + this.html.id).toggle(visible);
        }
        containerInput.prototype.setPosition = function () {
            this.createJsDomElement.x = (this.x + self.stage.canvas.parentElement.offsetLeft) * self.stage.canvas.clientWidth / 800
            this.createJsDomElement.y = (this.y + self.stage.canvas.parentElement.offsetTop) * self.stage.canvas.clientHeight / 600
            if (!this.multiLine)
                $("#" + this.html.id).css('font-size', (this.height * self.stage.canvas.clientWidth / 800) - 2);
            $("#" + this.html.id).height(this.height * self.stage.canvas.clientWidth / 800);
            $("#" + this.html.id).width(this.length * self.stage.canvas.clientHeight / 600);
        }

        function initAdmin(gameId) {
            gameState.gameOn = false;
            addAdminView();
            gameState.isHost = true
            function addAdminView() {
                self.stage.removeAllChildren();
                $("#gameID").hide();
                $("#displayName").hide();
                var GameView = new createjs.Container();
                gameBoard = new AdminView(GameView, gameId);
                self.stage.addChild(GameView);
            }
            function updateURLParameter(url, param, paramVal) {
                var TheAnchor = null;
                var newAdditionalURL = "";
                var tempArray = url.split("?");
                var baseURL = tempArray[0];
                var additionalURL = tempArray[1];
                var temp = "";

                if (additionalURL) {
                    var tmpAnchor = additionalURL.split("#");
                    var TheParams = tmpAnchor[0];
                    TheAnchor = tmpAnchor[1];
                    if (TheAnchor)
                        additionalURL = TheParams;

                    tempArray = additionalURL.split("&");

                    for (i = 0; i < tempArray.length; i++) {
                        if (tempArray[i].split('=')[0] != param) {
                            newAdditionalURL += temp + tempArray[i];
                            temp = "&";
                        }
                    }
                }
                else {
                    var tmpAnchor = baseURL.split("#");
                    var TheParams = tmpAnchor[0];
                    TheAnchor = tmpAnchor[1];

                    if (TheParams)
                        baseURL = TheParams;
                }

                if (TheAnchor)
                    paramVal += "#" + TheAnchor;

                var rows_txt = temp + "" + param + "=" + paramVal;
                return baseURL + "?" + newAdditionalURL + rows_txt;
            }
            function AdminView(container, gameId) {
                this.gameId = gameId;
                this.contain = container;
                this.outline = new createjs.Shape(new createjs.Graphics().beginFill("lightgray").drawRect(0, 0, 800, 600));
                this.contain.addChild(this.outline);
                this.passWord = new containerInput(this.contain, "pass", "Game password to share:", gameId, 200, 20);
                this.directLink = new containerInput(this.contain, "link", "Direct link to share:", updateURLParameter(window.location.href.split("#")[0], "sessionID", gameId), 200, 50, true);
                window.location.hash = gameId
                this.directLink.length = 200;
                this.directLink.height = 60;
                this.directLink.setPosition();


                this.showResults = false;
                this.resultContainer = new createjs.Container();
                this.resultText = new containerInput(this.resultContainer, "resultTxt", "", "", 15, 120, true);
                this.resultText.html.isMultiLine = true;
                this.resultText.html.style.cssText = "font-family: monospace; font:bold 12px Arial; position: absolute; left: 0px; top: 0px; -webkit-transform-origin: 0% 0%; transform-origin: 0% 0% 0px; display: none; background-color: rgb(233, 233, 233);";
                this.resultText.length = 460;
                this.resultText.height = 450;
                this.resultText.setPosition();
                // this.resultText.html.rows = 28;
                // this.resultText.html.cols = 80;


                this.resultText.setVisible(false);

                var openButton = new createButton(this.contain, "Open", "White", "buttonBackground", 10, 42, 50, 30);
                openButton.click = function () {
                    if (gameData.GameStatus != "AVAILABLE")
                        alert("You must set your game status to \"Available\" before you can open or share this link with others.")
                    else {
                        clickSound.play();
                        window.open(updateURLParameter(window.location.href, "sessionID", gameId));
                    }
                }
                openButton.gameId = this.gameId;

                this.resultButton = new createButton(this.contain, "Show Results", "White", "buttonBackground", 10, 80, 135, 35);
                this.resultButton.click = function () {
                    clickSound.play();
                    this.showResults = !this.showResults;
                    if (!this.showResults) {
                        this.text.text = "Show Results";
                        this.passedInContain.removeChild(this.resultContainer);
                    } else {
                        this.text.text = "Hide Results";
                        this.passedInContain.addChild(this.resultContainer);
                    }
                    this.resultText.setVisible(this.showResults);
                }
                this.resultButton.resultContainer = this.resultContainer;
                this.resultButton.resultText = this.resultText;

                this.startGameButton = new createButton(this.contain, "Start Game", "White", "buttonBackground", 550, 20, 170, 70, "bold 20px Arial");
                this.startGameButton.text.font.fontsize = 20;
                this.startGameButton.click = function () {
                    clickSound.play();
                    sendMessage({ action: "startGame" });
                    gameState.gameOn = true;
                };
                this.playerlist = [];
                this.playListLbl = new createjs.Text("Player List", "bold 14px Arial")
                this.playListLbl.x = 600;
                this.playListLbl.y = 100;
                this.playerListText = new createjs.Text("", "bold 14px Arial");
                this.playerListText.x = 510;
                this.playerListText.y = 130;

                var bg = new createjs.Shape();
                bg.graphics.beginFill("white");
                bg.graphics.drawRoundRect(500, 120, 290, 400, 8);
                this.contain.addChild(this.playListLbl, bg, this.playerListText);

            }
            AdminView.prototype.updatePlayer = function (info) {
                var found = false;
                for (var j = 0; j < this.playerlist.length; j++) {
                    if (this.playerlist[j].id == info.id) {
                        this.playerlist[j] = info;
                        found = true;
                    }
                }
                if (!found) {
                    this.playerlist.push(info);
                    if (gameState.gameOn) {
                        sendMessage({ action: "startGame" });
                    }
                }
                this.updateUserList();

            }

            AdminView.prototype.updateList = function () {
                this.playerListText.text = "";
                var results = "";
                for (var j = 0; j < this.playerlist.length; j++) {
                    var status = this.playerlist[j].status ? this.playerlist[j].status : "";
                    this.playerListText.text = this.playerListText.text + this.playerlist[j].displayName + " " + this.playerlist[j].score + status + "\n";
                    results = results + this.playerlist[j].displayName + " Total Points :" + this.playerlist[j].score + " \n";
                    for (var k = 0; k < this.playerlist[j].questionsResults.length; k++) {
                        results = results + "Q" + (k + 1) + ": " + this.playerlist[j].questionsResults[k].point + "\t";
                    }
                    results = results + "\n"
                }
                this.resultText.html.value = results;
            }
            AdminView.prototype.updatePlayerStatus = function (id, status) {
                for (var j = 0; j < this.playerlist.length; j++) {
                    if (this.playerlist[j].id == id) {
                        this.playerlist[j].status = status
                    }
                }
                this.updateList();
            }
            AdminView.prototype.updateUserList = function () {
                this.playerlist.sort(function (a, b) {
                    if (a.score < b.score)
                        return 1
                    if (a.score < b.score)
                        return -1;
                    return 0;
                });
                this.updateList();
            }

        }

        theHub.client.setJoinSuccess = function () {
            if (theHub.state.joinSuccess == "true") {
                theHub.server.setState("questionTime", theHub.state.connectionID);
                // theHub.state.displayName = theHub.state.connectionID;
                if (!theHub.state.hostPrivs || theHub.state.hostPrivs == "false") {
                    gameState.joinSuccess = true;
                    initializeGame();
                    gameBoard.shoWaitForHost();
                    var a = JSON.parse(JSON.stringify(gameState)) //copy
                    a.action = "Connected";
                    sendMessage(a);
                } else {
                    initAdmin(theHub.state.sessionID);
                }
            }
            else {

            }
        }

        function postAnswerResults(info) {
            gameState.questionsResults.push(info);
            var a = JSON.parse(JSON.stringify(gameState)) //copy
            a.action = "UpdateLeaderBoard"
            sendMessage(a);
        }
        function sendMessage(msg) {
            if (!haveSignalR) return;
            //Message = {action:"answer", number: this.gameBoard.questionsAsked, correct: isCorrect, answer: selectedAnswer }
            msg.id = theHub.state.connectionID;
            theHub.server.sendStringToClients(JSON.stringify(msg))

        }
        theHub.client.parseString = function (msg) {
            msgObj = JSON.parse(msg)
            if (msgObj.Type) {
                //sent from server or reconnect
                if (msgObj.Type == "clientDisconnected" && gameState.isHost) {
                    gameBoard.updatePlayerStatus(msgObj.ConnectionId, " -Disconnected");
                }
                if (msgObj.Type == "clientReDisconnected" && gameState.isHost) {
                    gameBoard.updatePlayerStatus(msgObj.id, "");
                }
                if (msgObj.Type == "errorUserNameInUse")
                    var info = new PopUpInfo(self.stage, "Display name already used.", 250, 180, 300, true);
                if (msgObj.Type == "errorInvalidWiscId" || msgObj.Type == "errorInvalidSessionId")
                    var info = new PopUpInfo(self.stage, "Game Expired or password is invalid.", 250, 180, 300, true);
                return;
            }
            if (msgObj.action == "startGame") {
                if (!gameState.isHost && !gameState.gameOn) {
                    gameBoard.startGame();
                }
                return;
            }
            gameBoard.updatePlayer(msgObj);
        }
    }

    return Game;
})(createjs);