﻿/// <reference path="http://code.createjs.com/createjs-2013.12.12.min.js" />
/// <reference path="../../../Content/GamesDownloadTemplate/lib/ScormHelper.js" />

var Game = Game || (function (createjs, $) {
    //var standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);


    function Game(canvas, gameData) {

        var assetsPath = gameData.assetsPath || "";

        var assets = [
            { id: "title_background", src: assetsPath + "title_background.jpg" },
            { id: "instructions_background", src: assetsPath + "instructions_background.png" },
            { id: "instructions_question", src: assetsPath + "instructions_question.png" },
            { id: "start_button", src: assetsPath + "start_button.png" },
            { id: "game_background", src: assetsPath + "gameBackground.jpg" },
            { id: "left_curtain", src: assetsPath + "leftCurtain.png" },
            { id: "right_curtain", src: assetsPath + "rightCurtain.png" },
            { id: "players", src: assetsPath + "playerSprite.png" },
            { id: "player_one", src: assetsPath + "smallAnswerGreenIcon.png" },
            { id: "player_two", src: assetsPath + "smallAnswerYellowIcon.png" },
            { id: "player_three", src: assetsPath + "smallAnswerComputerIcon.png" },
            { id: "twoPlayers", src: assetsPath + "TwoPlayers.png" },
            { id: "threePlayers", src: assetsPath + "threePlayers.png" },
            { id: "head", src: assetsPath + "hostHead.png" },
            { id: "jaw", src: assetsPath + "hostJaw.png" },
            { id: "mustache", src: assetsPath + "hostMustache.png" },
            { id: "speechBubble", src: assetsPath + "jeopardyBubble.png" },
            { id: "correctAnswerDing", src: assetsPath + "jeopardy_correct_answer.mp3" },
            { id: "wrongAnswerBuzz", src: assetsPath + "jeopardy_wrong_answer.mp3" },
            { id: "introSong", src: assetsPath + "jeopardy_intro.mp3" },
            { id: "buzzIn", src: assetsPath + "buzzIn.mp3" },
            { id: "timer", src: assetsPath + "clock-ticking-4.mp3" },
            { id: "incorrect", src: assetsPath + "NotCorrect.mp3" },
            { id: "pleaseBuzzIn", src: assetsPath + "mustBuzzIn.mp3" },
            { id: "musicOn", src: assetsPath + "musicOn.png" },
            { id: "musicOff", src: assetsPath + "musicOff.png" },
            { id: "instructions", src: assetsPath + "jeopardyInstructions.png" }
        ];

        

        // Randomize Questions/Answers
        if (gameData.RandomizeQuestions || gameData.RandomizeQuestions === undefined) {
            gameData.Questions = shuffle(gameData.Questions);
        }


        for (var i = 0; i < gameData.Questions.length; i++) {
            if (gameData.Questions[i].RandomizeAnswers) {
                gameData.Questions[i].Answers = shuffle(gameData.Questions[i].Answers);
            }
        }


        function shuffle(array) {
            var currentIndex = array.length, temporaryValue, randomIndex;

            while (0 !== currentIndex) {
                randomIndex = Math.floor(Math.random() * currentIndex);
                currentIndex -= 1;
                temporaryValue = array[currentIndex];
                array[currentIndex] = array[randomIndex];
                array[randomIndex] = temporaryValue;
            }
            return array;
        }


        //{ id: "buzzIn", src: assetsPath + "buzzIn.mp3" },
        var queue = new createjs.LoadQueue(false);
        var gameState = {
            player1Score: 0,
            player2Score: 0,
            player3Score: 0,
            player1Name: "Player 1",
            player2Name: "Player 2",
            player3Name: "Player 3",
            userSelectEnabled: true,
            gameOn: false,
            playerControl: null,
            timerOn: false,
            currentQuestion: "",
            currentFeedback: null,
            usedQuestionCount: 0,
            answeredPreNextClick: false,
            playerCount: 1,
            resetTimer: function () { gameState.timer = 1800; }
        }

        var htmlElements = [];
        function htmlElement(html, createJsDomElement, x, y, width, height) {
            this.html = html;
            this.createJsDomElement = createJsDomElement
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.visible = true;
            htmlElements.push(this);
            this.setPosition();
            return this;
        }
        htmlElement.prototype.setPosition = function () {
            this.createJsDomElement.x = (this.x + canvas.parentElement.offsetLeft) * canvas.clientWidth / 800
            this.createJsDomElement.y = (this.y) * canvas.clientHeight / 600
            if (!this.multiLine)
                $("#" + this.html.id).css('font-size', (this.height * canvas.clientWidth / 800) - 2);
            $("#" + this.html.id).height(this.height * canvas.clientWidth / 800 + 2);
            $("#" + this.html.id).width(this.width * canvas.clientHeight / 600);

        }
        $(window).resize(function () {
            for (var j = 0; j < htmlElements.length; j++) {
                htmlElements[j].setPosition();
            }
        });

        queue.installPlugin(createjs.Sound);
        queue.addEventListener("complete", function (event) {
            initializeGame();
        });
        queue.loadManifest(assets);

        var isLmsConnected = false;
        var currentLmsInteraction = null;

        if (typeof ScormHelper !== 'undefined') {
            isLmsConnected = ScormHelper.initialize();

        }

        var Timer;
        var isTwoPlayer = false;
        var isThreePlayer = false;
        gameData = gameData || {};
        var self = this;

        var introSong = createjs.Sound.createInstance("introSong");
        var tickTock = createjs.Sound.createInstance("timer");
        var buzzIn = createjs.Sound.createInstance("buzzIn");
        var pleaseBuzzIn = createjs.Sound.createInstance("pleaseBuzzIn");
        var outOfTimeBuzz = createjs.Sound.createInstance("wrongAnswerBuzz");
        //var tickTock = createjs.Sound.createInstance("timer", { interrupt: createjs.Sound.INTERRUPT_ANY, loop: -1 });
        //var buzzIn = createjs.Sound.createInstance("buzzIn", { interrupt: createjs.Sound.INTERRUPT_ANY, loop: 0 });
        //var pleaseBuzzIn = createjs.Sound.createInstance("pleaseBuzzIn", { interrupt: createjs.Sound.INTERRUPT_ANY, loop: 0 });
        //var outOfTimeBuzz = createjs.Sound.createInstance("wrongAnswerBuzz", { interrupt: createjs.Sound.INTERRUPT_ANY, loop: 0 });

        function initializeGame() {
            var player1ScoreText = new createjs.Text("0", "16pt Arial Black", "White");
            var player2ScoreText = new createjs.Text("0", "16pt Arial Black", "White");
            var player3ScoreText = new createjs.Text("0", "16pt Arial Black", "White");
            var cellOrigin = [30, 30];
            var cellMargin = [5, 5];
            var cellSize = [150, 150];
            var blue = "#0B5984";
            self.gameData = gameData;
            gameState.submitedScore = false;

            var stage = new createjs.Stage(canvas);
            var stageMouseDownHandler = createjs.Stage.prototype._handlePointerDown;
            var stageMouseUpHandler = createjs.Stage.prototype._handlePointerUp;

            if (navigator.userAgent.match(/Android/i)
                || navigator.userAgent.match(/webOS/i)
                || navigator.userAgent.match(/iPhone/i)
                || navigator.userAgent.match(/iPad/i)
                || navigator.userAgent.match(/iPod/i)
                || navigator.userAgent.match(/BlackBerry/i)
                || navigator.userAgent.match(/Windows Phone/i)
                ) {

                stage._handlePointerDown = function (id, event, clear) {
                    if (typeof event.x != 'undefined') {

                        event.screenX = event.x;
                        event.screenY = event.y;
                        stageMouseDownHandler.call(this, id, event, clear);
                    }
                }
                stage._handlePointerUp = function (id, event, clear) {
                    if (typeof event.x != 'undefined') {

                        event.screenX = event.x;
                        event.screenY = event.y;
                        stageMouseUpHandler.call(this, id, event, clear);
                    }

                }
            }



            stage.enableMouseOver(10);

            var fps = 60;
            var tickCount = 0;
            var fadeMusicOut = false;
            var fadeMusicIn = false;
            var musicOn = true;
            function tickListener() {


                if (fadeMusicOut) {
                    var v = introSong.getVolume();

                    if (v > 0.001) {
                        introSong.setVolume(v * 0.95);
                    } else {
                        introSong.stop();
                        fadeMusicOut = false;
                    }
                }
                if (fadeMusicIn) {
                    var v = introSong.getVolume();
                    if (v < 0.5) {
                        introSong.setVolume(v + 0.05);
                    } else {
                        fadeMusicIn = false;
                    }
                }

                if (gameState.timerOn == true) {
                    Timer.visible = true;
                    tickCount = (tickCount++) % fps;

                    if (tickCount == 0 && tickCount < 30) {
                        // 1 second occured
                        gameState.timer = --gameState.timer;

                        if (gameState.timer <= 0) {

                            if (gameState.playerControl != null && gameState.currentQuestion != null) {
                                //get current question score
                                var question = self.currentView.getChildByName(gameState.currentQuestion);

                                var questionContainer = new createjs.Container();
                                var scorer = gameState[gameState.playerControl];
                                gameState[gameState.playerControl] = scorer - question.points;


                                var textBoxContainer = gameState.playerControl + 'TextContainer';
                                var textBoxName = gameState.playerControl + 'Text';
                                var textbox = self.currentView.getChildByName(textBoxContainer).getChildByName(textBoxName);
                                textbox.text = gameState[gameState.playerControl];
                                t = textbox.getBounds() ? textbox.getBounds().width : 49;

                                textbox.x = (115 - t) / 2;
                                var playerHitArea = gameState.playerControl + "HitArea";
                                playerHitArea = self.currentView.getChildByName(playerHitArea);
                                playerHitArea.alpha = .2;

                                gameState.playerControl = null;

                                var boardSquareBackground = new createjs.Shape();

                                boardSquareBackground.graphics.beginLinearGradientFill(["#666", "#101010", "#666"], [.01, .35, .75], 139, 90, 0, 0);

                                boardSquareBackground.graphics.drawRoundRect(0, 0, 139, 70, 5);
                                boardSquareBackground.graphics.endFill();
                                question.addChild(boardSquareBackground);
                                question.isAnswered = true;

                                outOfTimeBuzz.play();

                                gameState.answeredPreNextClick = true;
                                var theOpenQuestion = self.currentView.getChildByName("theOpenQuestion");
                                var displayAnswer = theOpenQuestion.getChildByName("theCorrectAnswer");
                                var correctText = displayAnswer.getChildAt(1);
                                var answerText = new createjs.Text(correctText.text, "bold 16px Arial", "#000");
                                answerText.lineWidth = 460;

                                var h = (correctText.getMeasuredHeight());
                                var box = new createjs.Shape(new createjs.Graphics().beginFill("#fff").beginStroke("#fff").setStrokeStyle(1).drawRoundRect(0, 0, 500, h + 10, 5).endFill().endStroke());



                                answerText.maxWidth = 460;
                                answerText.x = 10;
                                answerText.y = 5;

                                displayAnswer.addChild(box, answerText);

                                var nextButtonContainer = new createjs.Container();
                                var nextBG = new createjs.Shape(new createjs.Graphics().beginFill("green").drawRoundRect(0, 0, 75, 30, 5));
                                var nextText = new createjs.Text("Next", "bold 16px Arial", "#fff");

                                nextButtonContainer.addChild(nextBG, nextText);

                                nextButtonContainer.x = 450;
                                nextButtonContainer.y = 350;
                                nextText.x = 20;
                                nextText.y = 5;
                                nextButtonContainer.addEventListener("click", function (evt) {


                                    var theQuestionContainer = evt.currentTarget.parent;
                                    self.currentView.removeChild(theQuestionContainer);
                                    var theSpeechBubble = self.currentView.getChildByName("speechBubble");
                                    self.currentView.removeChild(theSpeechBubble);

                                    gameState.playerControl = null;


                                    gameState.currentQuestion = "";
                                    Timer.visible = false;
                                    gameState.resetTimer()
                                    if (gameState.usedQuestionCount >= theQuestions.length) {
                                        showView(createWinnerView());
                                    }
                                });

                                theOpenQuestion.addChild(nextButtonContainer);
                            }
                            gameState.resetTimer();
                            Timer.visible = false;
                            gameState.timerOn = false;
                            tickTock.stop();
                            gameState.playerControl = null;

                        } else {
                            UpdateTimer();
                        }
                    } else {

                        gamestate.resetTimer();
                        Timer.visible = false;
                        tickTock.stop();
                        gameState.timerOn = false;
                    }
                }
                if (gameState.currentQuestion == null || gameState.currentQuestion == "") {
                    var theOpenQuestion = self.currentView.getChildByName("theOpenQuestion");

                    gameState.answeredPreNextClick = false;
                }
                stage.update();
            }
            function UpdateTimer() {
                var Seconds = gameState.timer;

                var Days = Math.floor(Seconds / 86400);
                Seconds -= Days * 86400;

                var Hours = Math.floor(Seconds / 3600);
                Seconds -= Hours * (3600);

                var Minutes = Math.floor(Seconds / 60);
                Seconds -= Minutes * (60);

                var TimeStr = LeadingZero(Minutes) + ":" + LeadingZero(Seconds);

                Timer.text = TimeStr;
            }

            function LeadingZero(Time) {

                return (Time < 10) ? "0" + Time : +Time;

            }

            createjs.Ticker.setFPS(fps);
            createjs.Ticker.addEventListener("tick", tickListener);

            createjs.Touch.enable(stage, false, true);

            var theCategories = gameData.Categories;
            var theQuestions = gameData.Questions;
            var squares = [];
            for (var i = 0; i < theCategories.length; ++i) {
                var squareValue = 100;
                position = 0;
                for (var q = 0; q < theQuestions.length; ++q) {

                    if (theQuestions[q].CategoryId == theCategories[i].Id) {

                        squares.push({ "x": i, "y": position, "question": theQuestions[q], "points": squareValue, "id": theQuestions[q].Id });
                        if (squareValue == 500) {
                            squareValue = 100;
                            position = 0;
                        } else {
                            squareValue = squareValue + 100;
                            position = ++position;
                        }

                    }
                }

            }
            var player1 = {
                name: null,
                score: 0
            };
            var player2 = {
                name: null,
                score: 0
            };
            var player3 = {
                name: null,
                score: 0
            };

            $(window).bind('beforeunload', function () {
                submitScore(Math.max(gameState.player1Score, gameState.player2Score, gameState.player3Score))
            })

            function submitScore(score) {
                if (gameState.submitedScore || score == 0)
                    return false;
                gameState.submitedScore = true;

                var url = gameData.leaderboardUrl;

                if (url) {

                    var data = {
                        gameId: gameData.id,
                        score: score
                    };

                    $.ajax(url, {
                        type: "POST",
                        data: data,
                        success: function (x) {

                        },
                        error: function (x, y, z) {


                        }
                    });

                }
            }

            function createInstructionsView() {

                var view = new createjs.Container();
                var image = new createjs.Bitmap(queue.getResult("instructions"));

                var hit = new createjs.Shape();
                var exitContainer = new createjs.Container();
                var exitBox = new createjs.Shape();

                exitContainer.x = 720;
                exitContainer.y = 570;
                var exitText = new createjs.Text("BACK", 'bold 18px Arial', "#fff");
                exitText.x = 8;
                exitText.y = 8;
                exitContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#0D6A9C").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke());
                hit.graphics.beginFill("#000").drawRect(0, 0, exitText.getMeasuredWidth(), exitText.getMeasuredHeight());
                exitBox.graphics.beginFill("#0D6A9C").beginStroke("#000").setStrokeStyle(1).drawRoundRect(0, 0, 70, 37, 5).endFill().endStroke();
                exitText.hitArea = hit;
                exitContainer.addChild(exitBox, exitText);
                var background = new createjs.Shape(new createjs.Graphics().beginFill("#fff").beginStroke("#fff").setStrokeStyle(1).drawRect(0, 00, 800, 600).endFill().endStroke());

                view.addChild(background, image, exitContainer);//, 

                exitContainer.addEventListener("click", function (event) {

                    showView(self.previousView);
                });

                return view;
            }


            function handleStartButtonHover(event) {
                if (event.type == "mouseover") {
                    createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100).to({ scaleX: 1.0, scaleY: 1.0 }, 100).to({ scaleX: 1.0625, scaleY: 1.0625 }, 200);
                }
                else {
                    createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0, scaleY: 1.0 }, 100);
                }
            }

            function createTitleView() {
                fadeMusicOut = false;
                fadeMusicIn = true;
                var view = new createjs.Container();

                var titleText = new createjs.Text(gameData.Title, "36px Arial Black", "#0B5984");
                //standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);
                titleText.lineWidth = 780;
                titleText.x = 10;
                titleText.y = 50;

                var descriptionText = new createjs.Text(gameData.Description, "20px Bold Arial", "dark gray");
                descriptionText.lineWidth = 780;
                descriptionText.x = 10;
                descriptionText.y = 200;

                var startButton = new createjs.Bitmap(queue.getResult("start_button"));
                //startButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
                startButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                startButton.cursor = 'pointer';
                startButton.regX = 50;
                startButton.regY = 50;
                startButton.x = 725;
                startButton.y = 525;

                view.addChild(new createjs.Bitmap(queue.getResult("title_background")));
                view.addChild(startButton);
                view.addChild(descriptionText);
                view.addChild(titleText);

                startButton.addEventListener("click", function (event) {
                    introSong.play();
                    showView(createNumberOfPlayersView());
                });

                startButton.on("mouseover", handleStartButtonHover);
                startButton.on("mouseout", handleStartButtonHover);
                view.name = "TitleView";
                return view;
            }

            function createNumberOfPlayersView() {
                var view = new createjs.Container();

                var titleText = new createjs.Text("How many players???", "36px Arial Black", "#0B5984");
                //standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);
                titleText.textAlign = "center";
                titleText.x = 400;
                titleText.y = 75;

                var oneContainer = new createjs.Container();
                var twoContainer = new createjs.Container();
                var threeContainer = new createjs.Container();

                ////create oneContainer///////////////////////////////////
                oneContainer.hitArea = twoContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawRect(0, 0, 150, 150));
                oneContainer.cursor = twoContainer.cursor = 'pointer';
                //oneContainer.shadow = new createjs.Shadow("gray", 3, 3, 10);

                oneContainer.regX = twoContainer.regX = threeContainer.regX = 45;
                oneContainer.regY = twoContainer.regY = threeContainer.regY = 45;

                var oneText = new createjs.Text("One Player", "14px Arial Black");


                oneContainer.addChild(oneText);
                oneContainer.y = twoContainer.y = threeContainer.y = 215;
                oneContainer.x = 210;


                ////create twoContainer///////////////////////////////////
                var twoText = new createjs.Text("Two Players", "14px Arial Black");
                //twoContainer.shadow = new createjs.Shadow("gray", 3, 3, 10);
                twoContainer.addChild(twoText);
                twoContainer.x = oneContainer.x + 200;

                ////create threeContainer///////////////////////////////////
                var threeText = new createjs.Text("Three Players", "14px Arial Black");
                //threeContainer.shadow = new createjs.Shadow("gray", 3, 3, 10);
                threeContainer.addChild(threeText);
                threeContainer.x = twoContainer.x + 200;

                oneText.textAlign = twoText.textAlign = threeText.textAlign = "center";
                oneText.textBaseline = twoText.textBaseline = threeText.textBaseline = "middle";
                oneText.x = twoText.x = threeText.x = 37;
                oneText.y = twoText.y = threeText.y = 85;

                oneContainer.addChild(new createjs.Bitmap(queue.getResult("player_one")));
                twoContainer.addChild(new createjs.Bitmap(queue.getResult("twoPlayers")));
                threeContainer.addChild(new createjs.Bitmap(queue.getResult("threePlayers")));
                view.addChild(new createjs.Bitmap(queue.getResult("plain_background")))
                view.addChild(titleText);
                view.addChild(oneContainer);
                view.addChild(twoContainer);
                view.addChild(threeContainer);

                oneContainer.on("mouseover, pressmove", function () {
                    createjs.Tween.get(oneContainer).to({ scaleX: 1.125, scaleY: 1.125 }, 100).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100).to({ scaleX: 1.125, scaleY: 1.125 }, 100);
                    createjs.Tween.get(twoContainer).to({ scaleX: 0.875, scaleY: 0.875 }, 100);
                });

                oneContainer.on("mouseout", function () {
                    createjs.Tween.get(oneContainer).to({ scaleX: 1, scaleY: 1 }, 75);
                    createjs.Tween.get(twoContainer).to({ scaleX: 1, scaleY: 1 }, 75);
                });

                twoContainer.on("mouseover", function () {
                    createjs.Tween.get(twoContainer).to({ scaleX: 1.125, scaleY: 1.125 }, 100).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100).to({ scaleX: 1.125, scaleY: 1.125 }, 100);
                    createjs.Tween.get(oneContainer).to({ scaleX: 0.875, scaleY: 0.875 }, 100);
                });

                twoContainer.on("mouseout", function () {
                    createjs.Tween.get(twoContainer).to({ scaleX: 1, scaleY: 1 }, 75);
                    createjs.Tween.get(oneContainer).to({ scaleX: 1, scaleY: 1 }, 75);
                });

                threeContainer.on("mouseover", function () {
                    createjs.Tween.get(threeContainer).to({ scaleX: 1.125, scaleY: 1.125 }, 100).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100).to({ scaleX: 1.125, scaleY: 1.125 }, 100);
                    createjs.Tween.get(oneContainer).to({ scaleX: 0.875, scaleY: 0.875 }, 100);
                });

                threeContainer.on("mouseout", function () {
                    createjs.Tween.get(threeContainer).to({ scaleX: 1, scaleY: 1 }, 75);
                    createjs.Tween.get(oneContainer).to({ scaleX: 1, scaleY: 1 }, 75);
                });

                oneContainer.addEventListener("click", function (event) {
                    gameState.playerCount = 1;
                    showView(createPlayerEnterNameView());
                });

                twoContainer.addEventListener("click", function (event) {
                    //if (gameState.playerCount > 2) {

                    //    if (gameState.playerCount == 3) {
                    //        player3NameInput.parentNode.removeChild(player3NameInput);
                    //    }
                    //}
                    gameState.playerCount = 2;
                    showView(createTwoPlayerEnterNamesView());
                });

                threeContainer.addEventListener("click", function (event) {
                    gameState.playerCount = 3;
                    showView(createThreePlayerEnterNamesView());
                });

                view.name = "NumberOfPlayers";
                return view;
            }

            function createPlayerEnterNameView() {

                isTwoPlayer = false;
                isThreePlayer = false;
                if (gameState.playerCount == 2) {
                    isTwoPlayer = true;
                }
                if (gameState.playerCount == 3) {
                    isTwoPlayer = true;
                    isThreePlayer = true;
                }
                var view = new createjs.Container();

                var titleText = new createjs.Text(isTwoPlayer ? "Enter Player Names" : "Enter your name?", "30px Arial Black", blue);

                titleText.x = 40;
                titleText.y = 40;
                //standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);
                var buzz1Text = new createjs.Text("Buzz Key - A", "16px Arial Black", blue);
                buzz1Text.x = 480;
                buzz1Text.y = 140;
                var p1Image = new createjs.Bitmap(queue.getResult("player_one"));
                p1Image.scaleX = 1 / 1.5; // make the image 50x50
                p1Image.scaleY = 1 / 1.5;
                p1Image.x = 40;
                p1Image.y = 130;
                //p1Image.shadow = new createjs.Shadow("gray", 3, 3, 3);

                var player1NameInput = document.createElement("input");
                player1NameInput.value = gameState.player1Name;
                player1NameInput.type = "text";
                player1NameInput.name = "player1Input";
                player1NameInput.id = "player1Input";
                player1NameInput.style.width = "350px";
                player1NameInput.style.font = "24pt Arial";
                player1NameInput.id = "player1NameInput";
                player1NameInput.style.left = canvas.offsetLeft + "px";
                player1NameInput.style.top = canvas.offsetTop + "px";

                stage.canvas.parentElement.insertBefore(player1NameInput, stage.canvas)

                var player1NameInputControl = new createjs.DOMElement(player1NameInput);
                player1NameInputControl.y = 130;
                player1NameInputControl.x = 110;
                var a = new htmlElement(player1NameInput, player1NameInputControl, 110, 130, 340, 30)


                if (isTwoPlayer) {
                    var p2Image = new createjs.Bitmap(queue.getResult("player_two"));
                    p2Image.scaleX = 1 / 1.5; // make the image 50x50
                    p2Image.scaleY = 1 / 1.5;
                    p2Image.x = 40;
                    p2Image.y = 210;
                    //p2Image.shadow = new createjs.Shadow("gray", 3, 3, 3);
                    var buzz2Text = new createjs.Text("Buzz Key - B", "16px Arial Black", blue);
                    buzz2Text.x = 480;
                    buzz2Text.y = 220;
                    var player2NameInput = document.createElement("input");
                    player2NameInput.id = "player2Name";
                    player2NameInput.value = gameState.player2Name;
                    player2NameInput.type = "text";
                    player2NameInput.name = "player2Input";
                    player2NameInput.style.width = "350px";
                    player2NameInput.style.font = "24pt Arial";
                    player2NameInput.id = "player2NameInput";
                    player2NameInput.style.left = canvas.offsetLeft + "px";
                    player2NameInput.style.top = canvas.offsetTop + "px";
                    stage.canvas.parentElement.insertBefore(player2NameInput, stage.canvas)

                    var player2NameInputControl = new createjs.DOMElement(player2NameInput);
                    player2NameInputControl.y = 210;
                    player2NameInputControl.x = 110;
                    var a = new htmlElement(player2NameInput, player2NameInputControl, 110, 210, 340, 30)

                }

                if (isThreePlayer) {
                    var p3Image = new createjs.Bitmap(queue.getResult("player_three"));
                    p3Image.scaleX = 1 / 1.5; // make the image 50x50
                    p3Image.scaleY = 1 / 1.5;
                    p3Image.x = 40;
                    p3Image.y = 290;
                    //p3Image.shadow = new createjs.Shadow("gray", 3, 3, 3);
                    var buzz3Text = new createjs.Text("Buzz Key - L", "16px Arial Black", blue);
                    buzz3Text.x = 480;
                    buzz3Text.y = 300;
                    var player3NameInput = document.createElement("input");
                    player3NameInput.id = "player3Name";
                    player3NameInput.value = gameState.player3Name;
                    player3NameInput.type = "text";
                    player3NameInput.name = "player3Input";
                    player3NameInput.style.width = "350px";
                    player3NameInput.style.font = "24pt Arial";
                    player3NameInput.id = "player3NameInput";
                    player3NameInput.style.left = canvas.offsetLeft + "px";
                    player3NameInput.style.top = canvas.offsetTop + "px";
                    stage.canvas.parentElement.insertBefore(player3NameInput, stage.canvas)

                    var player3NameInputControl = new createjs.DOMElement(player3NameInput);
                    player3NameInputControl.y = 290;
                    player3NameInputControl.x = 110;
                    var a = new htmlElement(player3NameInput, player3NameInputControl, 110, 290, 340, 30)

                }

                var backButton = new createjs.Bitmap(queue.getResult("start_button"));
                //backButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
                backButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                backButton.cursor = 'pointer';
                backButton.scaleX = -0.375;
                backButton.scaleY = 0.375;
                backButton.regX = 50;
                backButton.regY = 50;
                backButton.x = 75;
                backButton.y = 572;

                var startButton = new createjs.Bitmap(queue.getResult("start_button"));
                //startButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
                startButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                startButton.cursor = 'pointer';
                startButton.regX = 50;
                startButton.regY = 50;
                startButton.x = 725;
                startButton.y = 525;

                startButton.on("mouseover", function (event) {
                    createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100).to({ scaleX: 1.0, scaleY: 1.0 }, 100).to({ scaleX: 1.0625, scaleY: 1.0625 }, 200);
                });

                startButton.on("mouseout", function (event) {
                    createjs.Tween.get(event.currentTarget).to({ scaleX: 1.0, scaleY: 1.0 }, 100);
                });


                view.addChild(titleText);
                view.addChild(p1Image, buzz1Text);
                view.addChild(startButton, backButton);
                view.addChild(player1NameInputControl);
                if (isTwoPlayer) {
                    view.addChild(p2Image, player2NameInputControl, buzz2Text);
                }
                if (isThreePlayer) {
                    view.addChild(p3Image, player3NameInputControl, buzz3Text);
                }
                startButton.addEventListener("click", function (event) {
                    gameState.player1Name = player1NameInput.value;
                    if (player1NameInput.value == "" || (isTwoPlayer && player2NameInput.value == "") || (isThreePlayer && player3NameInput.value == "")) {
                        var errorText = new createjs.Text("Please check what you entered.", "18px Arial Black", "red");
                        errorText.x = 110;
                        errorText.y = 100;
                        view.addChild(errorText);
                    } else {
                        if (player1NameInput) {
                            player1NameInput.parentNode.removeChild(player1NameInput);
                        }
                        if (isTwoPlayer && player2NameInput) {
                            gameState.player2Name = player2NameInput.value;
                            player2NameInput.parentNode.removeChild(player2NameInput);
                        }
                        if (isThreePlayer && player3NameInput) {
                            gameState.player3Name = player3NameInput.value;
                            player3NameInput.parentNode.removeChild(player3NameInput);
                        }
                        showView(createMatchupView());
                    }
                });

                backButton.addEventListener("click", function (event) {

                    player1NameInput.parentNode.removeChild(player1NameInput);

                    if (isTwoPlayer) {
                        player2NameInput.parentNode.removeChild(player2NameInput);
                    }
                    if (isThreePlayer) {
                        player3NameInput.parentNode.removeChild(player3NameInput);
                    }
                    showView(self.previousView);
                });
                view.name = "CreatePlayers";
                return view;
            }

            function createTwoPlayerEnterNamesView() {
                return createPlayerEnterNameView(2);
            }

            function createThreePlayerEnterNamesView() {
                return createPlayerEnterNameView(3);
            }

            function createMatchupView() {
                var view = new createjs.Container();
                var width = stage.canvas.width;

                var titleText = new createjs.Text("Let's play Jeopardy!", "40px Arial Black", blue);
                //standardTextShadow = new createjs.Shadow("gray", 1, 1, 3);
                t = titleText.getBounds();
                titleText.x = 280;
                titleText.y = 10;

                var startButton = new createjs.Bitmap(queue.getResult("start_button"));
                //startButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
                startButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                startButton.cursor = 'pointer';
                startButton.regX = 50;
                startButton.regY = 50;
                startButton.x = 140;
                startButton.y = 460;
                startButton.scaleX = startButton.scaleY = 1.25;
                createjs.Tween.get(startButton, { loop: true })
                              .to({ scaleX: 1.50, scaleY: 1.50 }, 1000)
                              .to({ scaleX: 1.25, scaleY: 1.25 }, 750)

                var backButton = new createjs.Bitmap(queue.getResult("start_button"));
                //backButton.shadow = new createjs.Shadow("gray", 3, 3, 3);
                backButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawCircle(50, 50, 50));
                backButton.cursor = 'pointer';
                backButton.scaleX = -0.375;
                backButton.scaleY = 0.375;
                backButton.regX = 50;
                backButton.regY = 50;
                backButton.x = 75;
                backButton.y = 572;

                view.addChild(new createjs.Bitmap(queue.getResult("game_background")));

                var playerSprite = new createjs.Bitmap(queue.getResult("players"))
                playerSprite.x = 285;
                playerSprite.y = 462;
                playerSprite.scaleX = .9;
                playerSprite.scaleY = .9
                view.addChild(playerSprite);

                view.addChild(titleText);

                var infoContainer = new createjs.Container();
                var infoBackground = new createjs.Shape(new createjs.Graphics().beginFill("#CDCDCD").drawRoundRect(240, 60, 559, 300, 7));
                infoContainer.addChild(infoBackground);
                var player1info = new createjs.Text(gameState.player1Name + " - buzz key A", "22px Arial Bold", blue);
                var lastYposition = 80;
                player1info.x = 300;
                player1info.y = lastYposition;
                infoContainer.addChild(player1info);



                var player1Text = new createjs.Text(gameState.player1Name, "18px Arial Bold", "#fff");
                var player1NameTag = new createjs.Container();
                player1NameTag.x = 290;
                player1NameTag.y = 528;
                player1NameTag.addChild(player1Text);
                t = player1Text.getBounds() ? player1Text.getBounds().width : 49;

                player1Text.x = (150 - t) / 2;
                //player1Text.shadow = standardTextShadow;

                if (gameState.playerCount > 1) {
                    var player2Text = new createjs.Text(gameState.player2Name, "18px Arial Bold", "#fff");
                    var player2NameTag = new createjs.Container();
                    player2NameTag.x = 460;
                    player2NameTag.y = 528;
                    player2NameTag.addChild(player2Text);
                    t = player2Text.getBounds() ? player2Text.getBounds().width : 49;
                    player2Text.x = (150 - t) / 2;
                    //player2Text.shadow = standardTextShadow;
                    view.addChild(player2NameTag);


                    var player2info = new createjs.Text(gameState.player2Name + " - buzz key B", "22px Arial Bold", blue);
                    lastYposition = 80 + 30;
                    player2info.x = 300;
                    player2info.y = lastYposition;
                    infoContainer.addChild(player2info);


                }
                if (gameState.playerCount >= 3) {
                    var player3Text = new createjs.Text(gameState.player3Name, "18px Arial Bold", "#fff");
                    var player3NameTag = new createjs.Container();
                    player3NameTag.x = 630;
                    player3NameTag.y = 528;
                    player3NameTag.addChild(player3Text);
                    t = player3Text.getBounds() ? player3Text.getBounds().width : 49;
                    player3Text.x = (150 - t) / 2;
                    //player3Text.shadow = standardTextShadow;
                    view.addChild(player3NameTag);

                    var player3info = new createjs.Text(gameState.player3Name + "- buzz key L", "22px Arial Bold", blue);
                    lastYposition = lastYposition + 30;
                    player3info.x = 300;
                    player3info.y = lastYposition;
                    infoContainer.addChild(player3info);
                }


                var clickInfoText = new createjs.Text("If not on mobile, you may click the user or press the buzz key.  \n\nOn mobile, press the player to answer the question.", "22px Arial Bold", blue);
                clickInfoText.x = 300;
                clickInfoText.y = lastYposition + 60;
                clickInfoText.lineWidth = 400;
                clickInfoText.maxWidth = 400;
                infoContainer.addChild(clickInfoText);
                view.addChild(infoContainer);
                view.addChild(player1NameTag);

                view.addChild(startButton, backButton);



                var rightCurtain = new createjs.Bitmap(queue.getResult("right_curtain"));
                rightCurtain.scaleY = 1.02;
                rightCurtain.x = 0;
                rightCurtain.y = 0;
                var leftCurtain = new createjs.Bitmap(queue.getResult("left_curtain"));
                //leftCurtain.scaleY = 1.03;
                leftCurtain.x = (width / 2);
                leftCurtain.y = 0;
                view.addChild(rightCurtain, leftCurtain);
                createjs.Tween.get(rightCurtain).wait(500).to({ x: -((width + 20) / 2) }, 3000, createjs.Ease.linear);
                createjs.Tween.get(leftCurtain).wait(500).to({ x: width }, 3000, createjs.Ease.linear);

                startButton.addEventListener("click", function () {
                    gameState.gameOn = true;
                    showView(createMainGameView());
                    fadeMusicOut = true;
                });

                backButton.addEventListener("click", function () {
                    if (gameState.playerCount == 1) {
                        showView(createPlayerEnterNameView());
                    }
                    else if (gameState.playCount == 2) {
                        showView(createTwoPlayerEnterNamesView());
                    } else {
                        showView(createThreePlayerEnterNamesView());
                    }
                    fadeMusicOut = true;
                });
                view.name = "MatchUp"
                return view;
            }

            function createMainGameView() {


                var view = new createjs.Container();
                view.addChild(new createjs.Bitmap(queue.getResult("game_background")));

                var hostHead = new createjs.Bitmap(queue.getResult("head"));
                hostHead.scaleX = .75;
                hostHead.scaleY = .75;
                hostHead.x = 76;
                hostHead.y = 220;
                hostHead.name = "head";
                var hostJaw = new createjs.Bitmap(queue.getResult("jaw"));
                hostJaw.scaleX = .75;
                hostJaw.scaleY = .75;
                hostJaw.x = 75;
                hostJaw.y = 370;
                hostJaw.name = "jaw";
                var hostMustache = new createjs.Bitmap(queue.getResult("mustache"));
                hostMustache.scaleX = .75;
                hostMustache.scaleY = .75;
                t = hostMustache.getBounds();
                hostMustache.regX = t.width / 2;
                hostMustache.x = 128;
                hostMustache.y = 337;
                hostMustache.name = "mustache";


                view.addChild(hostHead, hostJaw, hostMustache);




                var player1HitArea = new createjs.Shape();
                player1HitArea = new createjs.Shape(new createjs.Graphics().beginFill("#FFFFCC").drawCircle(77, 70, 70));
                player1HitArea.alpha = .2;
                player1HitArea.x = 290;
                player1HitArea.y = 445;
                player1HitArea.name = "player1ScoreHitArea";
                view.addChild(player1HitArea);

                player1HitArea.addEventListener("click", function (evt) {
                    if (gameState.currentQuestion != "" && gameState.answeredPreNextClick == false && gameState.playerControl == null) {
                        evt.currentTarget.alpha = 1;
                        handleUserBuzzIn("A");
                    }
                    player1HitArea.cursor = "pointer";
                });
                player1HitArea.addEventListener("mouseover", function (evt) {
                    if (gameState.playerControl == null) {
                        var container = evt.currentTarget.parent.getChildByName("player1NameContainer");
                        var text = container.getChildByName("player1NameText");
                        text.color = "yellow";
                        player1HitArea.cursor = "hand";
                    }
                });
                player1HitArea.addEventListener("mouseout", function (evt) {
                    if (gameState.playerControl == null) {
                        var container = evt.currentTarget.parent.getChildByName("player1NameContainer");
                        var text = container.getChildByName("player1NameText");
                        text.color = "white";
                        player1HitArea.cursor = "pointer";
                    }
                });


                if (gameState.player2Name != null && gameState.playerCount >= 2) {
                    var player2HitArea = new createjs.Shape();
                    player2HitArea = new createjs.Shape(new createjs.Graphics().beginFill("#FFFFCC").drawCircle(77, 70, 70));
                    player2HitArea.alpha = .2;
                    player2HitArea.x = 457;
                    player2HitArea.y = 445;
                    player2HitArea.name = "player2ScoreHitArea";
                    view.addChild(player2HitArea);

                    player2HitArea.addEventListener("click", function (evt) {
                        if (gameState.playerCount > 1 && gameState.currentQuestion != "" && gameState.answeredPreNextClick == false && gameState.playerControl == null) {
                            evt.currentTarget.alpha = 1;
                            handleUserBuzzIn("B");
                            player2HitArea.cursor = "pointer";
                        }
                    });
                    player2HitArea.addEventListener("mouseover", function (evt) {
                        if (gameState.playerControl == null) {
                            var container = evt.currentTarget.parent.getChildByName("player2NameContainer");
                            var text = container.getChildByName("player2NameText");
                            text.color = "yellow";
                            player2HitArea.cursor = "hand";
                        }
                    });
                    player2HitArea.addEventListener("mouseout", function (evt) {
                        if (gameState.playerControl == null) {
                            var container = evt.currentTarget.parent.getChildByName("player2NameContainer");
                            var text = container.getChildByName("player2NameText");
                            text.color = "white";
                            player2HitArea.cursor = "pointer";
                        }
                    });

                }

                if (gameState.player3Name != null && gameState.playerCount == 3) {

                    var player3HitArea = new createjs.Shape();
                    player3HitArea = new createjs.Shape(new createjs.Graphics().beginFill("#FFFFCC").drawCircle(77, 70, 70));
                    player3HitArea.alpha = .2;
                    player3HitArea.x = 625;
                    player3HitArea.y = 445;
                    player3HitArea.name = "player3ScoreHitArea";
                    view.addChild(player3HitArea);
                    player3HitArea.addEventListener("click", function (evt) {
                        if (gameState.playerCount == 3 && gameState.currentQuestion != "" && gameState.answeredPreNextClick == false && gameState.playerControl == null) {
                            evt.currentTarget.alpha = 1;
                            handleUserBuzzIn("L");
                            player3HitArea.cursor = "pointer";
                        }
                    });
                    player3HitArea.addEventListener("mouseover", function (evt) {
                        if (gameState.playerControl == null) {
                            var container = evt.currentTarget.parent.getChildByName("player3NameContainer");
                            var text = container.getChildByName("player3NameText");
                            text.color = "yellow";
                            player3HitArea.cursor = "hand";
                        }
                    });
                    player3HitArea.addEventListener("mouseout", function (evt) {
                        if (gameState.playerControl == null) {
                            var container = evt.currentTarget.parent.getChildByName("player3NameContainer");
                            var text = container.getChildByName("player3NameText");
                            text.color = "white";
                            player3HitArea.cursor = "pointer";
                        }
                    })
                }


                var playerSprite = new createjs.Bitmap(queue.getResult("players"))
                playerSprite.x = 285;
                playerSprite.y = 462;
                playerSprite.scaleX = .9;
                playerSprite.scaleY = .9
                view.addChild(playerSprite);

                var player1Text = new createjs.Text(gameState.player1Name, "18px Arial Bold", "#fff");
                player1Text.name = "player1NameText";
                var player1NameTag = new createjs.Container();
                player1NameTag.name = "player1NameContainer";
                player1NameTag.x = 290;
                player1NameTag.y = 528;
                player1NameTag.addChild(player1Text);
                t = player1Text.getBounds();
                player1Text.x = (150 - t.width) / 2;
                //player1Text.shadow = standardTextShadow;


                var player1ScoreTextContainer = new createjs.Container();
                player1ScoreTextContainer.name = "player1ScoreTextContainer";
                var player1ScoreBackground = new createjs.Shape(new createjs.Graphics().beginFill("#ccc").drawRect(0, 0, 115, 30));

                t = player1ScoreText.getBounds();
                player1ScoreText.x = (115 - t.width) / 2;
                player1ScoreText.y = (30 - t.height) / 2;
                player1ScoreText.name = "player1ScoreText";
                player1ScoreText.text = "0";
                //player1ScoreText.shadow = standardTextShadow;

                player1ScoreTextContainer.x = 308;
                player1ScoreTextContainer.y = 554;

                player1ScoreTextContainer.addChild(player1ScoreBackground, player1ScoreText);
                view.addChild(player1ScoreTextContainer);


                if (gameState.playerCount > 1) {
                    var player2Text = new createjs.Text(gameState.player2Name, "18px Arial Bold", "#fff");
                    player2Text.name = "player2NameText";
                    var player2NameTag = new createjs.Container();
                    player2NameTag.name = "player2NameContainer";
                    player2NameTag.x = 460;
                    player2NameTag.y = 528;
                    player2NameTag.addChild(player2Text);
                    t = player2Text.getBounds();
                    player2Text.x = (150 - t.width) / 2;
                    //player2Text.shadow = standardTextShadow;
                    view.addChild(player2NameTag);

                    var player2ScoreTextContainer = new createjs.Container();
                    player2ScoreTextContainer.name = "player2ScoreTextContainer";
                    var player2ScoreBackground = new createjs.Shape(new createjs.Graphics().beginFill("#ccc").drawRect(0, 0, 115, 30));

                    t = player2ScoreText.getBounds();
                    player2ScoreText.x = (115 - t.width) / 2;
                    player2ScoreText.y = (30 - t.height) / 2;
                    //player2ScoreText.shadow = standardTextShadow;
                    player2ScoreText.text = "0";
                    player2ScoreText.name = "player2ScoreText";

                    player2ScoreTextContainer.x = 475;
                    player2ScoreTextContainer.y = 554;

                    player2ScoreTextContainer.addChild(player2ScoreBackground, player2ScoreText);
                    view.addChild(player2ScoreTextContainer);
                }

                if (gameState.playerCount == 3) {
                    var player3Text = new createjs.Text(gameState.player3Name, "18px Arial Bold", "#fff");
                    var player3NameTag = new createjs.Container();
                    player3Text.name = "player3NameText";
                    var player3NameTag = new createjs.Container();
                    player3NameTag.name = "player3NameContainer";
                    player3NameTag.x = 630;
                    player3NameTag.y = 528;
                    player3NameTag.addChild(player3Text);
                    t = player3Text.getBounds();
                    player3Text.x = (150 - t.width) / 2;

                    //player3Text.shadow = standardTextShadow;
                    view.addChild(player3NameTag);

                    var player3ScoreTextContainer = new createjs.Container();
                    player3ScoreTextContainer.name = "player3ScoreTextContainer";
                    var player3ScoreBackground = new createjs.Shape(new createjs.Graphics().beginFill("#ccc").drawRect(0, 0, 115, 30));

                    t = player3ScoreText.getBounds();
                    player3ScoreText.x = (115 - t.width) / 2;
                    player3ScoreText.y = (30 - t.height) / 2;
                    player3ScoreText.name = "player3ScoreText";
                    //player3ScoreText.shadow = standardTextShadow;
                    player3ScoreText.text = "0";

                    player3ScoreTextContainer.x = 642;
                    player3ScoreTextContainer.y = 554;

                    player3ScoreTextContainer.addChild(player3ScoreBackground, player3ScoreText);
                    view.addChild(player3ScoreTextContainer);
                }

                Timer = new createjs.Text("Test", "14px Arial bold", "white");
                Timer.x = 100;
                Timer.y = 560;
                Timer.visible = false;
                gameState.resetTimer();
                view.addChild(Timer);
                view.addChild(player1NameTag);

                var categoryX = 240;

                for (var i = 0; i < theCategories.length; i++) {
                    var categoryContainer = new createjs.Container();
                    var categoryContainerBG = new createjs.Shape(new createjs.Graphics().beginLinearGradientFill(["#CCC", "#EEE"], [.45, .7], 139, 90, 0, 0).drawRoundRect(0, 0, 140, 40, 3));
                    categoryContainer.x = (categoryX);
                    categoryContainer.y = 15;
                    var categoryText = new createjs.Text(theCategories[i].Name, "14pt Arial bold", "#333");
                    categoryText.lineWidth = 130;
                    var t = categoryText.getBounds();
                    categoryText.x = (140 - t.width) / 2;
                    categoryText.y = (40 - t.height) / 2;

                    categoryContainer.addChild(categoryContainerBG, categoryText);

                    view.addChild(categoryContainer);
                    categoryX = categoryX + 140;
                }

                for (var i = 0; i < squares.length; i++) {
                    var boardSquare = new createjs.Container();

                    var boardSquareText = new createjs.Text(squares[i].points, "20pt Arial bold", "white");
                    t = boardSquareText.getBounds();
                    boardSquareText.x = (139 - t.width) / 2;
                    boardSquareText.y = 25;
                    var boardSquareBackground = new createjs.Shape();

                    boardSquareBackground.graphics.beginLinearGradientFill(["#3D92CD", "#0D6A9C"], [.45, .7], 139, 90, 0, 0)
                    boardSquareBackground.graphics.drawRoundRect(0, 0, 139, 70, 5);
                    boardSquareBackground.graphics.endFill();
                    boardSquare.addChild(boardSquareBackground, boardSquareText);

                    boardSquare.x = (squares[i].x * 140 + 240);
                    boardSquare.y = (squares[i].y * 71 + 60);
                    boardSquare.question = squares[i].question;
                    boardSquare.points = squares[i].points;
                    boardSquare.name = squares[i].id;
                    boardSquare.isAnswered = false;


                    boardSquare.addEventListener("click", function (evt) {

                        if (gameState.answeredPreNextClick == false) {
                            var speechBubble = self.currentView.getChildByName("speechBubble");

                            if (speechBubble != null && speechBubble != "undefined") {
                                self.currentView.removeChild(speechBubble);

                            }
                            if (evt.currentTarget.isAnswered == false) {
                                if ((gameState.userSelectEnabled == true && gameState.currentQuestion == "") || (evt.currentTarget.question.isOpen == true && (gameState.playerControl != "" || gameState.playerControl != null))) {
                                    gameState.userSelectEnabled = true;
                                    gameState.currentQuestion = evt.currentTarget.question.Id;
                                    gameState.currentFeedback = evt.currentTarget.question.Feedback;
                                    evt.currentTarget.question.isOpen = true;

                                    var question = evt.currentTarget.question;



                                    if (isLmsConnected) {
                                        currentLmsInteraction = ScormHelper.cmi.interactions().new();

                                        currentLmsInteraction.id = question.Id;
                                        currentLmsInteraction.description = question.Text;
                                        currentLmsInteraction.type = ScormHelper.interactions.choice;

                                    }




                                    var questionContainer = new createjs.Container();
                                    questionContainer.name = "theOpenQuestion";
                                    gameState.usedQuestionCount = ++gameState.usedQuestionCount;
                                    var questionBackground = new createjs.Shape();
                                    questionBackground.graphics.beginLinearGradientFill(["#3D92CD", "#0D6A9C"], [.45, .7], 500, 90, 0, 0);
                                    questionBackground.graphics.drawRoundRect(0, 0, 560, 400, 5);
                                    questionBackground.graphics.endFill();
                                    var questionText = new createjs.Text(question.Text, "20pt Arial bold", "white");
                                    questionText.lineWidth = 520;
                                    questionText.maxWidth = 520;
                                    t = questionText.getBounds();
                                    questionText.x = 10;
                                    questionText.y = 30;

                                    questionContainer.addChild(questionBackground);
                                    questionContainer.addChild(questionText);
                                    questionContainer.x = 239;
                                    questionContainer.y = 15;

                                    ///////answer boxes ///////////////

                                    var startingHeight = questionContainer.getBounds().height;
                                    var positionOfLastbox = startingHeight + 60;
                                    var positionOfLastTermbox = 50;

                                    for (var j = 0; j < question.Answers.length; ++j) {

                                        var answer = question.Answers[j];
                                        answer.Feedback = question.Feedback;
                                        var possibleAnswer = new createjs.Text(answer.Text, "bold 16px Arial", "#fff");
                                        possibleAnswer.cursor = "pointer";
                                        //possibleAnswer.shadow = standardTextShadow;
                                        possibleAnswer.lineWidth = 460;

                                        var w = (possibleAnswer.getMeasuredWidth()) * possibleAnswer.scaleX;
                                        var h = (possibleAnswer.getMeasuredHeight()) * possibleAnswer.scaleY;
                                        possibleAnswer.x = 5;
                                        possibleAnswer.y = 4;
                                        var duration = 1000 + (Math.random() * 400 - 200); // 1 second +/- ~200ms

                                        var bg = new createjs.Shape();
                                        bg.graphics.beginFill("#666");
                                        bg.graphics.setStrokeStyle(1);
                                        bg.graphics.drawRoundRect(0, 0, 500, h + 10, 3);
                                        //bg.shadow = standardTextShadow;
                                        possibleAnswer.hitArea = bg;

                                        var hitArea = new createjs.Shape();
                                        hitArea.graphics.beginFill("#CCC");
                                        hitArea.graphics.setStrokeStyle(1);
                                        hitArea.graphics.drawRoundRect(0, 0, 500, h + 10, 3);

                                        possibleAnswer.hitArea = hitArea;

                                        var answerContainer = new createjs.Container();
                                        answerContainer.addChild(bg);
                                        answerContainer.addChild(possibleAnswer);

                                        answerContainer.x = 5;
                                        answerContainer.y = j == 0 ? positionOfLastbox : positionOfLastbox + 20;
                                        answerContainer.originalX = answerContainer.x;
                                        answerContainer.originalY = answerContainer.y;

                                        positionOfLastbox = answerContainer.y + h;
                                        view.addChild(answerContainer);
                                        ////////////////////////////////////////////////////////////////


                                        answerContainer.isCorrect = answer.IsCorrect;
                                        answerContainer.name = answer.IsCorrect ? "theCorrectAnswer" : "theWrongAnswer";
                                        answerContainer.points = evt.currentTarget.points;

                                        answerContainer.addEventListener("click", function (evt) {
                                            if (gameState.answeredPreNextClick == false) {

                                                createjs.Sound.stop("tickTock");
                                                if (gameState.playerControl != null) {
                                                    gameState.timerOn = false;

                                                    if (currentLmsInteraction != null) {
                                                        currentLmsInteraction.result = evt.currentTarget.isCorrect ? ScormHelper.results.correct : ScormHelper.results.incorrect;
                                                        currentLmsInteraction.save();
                                                        currentLmsInteraction = null;
                                                    }


                                                    if (evt.currentTarget.isCorrect) {
                                                        gameState.answeredPreNextClick = true;
                                                           
                                                          //  tickTock.pause();
                                                            createjs.Sound.stop("tickTock");
                                                        var scorer = gameState[gameState.playerControl];
                                                        gameState[gameState.playerControl] = scorer + evt.currentTarget.points;

                                                        createjs.Sound.play("correctAnswerDing");
                                                        if (speechBubble == null || speechBubble == "undefined") {
                                                            var speechBubble = new createjs.Container();
                                                            var bubblePic = new createjs.Bitmap(queue.getResult("speechBubble"));
                                                            speechBubble.x = 50;
                                                            speechBubble.y = 25;
                                                            speechBubble.scaleX = .8;
                                                            speechBubble.scaleY = .65;
                                                            speechBubble.addChild(bubblePic);
                                                            if (answer.Feedback) {
                                                                var theSpeechBubble = new createjs.Text("Correct! Good job!", "16pt Arial bold", "black");
                                                                theSpeechBubble.lineWidth = 190;
                                                                theSpeechBubble.x = 10;
                                                                theSpeechBubble.y = 5;
                                                                var feedback = new createjs.Text(answer.Feedback, "14pt Arial italic", "black");
                                                                feedback.y = (theSpeechBubble.getBounds().height + 15);
                                                                feedback.x = 10;
                                                                feedback.lineWidth = 200;
                                                                feedback.maxWidth = 200;
                                                                speechBubble.addChild(feedback);

                                                            } else {
                                                                var theSpeechBubble = new createjs.Text("Correct! Good job!", "24pt Arial bold", "black");
                                                                theSpeechBubble.lineWidth = 190;
                                                                theSpeechBubble.x = 20;
                                                                theSpeechBubble.y = 40;
                                                            }
                                                            speechBubble.addChild(theSpeechBubble);
                                                            speechBubble.name = "speechBubble";
                                                            view.addChild(speechBubble);
                                                        }


                                                    } else {
                                                        gameState.answeredPreNextClick = true;
                                                        createjs.Sound.stop("tickTock");
                                                        var scorer = gameState[gameState.playerControl];
                                                        gameState[gameState.playerControl] = scorer - evt.currentTarget.points;

                                                        createjs.Sound.play("incorrect");
                                                        if (speechBubble == null || speechBubble == "undefined") {
                                                            var speechBubble = new createjs.Container();
                                                            var bubblePic = new createjs.Bitmap(queue.getResult("speechBubble"));
                                                            speechBubble.addChild(bubblePic)
                                                            var theSpeechBubble = new createjs.Text("The correct answer is highlighted.", "18pt Arial bold", "black");
                                                            theSpeechBubble.lineWidth = 190;

                                                            //feedback
                                                            if (gameState.currentFeedback != null) {

                                                                var theSpeechBubbleFeedback = new createjs.Text(gameState.currentFeedback, "15pt Arial italilc", "black");
                                                                theSpeechBubbleFeedback.lineWidth = 200;
                                                                theSpeechBubbleFeedback.x = 5;
                                                                theSpeechBubbleFeedback.y = (theSpeechBubble.getBounds().height + 20);
                                                                speechBubble.addChild(theSpeechBubbleFeedback);
                                                            }
                                                            speechBubble.scaleX = .8;
                                                            speechBubble.scaleY = .65;
                                                            speechBubble.x = 50;
                                                            speechBubble.y = 25;

                                                            theSpeechBubble.x = 15;
                                                            theSpeechBubble.y = 5;

                                                            speechBubble.addChild(theSpeechBubble);
                                                            speechBubble.name = "speechBubble";
                                                            view.addChild(speechBubble);
                                                            var mustache = self.currentView.getChildByName("mustache");
                                                            var head = self.currentView.getChildByName("head");
                                                            var jaw = self.currentView.getChildByName("jaw");
                                                            createjs.Tween.get(head)
                                                           .to({ y: 225 }, 800)
                                                           .to({ y: 220 }, 200)
                                                           .to({ y: 225 }, 200)
                                                           .to({ y: 220 }, 200)
                                                           .to({ y: 225 }, 200)
                                                           .to({ y: 220 }, 200)
                                                           .to({ y: 225 }, 200)
                                                           .to({ y: 220 }, 200)
                                                           .to({ y: 225 }, 100)
                                                           .to({ y: 220 }, 100)
                                                           .to({ y: 225 }, 100)
                                                           .to({ y: 220 }, 100)
                                                            createjs.Tween.get(mustache)
                                                                .to({ y: 347 }, 800)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 100)
                                                                .to({ y: 337 }, 100)
                                                                .to({ y: 347 }, 100)
                                                                .to({ y: 337 }, 100)
                                                                .to({ rotation: -3 }, 200)
                                                                .to({ rotation: 3 }, 200)
                                                                .to({ rotation: -3 }, 200)
                                                                .to({ rotation: 3 }, 200)
                                                                .to({ rotation: 0 }, 200)
                                                            createjs.Tween.get(jaw)
                                                                 .to({ y: 365 }, 800)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 365 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 365 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 360 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 360 }, 100)
                                                                 .to({ y: 370 }, 100)
                                                                 .to({ y: 360 }, 100)
                                                                 .to({ y: 370 }, 100)

                                                        }

                                                    }

                                                    ////Highlight correct answer//////
                                                    var displayAnswer = evt.currentTarget.parent.getChildByName("theCorrectAnswer");
                                                    var positionOfLastbox = 0;
                                                    var positionOfLastTermbox = 50;
                                                    var correctText = displayAnswer.getChildAt(1);
                                                    var answerText = new createjs.Text(correctText.text, "bold 16px Arial", "#000");
                                                    answerText.x = 5;
                                                    answerText.y = 4;
                                                    answerText.cursor = "pointer";
                                                    //answerText.shadow = standardTextShadow;
                                                    answerText.lineWidth = 460;

                                                    var w = (answerText.getMeasuredWidth()) * answerText.scaleX;
                                                    var h = (answerText.getMeasuredHeight()) * answerText.scaleY;
                                                    var duration = 1000 + (Math.random() * 400 - 200); // 1 second +/- ~200ms

                                                    var box = new createjs.Shape();
                                                    box.graphics.beginFill("#fff");
                                                    box.graphics.setStrokeStyle(1);
                                                    box.graphics.drawRoundRect(0, 0, 500, h + 10, 3);
                                                    //box.shadow = standardTextShadow;
                                                    possibleAnswer.hitArea = box;

                                                    displayAnswer.addChild(box, answerText);

                                                    var textBoxContainer = gameState.playerControl + 'TextContainer';

                                                    evt.currentTarget.parent.removeChild(evt);

                                                    var boardSquareBackground = new createjs.Shape();

                                                    boardSquareBackground.graphics.beginLinearGradientFill(["#666", "#101010", "#666"], [.01, .35, .75], 139, 90, 0, 0);

                                                    boardSquareBackground.graphics.drawRoundRect(0, 0, 139, 70, 5);
                                                    boardSquareBackground.graphics.endFill();
                                                    var theSquare = self.currentView.getChildByName(gameState.currentQuestion);
                                                    theSquare.addChild(boardSquareBackground);
                                                    theSquare.isAnswered = true;
                                                    var textBoxName = gameState.playerControl + 'Text';
                                                    var textbox = evt.currentTarget.parent.parent.getChildByName(textBoxContainer).getChildByName(textBoxName);
                                                    textbox.text = gameState[gameState.playerControl];
                                                    t = textbox.getBounds()

                                                    textbox.x = t != null ? (115 - t.width) / 2 : 57.5;


                                                    var nextButtonContainer = new createjs.Container();
                                                    var nextBG = new createjs.Shape(new createjs.Graphics().beginFill("green").drawRoundRect(0, 0, 75, 30, 5));
                                                    var nextText = new createjs.Text("Next", "bold 16px Arial", "#fff");

                                                    nextButtonContainer.addChild(nextBG, nextText);
                                                    evt.currentTarget.parent.addChild(nextButtonContainer);

                                                    nextButtonContainer.x = 450;
                                                    nextButtonContainer.y = 350;
                                                    nextText.x = 20;
                                                    nextText.y = 5;
                                                    nextButtonContainer.addEventListener("click", function (evt) {

                                                        var theQuestionContainer = evt.currentTarget.parent;
                                                        self.currentView.removeChild(theQuestionContainer);
                                                        var theSpeechBubble = self.currentView.getChildByName("speechBubble");
                                                        self.currentView.removeChild(theSpeechBubble);
                                                        var playerHitArea = gameState.playerControl + "HitArea";
                                                        playerHitArea = self.currentView.getChildByName(playerHitArea);
                                                        playerHitArea.alpha = .2;
                                                        gameState.playerControl = null;


                                                        gameState.currentQuestion = "";
                                                        Timer.visible = false;
                                                        gameState.resetTimer()
                                                        if (gameState.usedQuestionCount >= theQuestions.length) {
                                                            showView(createWinnerView());
                                                        }
                                                    });

                                                } else {
                                                    if (!gameState.answeredPreNextClick) {
                                                        var speechBubble = self.currentView.getChildByName("speechBubble");
                                                        var mustache = self.currentView.getChildByName("mustache");
                                                        var head = self.currentView.getChildByName("head");
                                                        var jaw = self.currentView.getChildByName("jaw");
                                                        pleaseBuzzIn.play();

                                                        if (speechBubble == null || speechBubble == "undefined") {

                                                            var speechBubble = new createjs.Container();
                                                            var bubblePic = new createjs.Bitmap(queue.getResult("speechBubble"));
                                                            speechBubble.x = 50;
                                                            speechBubble.y = 25;
                                                            speechBubble.scaleX = .8;
                                                            speechBubble.scaleY = .65;
                                                            var theSpeechBubble = new createjs.Text("You must first buzz in.", "24pt Arial bold", "black");


                                                            theSpeechBubble.lineWidth = 180;
                                                            theSpeechBubble.x = 30;
                                                            theSpeechBubble.y = 40;
                                                            speechBubble.addChild(bubblePic, theSpeechBubble);
                                                            speechBubble.name = "speechBubble";
                                                            view.addChild(speechBubble);

                                                            createjs.Tween.get(head)
                                                                .to({ y: 225 }, 800)
                                                                .to({ y: 220 }, 200)
                                                                .to({ y: 225 }, 200)
                                                                .to({ y: 220 }, 200)
                                                                .to({ y: 225 }, 200)
                                                                .to({ y: 220 }, 200)
                                                                .to({ y: 225 }, 200)
                                                                .to({ y: 220 }, 200)
                                                                .to({ y: 225 }, 100)
                                                                .to({ y: 220 }, 100)

                                                            createjs.Tween.get(mustache)
                                                                .to({ y: 347 }, 800)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 100)
                                                                .to({ y: 337 }, 100)
                                                                .to({ rotation: -3 }, 200)
                                                                .to({ rotation: 3 }, 200)
                                                                .to({ rotation: -3 }, 200)
                                                                .to({ rotation: 3 }, 200)
                                                                .to({ rotation: 0 }, 200)
                                                            createjs.Tween.get(jaw)
                                                                 .to({ y: 365 }, 800)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 365 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 365 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 360 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 360 }, 100)
                                                                 .to({ y: 370 }, 100)

                                                        } else {

                                                            createjs.Tween.get(head)
                                                               .to({ y: 225 }, 800)
                                                               .to({ y: 220 }, 200)
                                                               .to({ y: 225 }, 200)
                                                               .to({ y: 220 }, 200)
                                                               .to({ y: 225 }, 200)
                                                               .to({ y: 220 }, 200)
                                                               .to({ y: 225 }, 200)
                                                               .to({ y: 220 }, 200)
                                                               .to({ y: 225 }, 100)
                                                               .to({ y: 220 }, 100)

                                                            createjs.Tween.get(mustache)
                                                                .to({ y: 347 }, 800)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 200)
                                                                .to({ y: 337 }, 200)
                                                                .to({ y: 347 }, 100)
                                                                .to({ y: 337 }, 100)
                                                                .to({ rotation: -3 }, 200)
                                                                .to({ rotation: 3 }, 200)
                                                                .to({ rotation: -3 }, 200)
                                                                .to({ rotation: 3 }, 200)
                                                                .to({ rotation: 0 }, 200)
                                                            createjs.Tween.get(jaw)
                                                                 .to({ y: 365 }, 800)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 365 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 365 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 360 }, 200)
                                                                 .to({ y: 370 }, 200)
                                                                 .to({ y: 360 }, 100)
                                                                 .to({ y: 370 }, 100)
                                                        }
                                                    }
                                                }
                                            }
                                        });
                                        var b = questionText.getBounds();
                                        answerContainer.x = 25;
                                        questionContainer.addChild(answerContainer);

                                    }

                                    view.addChild(questionContainer);
                                }

                            }
                        }
                    });

                    view.addChild(boardSquare);
                }

                return view;

            }

            function createWinnerView() {
                if (!musicOn) {
                    introSong.currentTime = 0;
                    introSong.play({ interrupt: createjs.Sound.INTERRUPT_ANY, loop: -1 });
                    fadeMusicIn = true;
                }
                var winnerScore = Math.max(gameState.player1Score, gameState.player2Score, gameState.player3Score);

                var player = "";
                var winnerCount = 0;
                if (gameState.player1Score == winnerScore) {
                    player = gameState.player1Name;
                    winnerCount = ++winnerCount;
                }
                if (gameState.player2Score == winnerScore) {
                    player = player + (winnerCount > 0 ? ", " : "") + gameState.player2Name;
                    winnerCount = ++winnerCount;
                }
                if (gameState.player3Score == winnerScore) {
                    player = player + (winnerCount > 0 ? ", " : "") + gameState.player3Name;
                    winnerCount = ++winnerCount;
                }


                var container = new createjs.Container(new createjs.Shape(new createjs.Graphics().beginFill("#ccc").drawRect(0, 0, stage.canvas.height, stage.canvas.width)));
                container.x = 285;
                container.y = 80;

                var title;

                if (player != "" && winnerScore > 0) {

                    title = player + "\n won! \n Score: " + winnerScore;
                    submitScore(winnerScore);

                }
                else {
                    title = "Nobody has a score over 0! Try again.";

                }

                var titleText = new createjs.Text(title, "30pt Arial Black", "black");
                //titleText.shadow = new createjs.Shadow("gray", 1, 1, 3);
                titleText.x = 130;
                titleText.y = 50;
                titleText.lineWidth = 300;
                titleText.textAlign = "center";
                titleText.textBaseline = "middle";

                var startOverButton = new createjs.Container();
                startOverButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawRect(0, 0, 200, 35));
                startOverButton.x = 130;
                startOverButton.y = 250;
                startOverButton.regX = 100;
                startOverButton.regY = 35;
                startOverButton.cursor = 'pointer';
                startOverButton.addChild(new createjs.Shape(new createjs.Graphics().setStrokeStyle(1).beginStroke("dark gray").beginFill("#35B000").drawRoundRect(0, 0, 200, 35, 5).endFill()));
                //startOverButton.shadow = new createjs.Shadow("gray", 3, 3, 5);

                var startOverText = new createjs.Text("Start Over", "20pt Arial", "white");
                startOverText.textAlign = "center";
                startOverText.textBaseline = "middle";
                startOverText.x = 100;
                startOverText.y = 17.5;
                //startOverText.shadow = new createjs.Shadow("gray", 1, 1, 3);
                if (!isLmsConnected) {
                    startOverButton.addChild(startOverText)
                }
                var rematchButton = new createjs.Container();
                rematchButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawRect(0, 0, 200, 35));
                rematchButton.x = 130;
                rematchButton.y = 300;
                rematchButton.regX = 100;
                rematchButton.regY = 35;
                rematchButton.cursor = 'pointer';
                rematchButton.addChild(new createjs.Shape(new createjs.Graphics().setStrokeStyle(1).beginStroke("dark gray").beginFill("#35B000").drawRoundRect(0, 0, 200, 35, 5).endFill()));
                //rematchButton.shadow = new createjs.Shadow("gray", 3, 3, 5);

                var rematchText = new createjs.Text("Rematch", "20pt Arial", "white");
                rematchText.textAlign = "center";
                rematchText.textBaseline = "middle";
                rematchText.x = 100;
                rematchText.y = 17.5;
                //rematchText.shadow = new createjs.Shadow("gray", 1, 1, 3);
                if (!isLmsConnected) {
                    rematchButton.addChild(rematchText)
                }
                // only show the quit text if we're on a mobile device!
                if (isLmsConnected || navigator.userAgent.match(/Android/i)
                || navigator.userAgent.match(/webOS/i)
                || navigator.userAgent.match(/iPhone/i)
                || navigator.userAgent.match(/iPad/i)
                || navigator.userAgent.match(/iPod/i)
                || navigator.userAgent.match(/BlackBerry/i)
                || navigator.userAgent.match(/Windows Phone/i)
                ) {
                    var quitButton = new createjs.Container();
                    quitButton.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#f00").drawRect(0, 0, 200, 35));
                    quitButton.x = 130;
                    quitButton.y = 350;
                    quitButton.regX = 100;
                    quitButton.regY = 35;
                    quitButton.cursor = 'pointer';
                    quitButton.addChild(new createjs.Shape(new createjs.Graphics().setStrokeStyle(1).beginStroke("dark gray").beginFill("#35B000").drawRoundRect(0, 0, 200, 35, 5).endFill()));
                    //quitButton.shadow = new createjs.Shadow("gray", 3, 3, 5);

                    var quitText = new createjs.Text("Quit", "20pt Arial", "white");
                    quitText.textAlign = "center";
                    quitText.textBaseline = "middle";
                    quitText.x = 100;
                    quitText.y = 17.5;
                    //quitText.shadow = new createjs.Shadow("gray", 1, 1, 3);
                    quitButton.addChild(quitText)
                }

                var mouseOverCallback = function (event) {
                    var target = event.currentTarget;
                    createjs.Tween.get(target).to({ scaleX: 1.0625, scaleY: 1.0625 }, 100);
                };

                var mouseOutCallback = function (event) {
                    var target = event.currentTarget;
                    createjs.Tween.get(target).to({ scaleX: 1.0, scaleY: 1.0 }, 200);

                    target.getChildAt(0).graphics.clear().setStrokeStyle(1).beginStroke("dark gray").beginFill("#35B000").drawRoundRect(0, 0, 200, 35, 5).endFill();
                };

                var mouseDownCallback = function (event) {
                    var target = event.currentTarget.getChildAt(0);

                    target.graphics.clear().setStrokeStyle(1).beginStroke("dark gray").beginFill("#369713").drawRoundRect(0, 0, 200, 35, 5).endFill();
                };

                if (!isLmsConnected) {
                    startOverButton.on("mouseover", mouseOverCallback);
                    startOverButton.on("mouseout", mouseOutCallback);
                    startOverButton.on("mousedown", mouseDownCallback)
                    startOverButton.addEventListener("click", startOver);

                    rematchButton.on("mouseover", mouseOverCallback);
                    rematchButton.on("mouseout", mouseOutCallback);
                    rematchButton.on("mousedown", mouseDownCallback)
                    rematchButton.addEventListener("click", rematch);
                }
                if (isLmsConnected || navigator.userAgent.match(/Android/i)
               || navigator.userAgent.match(/webOS/i)
               || navigator.userAgent.match(/iPhone/i)
               || navigator.userAgent.match(/iPad/i)
               || navigator.userAgent.match(/iPod/i)
               || navigator.userAgent.match(/BlackBerry/i)
               || navigator.userAgent.match(/Windows Phone/i)
               ) {
                    quitButton.on("mouseover", mouseOverCallback);
                    quitButton.on("mouseout", mouseOutCallback);
                    quitButton.on("mousedown", mouseDownCallback)
                    quitButton.addEventListener("click", quit);
                }
                container.addChild(titleText, quitButton);
                if (!isLmsConnected) {
                    container.addChild(startOverButton, rematchButton);
                }
                container.name = "WinnerView";
                return container;
            }

            function rematch() {
                gameState.player1Score = 0;
                gameState.player2Score = 0;
                gameState.player3Score = 0;
                gameState.userSelectEnabled = true;
                gameState.gameOn = false;
                gameState.playerControl = null;
                gameState.timerOn = false;
                gameState.resetTimer();
                gameState.currentQuestion = "";
                gameState.usedQuestionCount = 0;
                showView(createMatchupView());

            }

            function startOver() {
                gameState.player1Score = 0;
                gameState.player2Score = 0;
                gameState.player3Score = 0;
                gameState.player1Name = null;
                gameState.player2Name = null;
                gameState.player3Name = null;
                gameState.userSelectEnabled = true;
                gameState.gameOn = false;
                gameState.playerControl = null;
                gameState.timerOn = false;
                gameState.resetTimer();
                gameState.currentQuestion = "";
                gameState.usedQuestionCount = 0;

                isTwoPlayer = false;
                isThreePlayer = false;
                showView(createTitleView());
            }


            var quit;

            if (isLmsConnected) {
                quit = function () {

                    ScormHelper.cmi.completionStatus(ScormHelper.completionStatus.completed);
                    ScormHelper.cmi.successStatus(ScormHelper.successStatus.passed);

                  //  isLmsConnected = false;
                   // currentLmsInteraction = null;

                    ScormHelper.cmi.exit("");
                    ScormHelper.adl.nav.request("exitAll");
                    ScormHelper.terminate();
                }
            }
            else {
                quit = function () {
                    window.location = "http://www.wisc-online.com";
                }
            }


            function handleUserBuzzIn(pressed) {
                if (gameState.userSelectEnabled == true && gameState.gameOn && gameState.currentQuestion != "" && (gameState.playerControl == "" || gameState.playerControl == null) && gameState.answeredPreNextClick == false) {


                    var speechBubble = self.currentView.getChildByName("speechBubble");
                    if (speechBubble != null) {
                        self.currentView.removeChild(speechBubble);
                    }

                    if (pressed == "a" || pressed == "A") {
                 
                            buzzIn.play();
                 
                        gameState.playerControl = "player1Score";
                        gameState.timerOn = true;
                        buzzIn.on("complete", function () { tickTock.play(volume = 1); });
                    } else if (isTwoPlayer && (pressed == "b" || pressed == "B")) {
                  
                            buzzIn.play();
               
                        gameState.playerControl = "player2Score";
                        gameState.timerOn = true;
                        tickTock.play(volume = 1);

                    } else if (isThreePlayer && (pressed == "l" || pressed == "L")) {
                  
                            buzzIn.play();
                
                        gameState.playerControl = "player3Score";
                        gameState.timerOn = true;
                        tickTock.play(volume = 1);
                    }
                }

            }

            $(document).on("keypress", function (e) {

                var unicode = e.charCode ? e.charCode : e.keyCode;
                var pressed = String.fromCharCode(unicode)
                handleUserBuzzIn(pressed);

            });



            self.previousView = null;
            self.currentView = null;
            function showView(view) {

                // TODO: add transition animation (fade)

                if (self.currentView) {
                    stage.removeChild(self.currentView);
                    self.previousView = self.currentView;
                }
                else {
                    self.previousView = null;
                }

                if (view) {
                    stage.addChild(view);
                    self.currentView = view;
                }
                else {
                    self.currentView = null;
                }


                if (self.currentView == instructionsView) {
                    if (self.previousView.name == "CreatePlayers") {
                        if (gameState.playerCount >= 1) {
                            player1NameInput.style.visibility = "hidden";
                        }
                        if (gameState.playerCount >= 2) {
                            player2NameInput.style.visibility = "hidden";
                        }
                        if (gameState.playerCount == 3) {
                            player3NameInput.style.visibility = "hidden";
                        }
                    }
                    stage.removeChild(instructionsContainer);
                } else {
                    if (self.currentView.name == "CreatePlayers" && self.previousView.name == "InstructionsView") {

                        self.previousView = createNumberOfPlayersView();


                        if (gameState.playerCount >= 1) {
                            player1NameInput.style.visibility = "show";
                        }

                        if (gameState.playerCount >= 2) {
                            player2NameInput.style.visibility = "show";
                        }
                        if (gameState.playerCount == 3) {
                            player3NameInput.style.visibility = "show";
                        }


                    }
                    stage.addChild(instructionsContainer);
                    stage.addChild(soundContainer);
                }




                stage.update();
            };

            var soundContainer = new createjs.Container();
            soundContainer.x = 0;
            soundContainer.y = 0;
            soundContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 50, 50));
            soundContainer.cursor = 'pointer';
            var bg = new createjs.Bitmap(queue.getResult("instructions_background"));
            bg.rotation = 90;
            bg.x = 50;
            bg.y = 0;
            soundContainer.addChild(bg);
            var sound = new createjs.Bitmap(queue.getResult("musicOn"));
            sound.name = "musicOnImage"
            sound.scaleX = .75;
            sound.scaleY = .75;
            soundContainer.addChild(sound);


            var instructionsContainer = new createjs.Container();
            instructionsContainer.x = 0;
            instructionsContainer.y = 550;
            instructionsContainer.hitArea = new createjs.Shape(new createjs.Graphics().beginFill("#F00").drawCircle(0, 50, 50));
            instructionsContainer.cursor = 'pointer';

            instructionsContainer.addChild(new createjs.Bitmap(queue.getResult("instructions_background")));

            var questionMark = new createjs.Bitmap(queue.getResult("instructions_question"));

            instructionsContainer.addChild(questionMark);

            stage.addChild(instructionsContainer, soundContainer);
            soundContainer.addEventListener("click", function (evt) {
                if (musicOn == true) {

                    musicOn = false;
                    var sound = new createjs.Bitmap(queue.getResult("musicOff"));
                    sound.scaleX = .75;
                    sound.scaleY = .75;
                    sound.name = "musicOffImage"
                    var destroy = evt.currentTarget.getChildByName("musicOnImage");
                    evt.currentTarget.removeChild(destroy);
                    evt.currentTarget.addChild(sound);
                    createjs.Sound.setMute(true);

                } else {
                    musicOn = true;
                    var sound = new createjs.Bitmap(queue.getResult("musicOn"));
                    sound.scaleX = .75;
                    sound.scaleY = .75;
                    sound.name = "musicOnImage"
                    var destroy = evt.currentTarget.getChildByName("musicOffImage");
                    evt.currentTarget.removeChild(destroy);
                    evt.currentTarget.addChild(sound);
                    createjs.Sound.setMute(false);

                }
            });
            instructionsContainer.addEventListener("click", function () {
                showView(getInstructionsView());
            });
            var instructionsView = null;

            function getInstructionsView() {

                if (instructionsView == null) {
                    instructionsView = createInstructionsView();
                    instructionsView.name = "InstructionsView";
                }

                return instructionsView;
            }
            function handleInstructionsMouseOver(event) {
                if (event.type == "mouseover") {
                    createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0625, scaleY: 1.0625 }, 50);
                }
                else {
                    createjs.Tween.get(questionMark, { loop: false }).to({ scaleX: 1.0, scaleY: 1.0 }, 50);
                }
            }

            instructionsContainer.on("mouseover", handleInstructionsMouseOver);
            instructionsContainer.on("mouseout", handleInstructionsMouseOver);

            showView(createTitleView());
            createjs.Ticker.addEventListener("tick", stage);
            ///////end InitializeGame function///////
        };
        //////end Game function///////////////////////////
    }

    return Game;


})(createjs, $);




